/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.environment;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.scripting.AbstractScriptType;
import com.ibm.team.apt.internal.common.scripting.AbstractWrapperScriptType;
import com.ibm.team.apt.internal.common.scripting.IScriptEnvironment;
import com.ibm.team.apt.internal.common.scripting.ScriptEnvironmentSetupException;
import com.ibm.team.apt.internal.common.scripting.annotation.Constant;
import com.ibm.team.apt.internal.common.scripting.annotation.Constructor;
import com.ibm.team.apt.internal.common.scripting.annotation.Function;
import com.ibm.team.apt.internal.common.scripting.annotation.Property;
import com.ibm.team.apt.internal.common.scripting.annotation.ScriptType;
import com.ibm.team.apt.internal.common.scripting.environment.IScriptEnvironmentFeature;
import com.ibm.team.apt.internal.common.scripting.impl.ScriptTypeConstructor;
import com.ibm.team.apt.internal.common.scripting.impl.ScriptTypeFunction;
import com.ibm.team.apt.internal.common.scripting.util.JSUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptTypeFeature<T extends AbstractScriptType>
implements IScriptEnvironmentFeature {
    private final Class<T> fFacadeClass;

    public ScriptTypeFeature(Class<T> facadeClass) {
        this.fFacadeClass = facadeClass;
    }

    @Override
    public void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) throws ScriptEnvironmentSetupException {
        try {
            if (AbstractWrapperScriptType.class.isAssignableFrom(this.fFacadeClass)) {
                scriptEnvironment.getWrapFactory().registerWrapper(this.fFacadeClass);
            }
            this.createAndRegisterConstructor(cx, scope);
        }
        catch (Exception e) {
            throw new ScriptEnvironmentSetupException(e);
        }
    }

    protected Class<T> getFacadeClass() {
        return this.fFacadeClass;
    }

    private void createAndRegisterConstructor(Context cx, Scriptable scope) {
        String typeName = this.fFacadeClass.getAnnotation(ScriptType.class).value();
        ScriptTypeConstructor scriptConstructor = null;
        java.lang.reflect.Constructor<?>[] constructorArray = this.fFacadeClass.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.reflect.Constructor<?> scriptTypeConstructor = constructorArray[n2];
            if (scriptTypeConstructor.getAnnotation(Constructor.class) != null) {
                Class<?>[] parameterTypes = scriptTypeConstructor.getParameterTypes();
                if (parameterTypes.length < 2 || parameterTypes[0] != Context.class || parameterTypes[1] != Scriptable.class) {
                    APTCommonPlugin.log(String.format("WARNING: skipped declared constructor of type '%s' due to an invalid signature", typeName), new Exception());
                } else {
                    scriptConstructor = new ScriptTypeConstructor(cx, scope, scriptTypeConstructor);
                    break;
                }
            }
            ++n2;
        }
        if (scriptConstructor == null) {
            scriptConstructor = new ScriptTypeConstructor(cx, scope, this.fFacadeClass);
        }
        ScriptType annotation = this.fFacadeClass.getAnnotation(ScriptType.class);
        JSUtils.dojoProvide(Context.getCurrentContext(), scope, annotation.value());
        JSUtils.setObject(cx, scope, annotation.value(), (Object)scriptConstructor);
        HashMap<String, Method[]> getterSetterProperties = new HashMap<String, Method[]>();
        ScriptableObject prototype = scriptConstructor.getScriptTypePrototype();
        Class<Object> facadeClass = this.fFacadeClass;
        while (true) {
            String name;
            AccessibleObject[] accessibleObjectArray = facadeClass.getDeclaredMethods();
            int n3 = accessibleObjectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Constant constanctAnnotation;
                Property propertyAnnotation;
                Method method = accessibleObjectArray[n4];
                if (method.getAnnotation(Function.class) != null) {
                    ScriptTypeFunction functionDelegate = new ScriptTypeFunction(scope, method);
                    if (Modifier.isStatic(method.getModifiers())) {
                        ScriptableObject.putProperty((Scriptable)scriptConstructor, (String)functionDelegate.getFunctionName(), (Object)((Object)functionDelegate));
                    } else {
                        ScriptableObject.putProperty((Scriptable)prototype, (String)functionDelegate.getFunctionName(), (Object)((Object)functionDelegate));
                    }
                }
                if ((propertyAnnotation = method.getAnnotation(Property.class)) != null) {
                    name = propertyAnnotation.name();
                    Method[] getterSetterMethods = (Method[])getterSetterProperties.get(name);
                    if (getterSetterMethods == null) {
                        getterSetterMethods = new Method[2];
                        getterSetterProperties.put(name, getterSetterMethods);
                    }
                    getterSetterMethods[propertyAnnotation.accessor() == Property.Kind.Getter ? 0 : 1] = method;
                }
                if ((constanctAnnotation = method.getAnnotation(Constant.class)) != null) {
                    String name2;
                    String string = name2 = "".equals(constanctAnnotation.value()) ? method.getName() : constanctAnnotation.value();
                    if (!Modifier.isStatic(method.getModifiers())) {
                        APTCommonPlugin.log(String.format("WARNING: skipped non-static const '%s' on type '%s'", name2, typeName), new Exception());
                    } else {
                        scriptConstructor.defineProperty(name2, null, method, null, 5);
                    }
                }
                ++n4;
            }
            accessibleObjectArray = facadeClass.getDeclaredFields();
            n3 = accessibleObjectArray.length;
            n4 = 0;
            while (n4 < n3) {
                AccessibleObject field = accessibleObjectArray[n4];
                Constant constanctAnnotation = ((Field)field).getAnnotation(Constant.class);
                if (constanctAnnotation != null) {
                    String string = name = "".equals(constanctAnnotation.value()) ? ((Field)field).getName() : constanctAnnotation.value();
                    if (!Modifier.isStatic(((Field)field).getModifiers())) {
                        APTCommonPlugin.log(String.format("WARNING: skipped non-static const '%s' on type '%s'", name, typeName), new Exception());
                    } else {
                        try {
                            ScriptableObject.putProperty((Scriptable)scriptConstructor, (String)name, (Object)ScriptRuntime.toObject((Scriptable)scope, (Object)((Field)field).get(null)));
                        }
                        catch (Exception e) {
                            APTCommonPlugin.log(String.format("WARNING: failed to define constant '%s' on type '%s'", ((Field)field).getName(), typeName), e);
                        }
                    }
                }
                ++n4;
            }
            Class<T> superclass = facadeClass.getSuperclass();
            if (superclass == AbstractScriptType.class || superclass.getAnnotation(ScriptType.class) != null) break;
            facadeClass = superclass.asSubclass(AbstractScriptType.class);
        }
        for (Map.Entry entry : getterSetterProperties.entrySet()) {
            prototype.defineProperty((String)entry.getKey(), null, ((Method[])entry.getValue())[0], ((Method[])entry.getValue())[1], 4);
        }
    }
}

