/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.environment;

import com.ibm.team.apt.internal.common.scripting.environment.AbstractScriptFeature;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ProcessAttachmentScriptFeature
extends AbstractScriptFeature {
    private final IAuditableCommon fAuditableCommon;
    private final IProcessAttachment fProcessAttachment;

    public ProcessAttachmentScriptFeature(IProcessAttachment processAttachment, IAuditableCommon auditableCommon) {
        Assert.isNotNull((Object)processAttachment);
        this.fProcessAttachment = processAttachment;
        this.fAuditableCommon = auditableCommon;
    }

    protected Reader getInputReader() throws IOException {
        String encoding = this.fProcessAttachment.getContent().getCharacterEncoding();
        IContent content = this.fProcessAttachment.getContent();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            this.fAuditableCommon.retrieveContent(content, (OutputStream)outStream, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TeamRepositoryException e) {
            throw new IOException(e.getMessage());
        }
        return new InputStreamReader((InputStream)new ByteArrayInputStream(outStream.toByteArray()), encoding != null ? encoding : "UTF-8");
    }

    public int getLineNumber() {
        return 1;
    }

    public String getSourceName() {
        return this.fProcessAttachment.getName();
    }

    public Timestamp getLastModifiedTime(Locale locale) throws IOException {
        return null;
    }
}

