/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting;

import com.ibm.team.apt.internal.common.scripting.impl.JavaScriptTypes;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptable
implements Scriptable {
    private final Map<String, PropertyContainer> fProperties = new ConcurrentHashMap<String, PropertyContainer>();
    private Scriptable fParentScope;
    private Scriptable fPrototype;

    public void defineProperty(String name, Object value, EnumSet<PropertyAttribute> attributes) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        if (propertyContainer == null || !propertyContainer.isAttribute(PropertyAttribute.READONLY)) {
            this.fProperties.put(name, new ValuePropertyContainer(value, attributes));
        }
    }

    public void defineProperty(String name, Method getter, Method setter, EnumSet<PropertyAttribute> attributes) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        if (propertyContainer == null || !propertyContainer.isAttribute(PropertyAttribute.READONLY)) {
            this.fProperties.put(name, new GetterSetterPropertyContainer(getter, setter, attributes));
        }
    }

    public Scriptable getParentScope() {
        return this.fParentScope;
    }

    public void setParentScope(Scriptable parent) {
        this.fParentScope = parent;
    }

    public Scriptable getPrototype() {
        return this.fPrototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.fPrototype = prototype;
    }

    public Object get(int index, Scriptable start) {
        return this.get(Integer.toString(index), start);
    }

    public Object get(String name, Scriptable start) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        return propertyContainer != null ? propertyContainer.getValue(start) : Scriptable.NOT_FOUND;
    }

    public boolean has(int index, Scriptable start) {
        return this.has(Integer.toString(index), start);
    }

    public boolean has(String name, Scriptable start) {
        return this.fProperties.containsKey(name);
    }

    public void put(int index, Scriptable start, Object value) {
        this.put(Integer.toString(index), start, value);
    }

    public void put(String name, Scriptable start, Object value) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        if (propertyContainer == null) {
            this.fProperties.put(name, new ValuePropertyContainer(value));
        } else if (!propertyContainer.isAttribute(PropertyAttribute.READONLY)) {
            propertyContainer.setValue(start, value);
        }
    }

    public void delete(int index) {
        this.delete(Integer.toString(index));
    }

    public void delete(String name) {
        PropertyContainer propertyContainer = this.fProperties.get(name);
        if (propertyContainer == null && !propertyContainer.isAttribute(PropertyAttribute.PERMANENT)) {
            this.fProperties.remove(name);
        }
    }

    public Object getDefaultValue(Class hint) {
        return ScriptableObject.getDefaultValue((Scriptable)this, (Class)hint);
    }

    public Object[] getIds() {
        ArrayList<String> result = null;
        for (Map.Entry<String, PropertyContainer> entry : this.fProperties.entrySet()) {
            if (entry.getValue().isAttribute(PropertyAttribute.DONTENUM)) continue;
            if (result == null) {
                result = new ArrayList<String>(this.fProperties.size());
            }
            result.add(entry.getKey());
        }
        return result != null ? result.toArray() : ScriptRuntime.emptyArgs;
    }

    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo((Scriptable)instance, (Scriptable)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetterSetterPropertyContainer
    extends PropertyContainer {
        private Method fGetter;
        private JavaScriptTypes fGetterResultType;
        private Method fSetter;
        private JavaScriptTypes fSetterArgumentType;
        private Class<?> fSetterArgumentJavaType;

        public GetterSetterPropertyContainer(Method getter, Method setter) {
            this(getter, setter, EnumSet.noneOf(PropertyAttribute.class));
        }

        public GetterSetterPropertyContainer(Method getter, Method setter, EnumSet<PropertyAttribute> attributes) {
            super(attributes);
            Assert.isNotNull((Object)getter);
            Assert.isTrue((getter.getParameterTypes().length == 0 ? 1 : 0) != 0);
            Assert.isTrue((getter.getReturnType() != Void.TYPE ? 1 : 0) != 0);
            this.fGetter = getter;
            this.fGetterResultType = JavaScriptTypes.getType(getter.getReturnType());
            if (setter != null) {
                this.fSetter = setter;
                Assert.isTrue((setter.getParameterTypes().length == 1 ? 1 : 0) != 0);
                this.fSetterArgumentType = JavaScriptTypes.getType(setter.getParameterTypes()[0]);
                this.fSetterArgumentJavaType = setter.getParameterTypes()[0];
            }
        }

        @Override
        public Object getValue(Scriptable start) {
            try {
                return this.fGetterResultType.convertToScript(Context.getCurrentContext(), AbstractScriptable.this.getParentScope(), this.fGetter.invoke((Object)start, ScriptRuntime.emptyArgs), this.fGetter.getReturnType());
            }
            catch (Exception e) {
                return Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }

        @Override
        public void setValue(Scriptable start, Object value) {
            try {
                if (this.fSetter != null) {
                    this.fSetter.invoke((Object)start, this.fSetterArgumentType.convertToJava(Context.getCurrentContext(), AbstractScriptable.this.getParentScope(), value, this.fSetterArgumentJavaType));
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyAttribute {
        READONLY,
        DONTENUM,
        PERMANENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class PropertyContainer {
        private final EnumSet<PropertyAttribute> fAttributes;

        public PropertyContainer(EnumSet<PropertyAttribute> attributes) {
            this.fAttributes = attributes;
        }

        public abstract Object getValue(Scriptable var1);

        public abstract void setValue(Scriptable var1, Object var2);

        public boolean isAttribute(PropertyAttribute attribute) {
            return this.fAttributes.contains((Object)attribute);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValuePropertyContainer
    extends PropertyContainer {
        private Object fValue;

        public ValuePropertyContainer(Object value) {
            this(value, EnumSet.noneOf(PropertyAttribute.class));
        }

        public ValuePropertyContainer(Object value, EnumSet<PropertyAttribute> attributes) {
            super(attributes);
            this.fValue = value;
        }

        @Override
        public Object getValue(Scriptable start) {
            return this.fValue;
        }

        @Override
        public void setValue(Scriptable start, Object value) {
            this.fValue = value;
        }
    }
}

