/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.ElementPath;
import com.ibm.team.apt.internal.common.process.ICachingSupport;
import com.ibm.team.apt.internal.common.process.IConfigurationElementMassage;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.Path;
import com.ibm.team.apt.internal.common.process.ValueComputer;
import com.ibm.team.apt.internal.common.util.Empty;
import com.ibm.team.apt.internal.common.util.IFilter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodeBasedValueComputer
extends ValueComputer {
    private INode fNode;
    private INodeProvider fProvider;
    private IProgressMonitor fMonitor;
    private List<IConfigurationElementMassage<?>> fMassages;
    private int fFlags;

    NodeBasedValueComputer(INode node, INodeProvider provider, List<IConfigurationElementMassage<?>> massages, int flags, IProgressMonitor monitor) {
        this.fNode = node;
        this.fProvider = provider;
        this.fMassages = massages;
        this.fFlags = flags;
        this.fMonitor = monitor;
    }

    @Override
    public HashMap<String, Object> computeValues(Class<?> type) throws TeamRepositoryException {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>((int)((float)(type.getMethods().length / 2) * 1.3f));
            Iterator<Method> iter = this.getterIterator(type);
            while (iter.hasNext()) {
                this.computeValue(values, iter.next(), this.fNode);
            }
            HashMap<String, Object> hashMap = values;
            return hashMap;
        }
        finally {
            this.dispose();
        }
    }

    private void dispose() {
        this.fNode = null;
        this.fProvider = null;
        this.fMassages = null;
        this.fMonitor = null;
    }

    private void computeValue(Map<String, Object> values, Method method, INode element) throws TeamRepositoryException {
        Path annotation = method.getAnnotation(Path.class);
        if (annotation == null) {
            return;
        }
        String key = ConfigurationElements.key(annotation);
        ElementPath path = ElementPath.valueOf(key);
        List<String> segments = path.getSegments();
        String attribute = path.getAttribute();
        List<INode> elements = ConfigurationElements.select(element, segments);
        Class<?> returnType = method.getReturnType();
        if (!returnType.isArray() && elements.size() != 1) {
            this.checkStrict("Can't find data element for {0}@{1}. Expected one element, but found {3}.", annotation, method.getName(), elements);
        }
        if (returnType.isArray()) {
            Object array = Array.newInstance(returnType.getComponentType(), elements.size());
            ListIterator<INode> iter = elements.listIterator();
            while (iter.hasNext()) {
                Array.set(array, iter.nextIndex(), this.toReturnValue(null, method, attribute, iter.next()));
            }
            values.put(key, array);
        } else {
            values.put(key, this.toReturnValue(values, method, attribute, elements.isEmpty() ? null : elements.iterator().next()));
        }
    }

    private void checkStrict(String msg, Object ... bindings) throws TeamRepositoryException {
        if ((this.fFlags & 8) != 0) {
            throw new TeamRepositoryException(NLS.bind((String)msg, (Object[])bindings, (Object[])new Object[0]));
        }
    }

    private Object toReturnValue(Map<String, Object> values, Method method, String attribute, INode element) throws TeamRepositoryException {
        Class<?> returnType = method.getReturnType().isArray() ? method.getReturnType().getComponentType() : method.getReturnType();
        if (element == null) {
            return ConfigurationElements.defaultValue(returnType);
        }
        String value = element.getAttribute(attribute);
        if (value == null && !ConfigurationElements.isConfigurationDataType(returnType)) {
            return ConfigurationElements.defaultValue(returnType);
        }
        if (ConfigurationElements.isConfigurationDataType(returnType)) {
            Path path = method.getAnnotation(Path.class);
            Object result = null;
            if (Empty.is(path.to())) {
                List<?> list = ConfigurationElementFactory.allInstances(returnType, element);
                result = list.isEmpty() ? ConfigurationElements.defaultValue(returnType) : list.get(0);
            } else {
                if (this.fProvider instanceof ICachingSupport) {
                    result = ((ICachingSupport)this.fProvider).get(value, returnType);
                }
                if (path.refines()) {
                    result = null;
                }
                if (result == null) {
                    int flags = 8 | (path.refines() ? 16 : 0);
                    result = ConfigurationElementFactory.singleInstance(returnType, new Filter(path.to(), value), this.fProvider, this.fMassages, flags, this.fMonitor);
                    if (result == null) {
                        this.checkStrict("Reference problem: Unable to find {0} with id {1}.", returnType.getSimpleName(), value);
                    }
                }
            }
            if (path.refines()) {
                Object instance = ConfigurationElementFactory.newInstance(returnType, element, this.fProvider, this.fMassages, 16, null);
                ConfigurationElements.merge(result, instance);
            }
            return result;
        }
        if (String.class.isAssignableFrom(returnType)) {
            return value;
        }
        if (URI.class.isAssignableFrom(returnType)) {
            try {
                return URI.create(value);
            }
            catch (IllegalArgumentException e) {
                APTCommonPlugin.log(e.getLocalizedMessage(), e);
                return null;
            }
        }
        if (Enum.class.isAssignableFrom(returnType)) {
            return Enum.valueOf(returnType.asSubclass(Enum.class), value);
        }
        if (Boolean.class.isAssignableFrom(returnType) || Boolean.TYPE.equals(returnType)) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class.isAssignableFrom(returnType) || Byte.TYPE.equals(returnType)) {
            return Byte.parseByte(value);
        }
        if (Short.class.isAssignableFrom(returnType) || Short.TYPE.equals(returnType)) {
            return Short.parseShort(value);
        }
        if (Integer.class.isAssignableFrom(returnType) || Integer.TYPE.equals(returnType)) {
            return Integer.parseInt(value);
        }
        if (Long.class.isAssignableFrom(returnType) || Long.TYPE.equals(returnType)) {
            return Long.parseLong(value);
        }
        if (Float.class.isAssignableFrom(returnType) || Float.TYPE.equals(returnType)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.isAssignableFrom(returnType) || Double.TYPE.equals(returnType)) {
            return Double.parseDouble(value);
        }
        throw new IllegalArgumentException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Filter
    implements IFilter<INode> {
        private final String fAttributeName;
        private final String fLeft;

        public Filter(String key, String left) {
            this.fAttributeName = ElementPath.valueOf(key).getAttribute();
            this.fLeft = left;
        }

        @Override
        public boolean accept(INode element) {
            String right = element.getAttribute(this.fAttributeName);
            return right == this.fLeft || right != null && right.equals(this.fLeft);
        }
    }
}

