/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.common.UUID;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IConfigurationElement;

public interface INode {
    public static final NodeFactory FACTORY = new NodeFactory();

    public INodeProvider getNodeProvider();

    public INode[] getChildren();

    public String getAttribute(String var1);

    public String getName();

    public static abstract class AbstractNode
    implements INode,
    ICacheEntryState {
        private final INodeProvider fNodeProvider;
        private final UUID fOrgin;
        private final Object fState;

        public AbstractNode(INodeProvider provider, UUID orgin, Object state) {
            this.fNodeProvider = provider;
            this.fOrgin = orgin;
            this.fState = state;
        }

        public INodeProvider getNodeProvider() {
            return this.fNodeProvider;
        }

        public UUID getOrigin() {
            return this.fOrgin;
        }

        public Object getState() {
            return this.fState;
        }
    }

    public static class ConfigurationElementNode
    extends AbstractNode {
        private IConfigurationElement fDelegate;

        private ConfigurationElementNode(IConfigurationElement delegate, INodeProvider provider, UUID orgin, Object state) {
            super(provider, orgin, state);
            this.fDelegate = delegate;
        }

        public String getName() {
            return this.fDelegate.getName();
        }

        public String getAttribute(String name) {
            return this.fDelegate.getAttribute(name);
        }

        public INode[] getChildren() {
            IConfigurationElement[] children = this.fDelegate.getChildren();
            INode[] result = new INode[children.length];
            int i = 0;
            while (i < children.length) {
                result[i] = new ConfigurationElementNode(children[i], this.getNodeProvider(), this.getOrigin(), this.getState());
                ++i;
            }
            return result;
        }
    }

    public static class MementoNode
    extends AbstractNode {
        private IMemento fDelegate;

        private MementoNode(IMemento delegate, INodeProvider provider, UUID orgin, Object state) {
            super(provider, orgin, state);
            this.fDelegate = delegate;
        }

        public String getName() {
            return this.fDelegate.getType();
        }

        public String getAttribute(String name) {
            return this.fDelegate.getString(name);
        }

        public INode[] getChildren() {
            IMemento[] children = this.fDelegate.getChildren();
            INode[] result = new INode[children.length];
            int i = 0;
            while (i < children.length) {
                result[i] = new MementoNode(children[i], this.getNodeProvider(), this.getOrigin(), this.getState());
                ++i;
            }
            return result;
        }
    }

    public static class ModelElementNode
    extends AbstractNode {
        private ModelElement fDelegate;

        private ModelElementNode(ModelElement delegate, INodeProvider provider, UUID orgin, Object state) {
            super(provider, orgin, state);
            this.fDelegate = delegate;
        }

        public String getAttribute(String name) {
            return this.fDelegate.getAttribute(name);
        }

        public INode[] getChildren() {
            List children = this.fDelegate.getChildElements();
            INode[] result = new INode[children.size()];
            ListIterator iter = children.listIterator();
            while (iter.hasNext()) {
                result[iter.nextIndex()] = FACTORY.createNode(iter.next(), this.getNodeProvider(), this.getOrigin(), this.getState());
            }
            return result;
        }

        public String getName() {
            return this.fDelegate.getName();
        }
    }

    public static class NodeFactory {
        public INode createNode(Object element, INodeProvider provider) {
            return this.createNode(element, provider, ICacheEntryState.DEFAULT_ORIGIN, System.currentTimeMillis());
        }

        public INode createNode(Object element, INodeProvider provider, UUID orgin, Object state) {
            if (element instanceof INode) {
                return (INode)element;
            }
            if (element instanceof IProcessConfigurationData) {
                return new ProcessConfigurationDataNode((IProcessConfigurationData)element, provider, orgin, state);
            }
            if (element instanceof IProcessConfigurationElement) {
                return new ProcessConfigurationElementNode((IProcessConfigurationElement)element, provider, orgin, state);
            }
            if (element instanceof IMemento) {
                return new MementoNode((IMemento)element, provider, orgin, state);
            }
            if (element instanceof IConfigurationElement) {
                return new ConfigurationElementNode((IConfigurationElement)element, provider, orgin, state);
            }
            if (element instanceof ModelElement) {
                return new ModelElementNode((ModelElement)element, provider, orgin, state);
            }
            throw new IllegalArgumentException();
        }
    }

    public static class ProcessConfigurationDataNode
    extends AbstractNode {
        private IProcessConfigurationData fDelegate;

        private ProcessConfigurationDataNode(IProcessConfigurationData delegate, INodeProvider provider, UUID orgin, Object state) {
            super(provider, orgin, state);
            this.fDelegate = delegate;
        }

        public String getName() {
            return this.fDelegate.getId();
        }

        public String getAttribute(String name) {
            return null;
        }

        public INode[] getChildren() {
            IProcessConfigurationElement[] children = this.fDelegate.getElements();
            INode[] result = new INode[children.length];
            int i = 0;
            while (i < children.length) {
                result[i] = new ProcessConfigurationElementNode(children[i], this.getNodeProvider(), this.getOrigin(), this.getState());
                ++i;
            }
            return result;
        }
    }

    public static class ProcessConfigurationElementNode
    extends AbstractNode {
        private IProcessConfigurationElement fDelegate;

        private ProcessConfigurationElementNode(IProcessConfigurationElement delegate, INodeProvider provider, UUID orgin, Object state) {
            super(provider, orgin, state);
            this.fDelegate = delegate;
        }

        public String getName() {
            return this.fDelegate.getName();
        }

        public String getAttribute(String name) {
            return this.fDelegate.getAttribute(name);
        }

        public INode[] getChildren() {
            IProcessConfigurationElement[] children = this.fDelegate.getChildren();
            INode[] result = new INode[children.length];
            int i = 0;
            while (i < children.length) {
                result[i] = new ProcessConfigurationElementNode(children[i], this.getNodeProvider(), this.getOrigin(), this.getState());
                ++i;
            }
            return result;
        }
    }
}

