/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.duration;

import com.ibm.team.apt.internal.common.WorkItemEstimator;
import com.ibm.team.workitem.common.model.Duration;
import org.eclipse.core.runtime.Assert;

public class PlanDuration
extends Duration {
    private final long fOriginalEstimate;
    private final long fCorrectedEstimate;
    private final long fTimeSpent;
    private static final int INVALID_TIME_SPENT_OFFSET = 3;

    public PlanDuration(long originalEstimate, long correctedEstimate, long timeSpent, boolean isResolved) {
        super(PlanDuration.calculateDuration(originalEstimate, correctedEstimate, timeSpent, isResolved));
        this.fOriginalEstimate = originalEstimate;
        this.fCorrectedEstimate = correctedEstimate;
        this.fTimeSpent = timeSpent;
    }

    public long getDuration() {
        if (this.isSpecified()) {
            return this.longValue();
        }
        return WorkItemEstimator.getInstance().getDefaultEstimate();
    }

    public long getOriginalEstimate() {
        return this.fOriginalEstimate;
    }

    public long getCorrectedEstimate() {
        return this.fCorrectedEstimate;
    }

    public long getCurrentEstimate() {
        return this.isOriginalEstimateFixed() ? this.fCorrectedEstimate : this.fOriginalEstimate;
    }

    public long getTimeSpent() {
        return this.fTimeSpent;
    }

    public long getTimeRemaining() {
        long timeSpent = this.getTimeSpent();
        if (PlanDuration.isEncodedTimeRemaining(timeSpent)) {
            return PlanDuration.decodeTimeSpent2TimeRemaining(timeSpent);
        }
        if (timeSpent >= 0L) {
            long value = this.getCurrentEstimate() - timeSpent;
            if (value >= 0L) {
                return value;
            }
            return INVALID.longValue();
        }
        return timeSpent;
    }

    public boolean isOriginalEstimateFixed() {
        return this.fCorrectedEstimate != -1L;
    }

    public boolean hasEstimate() {
        return this.getCurrentEstimate() >= 0L;
    }

    public boolean hasOriginalEstimate() {
        return this.getOriginalEstimate() >= 0L;
    }

    public boolean hasCorrectedEstimate() {
        return this.getCorrectedEstimate() >= 0L;
    }

    public boolean hasTimeSpent() {
        return this.getTimeSpent() >= 0L;
    }

    public boolean hasTimeRemaining() {
        return this.getTimeRemaining() >= 0L;
    }

    public static long encodeTimeRemaining2TimeSpent(long value) {
        Assert.isLegal((value >= 0L ? 1 : 0) != 0);
        long result = 0L;
        result += 3L;
        result += value;
        return result *= -1L;
    }

    public static long decodeTimeSpent2TimeRemaining(long value) {
        Assert.isLegal((boolean)PlanDuration.isEncodedTimeRemaining(value));
        long result = value;
        result *= -1L;
        return result -= 3L;
    }

    public static boolean isEncodedTimeRemaining(long timeSpent) {
        return timeSpent < -2L;
    }

    private static long calculateDuration(long originalEstimate, long correctedEstimate, long timeSpent, boolean isResolved) {
        long result = originalEstimate;
        if (correctedEstimate >= 0L) {
            result = correctedEstimate;
        }
        if (timeSpent >= 0L) {
            if (!isResolved) {
                if (result >= 0L) {
                    result = Math.max(result - timeSpent, 0L);
                }
            } else {
                result = timeSpent;
            }
        }
        return result;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.fCorrectedEstimate ^ this.fCorrectedEstimate >>> 32);
        result = 31 * result + (int)(this.fOriginalEstimate ^ this.fOriginalEstimate >>> 32);
        result = 31 * result + (int)(this.fTimeSpent ^ this.fTimeSpent >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PlanDuration other = (PlanDuration)((Object)obj);
        if (this.fCorrectedEstimate != other.fCorrectedEstimate) {
            return false;
        }
        if (this.fOriginalEstimate != other.fOriginalEstimate) {
            return false;
        }
        return this.fTimeSpent == other.fTimeSpent;
    }
}

