/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowUtils {
    /*
     * Could not resolve type clashes
     */
    public static Identifier<IState>[] getSortedStates(final IWorkflowInfo workflowInfo) {
        Identifier<IState> state2;
        LinkedHashSet<Identifier> states = new LinkedHashSet<Identifier>();
        HashSet<Identifier> allStates = new HashSet<Identifier>(Arrays.asList(workflowInfo.getAllStateIds()));
        Identifier startActionId = workflowInfo.getStartActionId();
        if (startActionId != null) {
            Identifier<IState> startState = WorkflowUtils.getActionResultState(workflowInfo, (Identifier<IWorkflowAction>)startActionId);
            ArrayList<Object> nextStates = new ArrayList<Object>();
            nextStates.add(startState);
            while (!nextStates.isEmpty()) {
                Identifier current = (Identifier)nextStates.remove(0);
                if (states.contains(current)) continue;
                if (allStates.contains(current)) {
                    states.add(current);
                }
                Identifier[] actionIds = workflowInfo.getActionIds(current);
                ArrayList<Identifier<IState>> successors = new ArrayList<Identifier<IState>>();
                int i = 0;
                while (i < actionIds.length) {
                    Identifier<IState> actionResultState = WorkflowUtils.getActionResultState(workflowInfo, (Identifier<IWorkflowAction>)actionIds[i]);
                    if (!states.contains(actionResultState) && !nextStates.contains(actionResultState)) {
                        successors.add(actionResultState);
                    }
                    ++i;
                }
                Collections.sort(successors, new Comparator<Identifier<IState>>(){

                    @Override
                    public int compare(Identifier<IState> o1, Identifier<IState> o2) {
                        int group2;
                        int group1 = workflowInfo.getStateGroup(o1);
                        if (group1 != (group2 = workflowInfo.getStateGroup(o2))) {
                            return WorkflowUtils.compareGroups(group1, group2);
                        }
                        return o1.getStringIdentifier().compareTo(o2.getStringIdentifier());
                    }
                });
                for (Identifier identifier : successors) {
                    nextStates.add(identifier);
                }
                Collections.sort(nextStates, new Comparator<Identifier<IState>>(){

                    @Override
                    public int compare(Identifier<IState> o1, Identifier<IState> o2) {
                        int group2;
                        int group1 = workflowInfo.getStateGroup(o1);
                        if (group1 != (group2 = workflowInfo.getStateGroup(o2))) {
                            return WorkflowUtils.compareGroups(group1, group2);
                        }
                        return 0;
                    }
                });
            }
        }
        Identifier<IState>[] openStates = WorkflowUtils.getSorted(workflowInfo.getStateIds(1), workflowInfo);
        Identifier<IState>[] todoStates = WorkflowUtils.getSorted(workflowInfo.getStateIds(4), workflowInfo);
        Identifier<IState>[] doneStates = WorkflowUtils.getSorted(workflowInfo.getStateIds(2), workflowInfo);
        Object object = openStates;
        int n = openStates.length;
        int n2 = 0;
        while (n2 < n) {
            state2 = object[n2];
            if (!states.contains(state2)) {
                states.add(state2);
            }
            ++n2;
        }
        object = todoStates;
        n = todoStates.length;
        n2 = 0;
        while (n2 < n) {
            state2 = object[n2];
            if (!states.contains(state2)) {
                states.add(state2);
            }
            ++n2;
        }
        object = doneStates;
        n = doneStates.length;
        n2 = 0;
        while (n2 < n) {
            state2 = object[n2];
            if (!states.contains(state2)) {
                states.add(state2);
            }
            ++n2;
        }
        for (Identifier<IState> state2 : allStates) {
            if (states.contains(state2)) continue;
            states.add(state2);
        }
        Identifier[] result = states.toArray(new Identifier[states.size()]);
        Arrays.sort(result, new Comparator<Identifier<IState>>(){

            @Override
            public int compare(Identifier<IState> o1, Identifier<IState> o2) {
                int group2;
                int group1 = workflowInfo.getStateGroup(o1);
                if (group1 != (group2 = workflowInfo.getStateGroup(o2))) {
                    return WorkflowUtils.compareGroups(group1, group2);
                }
                return 0;
            }
        });
        return result;
    }

    private static int compareGroups(int group1, int group2) {
        if (group1 == group2) {
            return 0;
        }
        if (group1 == 1) {
            return -1;
        }
        if (group1 == 2) {
            return 1;
        }
        if (group2 == 1) {
            return 1;
        }
        if (group2 == 2) {
            return -1;
        }
        return 0;
    }

    private static Identifier<IState>[] getSorted(Identifier<IState>[] stateIds, IWorkflowInfo workflowInfo) {
        Arrays.sort(stateIds, new Comparator<Identifier<IState>>(){

            @Override
            public int compare(Identifier<IState> o1, Identifier<IState> o2) {
                return o1.getStringIdentifier().compareTo(o2.getStringIdentifier());
            }
        });
        return stateIds;
    }

    private static Identifier<IState> getActionResultState(IWorkflowInfo workflowInfo, Identifier<IWorkflowAction> action) {
        Identifier result = workflowInfo.getActionResultState(action);
        String stripOffPrefix = WorkflowUtils.stripOffPrefix(result.getStringIdentifier(), 's');
        return Identifier.create(IState.class, (String)stripOffPrefix);
    }

    private static String stripOffPrefix(String s, char prefix) {
        int l;
        if (s != null && (l = s.length()) > 1 && s.charAt(0) == prefix) {
            int i = 1;
            while (i < l) {
                if (!Character.isDigit(s.charAt(i))) {
                    return s;
                }
                ++i;
            }
            return s.substring(1);
        }
        return s;
    }
}

