/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.InvalidConfigurationException;
import com.ibm.team.apt.internal.common.Messages;
import com.ibm.team.apt.internal.common.PlanItemAttributes;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanItemsDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.process.ConfigurationElementCache;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PlanningConfigurationValidator {
    private static final List<Class<? extends IConfigurationElement>> types = new ArrayList<Class<? extends IConfigurationElement>>();
    private final IPlanningCommon fPlanningCommon;

    static {
        types.add(IFilterDescription.class);
        types.add(ISortModeDescription.class);
        types.add(IViewModeDescription.class);
        types.add(IGroupModeDescription.class);
        types.add(IPlanModeDescription.class);
        types.add(IPlanItemsDescription.class);
        types.add(IPlanCheckDescription.class);
        types.add(IPlanType.class);
        types.add(IAttributeDefinitionDescriptor.class);
    }

    public PlanningConfigurationValidator(IPlanningCommon planningCommon) {
        this.fPlanningCommon = planningCommon;
    }

    public void performValidationIfNeeded(IWorkItemCommon workItemCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.needsValidation(projectArea)) {
            this.performValidation(workItemCommon, projectArea, monitor);
        }
    }

    public void performValidation(IWorkItemCommon workItemCommon, IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttributeDefinitionDescriptor attribute;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + types.size() + 2 + 2));
        IAuditableCommonProcess process = workItemCommon.getAuditableCommon().getProcess((IProcessAreaHandle)projectArea, (IProgressMonitor)progress.newChild(1));
        for (Class<? extends IConfigurationElement> type : types) {
            try {
                this.fPlanningCommon.findConfigurationElements(type, process, (IProgressMonitor)progress.newChild(1));
            }
            catch (TeamRepositoryException e) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningCommonImpl.VALIDATION_FAIL_CONFIG_ELEMENT"), (Object)type.getName(), (Object[])new Object[0]), e);
            }
        }
        List<IAttributeDefinitionDescriptor> planningAttributes = this.fPlanningCommon.findConfigurationElements(IAttributeDefinitionDescriptor.class, process, (IProgressMonitor)progress.newChild(1));
        List workItemAttributes = workItemCommon.findAttributes(projectArea, (IProgressMonitor)progress.newChild(1));
        HashSet<String> attributeIds = new HashSet<String>();
        for (IAttribute workItemAttribute : workItemAttributes) {
            attributeIds.add(workItemAttribute.getIdentifier());
        }
        for (IAttributeDefinitionDescriptor planAttribute : planningAttributes) {
            String identifier;
            Identifier<IAttribute> attributeIdentifier = PlanItemAttributes.getAttributeId(planAttribute);
            if (PlanItemAttributes.isWorkItemProxied(planAttribute) && attributeIdentifier == null) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_FAIL_WORK_ITEM_ATTR_PROXY"), (Object)planAttribute.getId(), (Object[])new Object[0]));
            }
            if (attributeIdentifier == null || !PlanItemAttributes.isWorkItemProxied(planAttribute) && !PlanItemAttributes.isBuiltIn(planAttribute) || attributeIds.contains(identifier = attributeIdentifier.getStringIdentifier())) continue;
            throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningCommonImpl.VALIDATION_FAIL_WORK_ITEM_ATTR"), (Object)planAttribute.getId(), (Object[])new Object[]{identifier}));
        }
        IComplexityAttribute complexity = this.fPlanningCommon.findComplexityAttribute((IProcessAreaHandle)process.getProjectArea(), (IProgressMonitor)progress.newChild(1));
        if (complexity != null && (attribute = this.fPlanningCommon.findConfigurationElement(IAttributeDefinitionDescriptor.class, complexity.getAttributeId(), process, (IProgressMonitor)progress.newChild(1))) == null) {
            throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningCommonImpl.VALIDATION_FAIL_COMPLEXITY_ATTR"), (Object)complexity.getAttributeId(), (Object[])new Object[0]));
        }
        for (IAttributeDefinitionDescriptor planAttribute : planningAttributes) {
            if (!"com.ibm.team.apt.client.RankingAttribute".equals(planAttribute.getImplementationName())) continue;
            IParameter parameter = IParameter.FACTORY.findFirst("attribute", planAttribute.getParameters());
            if (parameter == null) {
                throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_FAIL_RANKING_NO_ATTR"), (Object)planAttribute.getId(), (Object[])new Object[0]));
            }
            IAttributeDefinitionDescriptor attribute2 = this.fPlanningCommon.findConfigurationElement(IAttributeDefinitionDescriptor.class, parameter.getValue(), process, (IProgressMonitor)progress.newChild(1));
            if (attribute2 != null) continue;
            throw new InvalidConfigurationException(NLS.bind((String)Messages.getString("PlanningConfigurationValidator.VALIDATION_FAIL_RANKING_ATTR"), (Object)planAttribute.getId(), (Object[])new Object[]{parameter.getValue()}));
        }
        this.storeValidationMarker(workItemCommon.getAuditableCommon(), projectArea, monitor);
    }

    protected boolean needsValidation(IProjectAreaHandle handle) {
        ConfigurationElementCache cache = this.fPlanningCommon.getConfigurationElementCacheIfExists(handle);
        if (cache == null) {
            return true;
        }
        return cache.get(PlanningConfigurationValidator.asIdentifier((IItemHandle)handle), Object.class) == null;
    }

    protected void storeValidationMarker(IAuditableCommon auditableCommon, IProjectAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        ConfigurationElementCache cache = this.fPlanningCommon.getConfigurationElementCacheIfExists(handle);
        if (cache == null) {
            return;
        }
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.PROJECT_AREA_DEFAULT, (IProgressMonitor)progress.newChild(1));
        cache.add(new ItemState((IItem)projectArea), PlanningConfigurationValidator.asIdentifier((IItemHandle)projectArea), new Object());
    }

    protected static String asIdentifier(IItemHandle item) {
        return "__validationMarker@" + item.getItemId().getUuidValue();
    }

    private static class ItemState
    implements ICacheEntryState {
        private IItem fItem;

        public ItemState(IItem item) {
            this.fItem = item;
        }

        public UUID getOrigin() {
            return this.fItem.getItemId();
        }

        public Object getState() {
            return this.fItem.getStateId();
        }
    }
}

