/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.Messages;
import com.ibm.team.apt.internal.common.PlanningConfigurationValidator;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.nucleus.query.BaseIterationPlanRecordQueryModel;
import com.ibm.team.apt.internal.common.plantype.DefaultPlanType;
import com.ibm.team.apt.internal.common.plantype.IBacklogIteration;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.process.CompositeNodeProvider;
import com.ibm.team.apt.internal.common.process.ConfigurationElementCache;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.IConfigurationElementMassage;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.ProcessConfigurationNodeProvider;
import com.ibm.team.apt.internal.common.process.StaticConfigurationDataRegistry;
import com.ibm.team.apt.internal.common.scripting.environment.AbstractScriptFeature;
import com.ibm.team.apt.internal.common.scripting.environment.FileScriptFeature;
import com.ibm.team.apt.internal.common.scripting.environment.ProcessAttachmentScriptFeature;
import com.ibm.team.apt.internal.common.scripting.util.ExtensionScriptSourceRegistry;
import com.ibm.team.apt.internal.common.util.IFilter;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ILicenseService;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningCommonImpl
implements IPlanningCommon {
    private static final String ID_SPRINT_BACKLOG = "com.ibm.team.apt.plantype.default";
    private static final String ID_TEAM_RELEASE_BACKLOG = "com.ibm.team.apt.plantype.release";
    private static final String ID_PROJECT_RELEASE_BACKLOG = "com.ibm.team.apt.plantype.release.project";
    private static final String ID_PRODUCT_BACKLOG = "com.ibm.team.apt.plantype.product.backlog";
    private static final String PLAN_SCRIPTS = "com.ibm.team.apt.configuration.planscripts";
    private static final String PREFIX_PROCESSATTACHEMENT = "processattachment:/";
    private static final String PREFIX_BUNDLEENTRY = "bundle:/";
    private StaticConfigurationDataRegistry fRegistry = StaticConfigurationDataRegistry.getInstance();
    private ICommonServiceContext fServiceContext;
    private Map<Locale, Map<UUID, ConfigurationElementCache>> fLocale2ProjectArea2Cache = new LinkedHashMap<Locale, Map<UUID, ConfigurationElementCache>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Locale, Map<UUID, ConfigurationElementCache>> eldest) {
            return this.size() >= 8;
        }
    };
    private List<IConfigurationElementMassage<?>> fMassages = new ArrayList();
    private PlanningConfigurationValidator fConfigurationValidator;

    public PlanningCommonImpl(ICommonServiceContext serviceContext) {
        this.fServiceContext = serviceContext;
        this.fConfigurationValidator = new PlanningConfigurationValidator(this);
    }

    @Override
    public IComplexityAttribute findComplexityAttribute(IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableCommonProcess process = ((IAuditableCommon)this.fServiceContext.getService(IAuditableCommon.class)).getProcess(processArea, monitor);
        return ConfigurationElementFactory.singleInstance(IComplexityAttribute.class, new ProcessConfigurationNodeProvider(process), monitor);
    }

    @Override
    public List<AbstractScriptFeature> getAvailableScripts(final IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<AbstractScriptFeature> result = new ArrayList<AbstractScriptFeature>();
        result.addAll(ExtensionScriptSourceRegistry.getInstance().getDescriptors());
        WorkItemCommon workItemCommon = (WorkItemCommon)this.getAuditableCommon().getPeer(IWorkItemCommon.class);
        if (workItemCommon.allowProcessScripts(null)) {
            result.addAll((Collection)this.fServiceContext.callCancelableService((ServiceRunnable)new ServiceRunnable<List<AbstractScriptFeature>>(){

                public List<AbstractScriptFeature> run() throws TeamRepositoryException {
                    ArrayList<AbstractScriptFeature> result = new ArrayList<AbstractScriptFeature>();
                    IProcessConfigurationData data = process.findProcessConfiguration(PlanningCommonImpl.PLAN_SCRIPTS, (IProgressMonitor)new NullProgressMonitor());
                    if (data != null) {
                        IProcessConfigurationElement[] iProcessConfigurationElementArray = data.getElements();
                        int n = iProcessConfigurationElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                            if ("planscript".equals(element.getName())) {
                                AbstractScriptFeature scriptFeature = null;
                                String javaScriptSource = element.getAttribute("source");
                                if (javaScriptSource != null) {
                                    int bundleNameEnd;
                                    if (javaScriptSource.startsWith(PlanningCommonImpl.PREFIX_PROCESSATTACHEMENT)) {
                                        String attachmentName = javaScriptSource.substring(PlanningCommonImpl.PREFIX_PROCESSATTACHEMENT.length());
                                        IProcessAttachment attachment = process.getProcessAttachment(attachmentName, (IProgressMonitor)new NullProgressMonitor());
                                        if (attachment != null) {
                                            scriptFeature = new ProcessAttachmentScriptFeature(attachment, PlanningCommonImpl.this.getAuditableCommon());
                                        }
                                    } else if (javaScriptSource.startsWith(PlanningCommonImpl.PREFIX_BUNDLEENTRY) && (bundleNameEnd = javaScriptSource.indexOf(47, PlanningCommonImpl.PREFIX_BUNDLEENTRY.length() + 1)) != -1) {
                                        String bundleName = javaScriptSource.substring(PlanningCommonImpl.PREFIX_BUNDLEENTRY.length(), bundleNameEnd);
                                        String fileName = javaScriptSource.substring(bundleNameEnd + 1);
                                        scriptFeature = new FileScriptFeature(bundleName, (IPath)new Path("clientScript/" + fileName));
                                    }
                                    if (scriptFeature != null) {
                                        result.add(scriptFeature);
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    return result;
                }
            }, monitor));
        }
        return result;
    }

    @Override
    public List<IPlanType> findPlanTypes(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findConfigurationElements(IPlanType.class, process, monitor);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public <T extends IConfigurationElement> List<T> findConfigurationElements(final Class<T> type, final IAuditableCommonProcess process, final IProgressMonitor monitor) throws TeamRepositoryException {
        result = null;
        identifier = type.getName();
        result = this.getConfigurationElementCache(process.getProjectArea()).getCollection(identifier, type);
        if (result == null) {
            block5: {
                ensureUnique = new IFilter<INode>(){
                    private HashSet<String> fIds = new HashSet();

                    @Override
                    public boolean accept(INode element) {
                        return this.fIds.add(element.getAttribute("id"));
                    }
                };
                runnable = new ServiceRunnable<List<T>>(){

                    public List<T> run() throws TeamRepositoryException {
                        CompositeNodeProvider provider = new CompositeNodeProvider(PlanningCommonImpl.this.getConfigurationElementCache(process.getProjectArea()), new ProcessConfigurationNodeProvider(process), PlanningCommonImpl.this.fRegistry);
                        return ConfigurationElementFactory.allInstances(type, ensureUnique, provider, PlanningCommonImpl.this.getConfigurationElementMassages(), monitor);
                    }
                };
                result = (ArrayList<E>)this.fServiceContext.callCancelableService((ServiceRunnable)runnable, monitor);
                if (IPlanType.class.equals(type)) {
                    try {
                        licenseService = (ILicenseService)this.fServiceContext.getService(ILicenseService.class);
                        licenseService.assertLicense("com.ibm.team.apt.riskManagement.probabilitySimulation");
                        break block5;
                    }
                    catch (LicenseNotGrantedException v0) {
                        result = new ArrayList<E>(result);
                        iter = result.iterator();
                        ** while (iter.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (!"com.ibm.team.tempo.plantype.iteration".equals(((IConfigurationElement)iter.next()).getId())) continue;
                        iter.remove();
                        continue;
                    }
                }
            }
            this.getConfigurationElementCache(process.getProjectArea()).registerCollection(identifier, Collections.unmodifiableList(result));
        }
        return new ArrayList<T>(result);
    }

    @Override
    public IPlanType findPlanType(IAuditableCommonProcess process, String planTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        IPlanType planType;
        if (planTypeId.equals(DefaultPlanType.INSTANCE.getId())) {
            planTypeId = ID_SPRINT_BACKLOG;
        }
        if ((planType = this.findConfigurationElement(IPlanType.class, planTypeId, process, monitor)) == null && !planTypeId.equals(ID_SPRINT_BACKLOG)) {
            APTCommonPlugin.log(NLS.bind((String)Messages.getString("PlanningCommonImpl.ERROR_PLAN_TYPE_NOT_FOUND"), (Object)planTypeId, (Object[])new Object[]{ID_SPRINT_BACKLOG}), null);
            planType = this.findConfigurationElement(IPlanType.class, ID_SPRINT_BACKLOG, process, monitor);
        }
        if (planType == null) {
            planType = DefaultPlanType.INSTANCE;
            APTCommonPlugin.log(NLS.bind((String)Messages.getString("PlanningCommonImpl.ERROR_USING_DEFAULT_PLAN_TYPE"), (Object)planTypeId, (Object[])new Object[0]), null);
        }
        return planType;
    }

    @Override
    public <T extends IConfigurationElement> T findConfigurationElement(final Class<T> type, final String identifier, IAuditableCommonProcess process, final IProgressMonitor monitor) throws TeamRepositoryException {
        IConfigurationElement element = (IConfigurationElement)this.getConfigurationElementCache(process.getProjectArea()).get(identifier, type);
        if (element != null) {
            return (T)element;
        }
        final CompositeNodeProvider provider = new CompositeNodeProvider(this.getConfigurationElementCache(process.getProjectArea()), new ProcessConfigurationNodeProvider(process), this.fRegistry);
        final IFilter<INode> filter = new IFilter<INode>(){

            @Override
            public boolean accept(INode element) {
                return identifier != null && identifier.equals(element.getAttribute("id"));
            }
        };
        ServiceRunnable runnable = new ServiceRunnable<T>(){

            public T run() throws TeamRepositoryException {
                return (IConfigurationElement)ConfigurationElementFactory.singleInstance(type, filter, provider, PlanningCommonImpl.this.getConfigurationElementMassages(), monitor);
            }
        };
        element = (IConfigurationElement)this.fServiceContext.callCancelableService(runnable, monitor);
        return (T)element;
    }

    @Override
    public List<IConfigurationElementMassage<?>> getConfigurationElementMassages() {
        return this.fMassages;
    }

    @Override
    public synchronized ConfigurationElementCache getConfigurationElementCacheIfExists(IProjectAreaHandle projectArea) {
        return this.getConfigurationElementCacheIfExists(projectArea, Arrays.asList(Locale.getDefault()));
    }

    protected synchronized ConfigurationElementCache getConfigurationElementCacheIfExists(IProjectAreaHandle projectArea, List<Locale> locales) {
        Map<UUID, ConfigurationElementCache> map = this.fLocale2ProjectArea2Cache.get(PlanningCommonImpl.getLocale(locales));
        if (map != null) {
            return map.get(projectArea.getItemId());
        }
        return null;
    }

    @Override
    public synchronized ConfigurationElementCache getConfigurationElementCache(IProjectAreaHandle projectArea) {
        return this.getConfigurationElementCache(projectArea, Arrays.asList(Locale.getDefault()));
    }

    public synchronized void clearCaches(IProjectAreaHandle projectArea) {
        UUID key = projectArea.getItemId();
        for (Map<UUID, ConfigurationElementCache> next : this.fLocale2ProjectArea2Cache.values()) {
            ConfigurationElementCache cache = next.remove(key);
            if (cache == null) continue;
            cache.clear();
        }
    }

    protected synchronized ConfigurationElementCache getConfigurationElementCache(IProjectAreaHandle projectArea, List<Locale> locales) {
        ConfigurationElementCache result;
        Locale locale = PlanningCommonImpl.getLocale(locales);
        Map<UUID, ConfigurationElementCache> map = this.fLocale2ProjectArea2Cache.get(locale);
        if (map == null) {
            map = new HashMap<UUID, ConfigurationElementCache>();
            this.fLocale2ProjectArea2Cache.put(locale, map);
        }
        if ((result = map.get(projectArea.getItemId())) == null) {
            result = new ConfigurationElementCache();
            map.put(projectArea.getItemId(), result);
        }
        return result;
    }

    private static Locale getLocale(List<Locale> locales) {
        if (locales.isEmpty()) {
            return Locale.getDefault();
        }
        return locales.get(0);
    }

    private IAuditableCommon getAuditableCommon() {
        return (IAuditableCommon)((IAuditableCommon)this.fServiceContext.getService(IAuditableCommon.class)).getPeer(IAuditableCommon.class);
    }

    @Override
    public IItemQueryPage fetchRelatedPlans(IIterationPlanRecordHandle planHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IAuditableCommon auditableCommon = this.getAuditableCommon();
        Node<IIteration> contextIterations = this.fetchContextIterations(planHandle, (IProgressMonitor)progress.newChild(1));
        ArrayList<IIteration> iterations = new ArrayList<IIteration>();
        if (!contextIterations.getChildren().isEmpty()) {
            int size = contextIterations.getChildren().size();
            iterations.add(contextIterations.getChildren().get(size - 1).getElement());
        }
        while (!contextIterations.getChildren().isEmpty()) {
            if (contextIterations.getElement() != null) {
                iterations.add(contextIterations.getElement());
            }
            contextIterations = contextIterations.getChildren().get(0);
        }
        if (iterations.isEmpty()) {
            return null;
        }
        IIterationPlanRecord plan = (IIterationPlanRecord)auditableCommon.resolveAuditable((IAuditableHandle)planHandle, IIterationPlanRecord.MEDIUM_PROFILE, (IProgressMonitor)progress.newChild(1));
        IProcessAreaHandle owner = plan.getOwner();
        BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel model = BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        Object[] params = new Object[iterations.size() + 1 + 1];
        IItemHandleInputArg[] args = new IItemHandleInputArg[iterations.size()];
        ListIterator iter = iterations.listIterator();
        while (iter.hasNext()) {
            int index = iter.nextIndex();
            args[index] = query.newItemHandleArg();
            params[index] = iter.next();
        }
        params[params.length - 2] = owner.getItemId();
        params[params.length - 1] = plan.getItemId();
        IPredicate predicate = model.owner().itemId()._eq((IUUID)query.newUUIDArg())._and(model.iteration()._in(args))._and(query.not(model.itemId()._eq((IUUID)query.newUUIDArg())));
        query.distinct();
        query.filter(predicate);
        query.orderByAsc((IField)model.iteration().internalEndDate());
        query.orderByAsc((IField)model.iteration().internalStartDate());
        query.orderByAsc((IField)model.iteration().name());
        query.orderByAsc((IField)model.iteration().archived());
        query.orderByAsc((IField)model.name());
        return auditableCommon.queryItems(query, params, 512, (IProgressMonitor)progress.newChild(1));
    }

    @Override
    public Node<IIteration> fetchContextIterations(IIterationPlanRecordHandle planHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IAuditableCommon auditableCommon = this.getAuditableCommon();
        IIterationPlanRecord plan = (IIterationPlanRecord)auditableCommon.resolveAuditable((IAuditableHandle)planHandle, IIterationPlanRecord.MEDIUM_PROFILE, (IProgressMonitor)progress.newChild(1));
        IIteration iteration = (IIteration)auditableCommon.resolveAuditable((IAuditableHandle)plan.getIteration(), ItemProfile.ITERATION_DEFAULT, (IProgressMonitor)progress.newChild(1));
        IDevelopmentLine timeline = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)iteration.getDevelopmentLine(), ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)progress.newChild(1));
        Node<IIteration> iterations = Iterations.fetchIterationTree((IDevelopmentLineHandle)timeline, auditableCommon, (IProgressMonitor)progress.newChild(1));
        IIteration currentIteration = Iterations.fetchCurrentIteration((IDevelopmentLineHandle)timeline, auditableCommon, (IProgressMonitor)progress.newChild(1));
        Node<IIteration> nodeCurrentIteration = currentIteration != null ? iterations.depthFirstIterator(new IItemFilter(this, (IItemHandle)currentIteration)).next() : null;
        IIteration backlogIteration = this.fetchBacklogIteration((IDevelopmentLineHandle)timeline, (IProgressMonitor)progress.newChild(1));
        Node<Object> result = new Node<Object>(null, null);
        if (nodeCurrentIteration != null) {
            Node<Object> parent = result;
            Node<IIteration> subtree = nodeCurrentIteration;
            ArrayList<IIteration> releaseIterations = new ArrayList<IIteration>();
            while (!subtree.isRoot() && subtree.getElement() != null) {
                releaseIterations.add(0, subtree.getElement());
                subtree = subtree.getParent();
            }
            for (IIteration releaseIteration : releaseIterations) {
                Node<IIteration> node = new Node<IIteration>(parent, releaseIteration);
                parent.getChildren().add(node);
                parent = node;
            }
            int c = 4;
            Node<IIteration> sibling = nodeCurrentIteration;
            while (sibling != null && c > 0) {
                parent.getChildren().add(new Node<IIteration>(parent, sibling.getElement()));
                sibling = sibling.nextSibling();
                --c;
            }
            while (!parent.isRoot()) {
                Node<IIteration> parentNode = iterations.depthFirstIterator(new IItemFilter(this, (IItemHandle)((IIteration)parent.getElement()))).next();
                Node<IIteration> parentSibling = parentNode.nextSibling();
                parent = parent.getParent();
                if (parentSibling == null) continue;
                parent.getChildren().add(new Node<IIteration>(parent, parentSibling.getElement()));
            }
        }
        if (backlogIteration != null) {
            result.getChildren().add(new Node<IIteration>(result, backlogIteration));
        }
        return result;
    }

    @Override
    public IPlanType fetchPlanType(IProcessAreaHandle processAreaHandle, IIterationHandle iterationHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        IAuditableCommon auditableCommon = this.getAuditableCommon();
        IIteration iteration = (IIteration)auditableCommon.resolveAuditable((IAuditableHandle)iterationHandle, ItemProfile.ITERATION_DEFAULT, (IProgressMonitor)progress.newChild(1));
        IProcessArea owner = (IProcessArea)auditableCommon.resolveAuditable((IAuditableHandle)processAreaHandle, ItemProfile.PROCESS_AREA_DEFAULT, (IProgressMonitor)progress.newChild(1));
        IAuditableCommonProcess processCommon = auditableCommon.getProcess((IProcessAreaHandle)owner, (IProgressMonitor)progress.newChild(1));
        IIteration backlogIteration = this.fetchBacklogIteration(iteration.getDevelopmentLine(), (IProgressMonitor)progress.newChild(1));
        if (iteration.sameItemId((IItemHandle)backlogIteration)) {
            return this.findPlanType(processCommon, ID_PRODUCT_BACKLOG, (IProgressMonitor)progress.newChild(1));
        }
        Node<IIteration> tree = Iterations.fetchIterationTree((IIterationHandle)iteration, auditableCommon, (IProgressMonitor)progress.newChild(1));
        if (tree.getChildren().isEmpty()) {
            return this.findPlanType(processCommon, ID_SPRINT_BACKLOG, (IProgressMonitor)progress.newChild(1));
        }
        if (owner instanceof IProjectAreaHandle) {
            return this.findPlanType(processCommon, ID_PROJECT_RELEASE_BACKLOG, (IProgressMonitor)progress.newChild(1));
        }
        return this.findPlanType(processCommon, ID_TEAM_RELEASE_BACKLOG, (IProgressMonitor)progress.newChild(1));
    }

    protected IIteration fetchBacklogIteration(IDevelopmentLineHandle timelineHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IAuditableCommon auditableCommon = this.getAuditableCommon();
        IDevelopmentLine timeline = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)timelineHandle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, (IProgressMonitor)progress.newChild(1));
        IAuditableCommonProcess processCommon = auditableCommon.getProcess((IProcessAreaHandle)timeline.getProjectArea(), (IProgressMonitor)progress.newChild(1));
        IBacklogIteration backlogIteration = this.findConfigurationElement(IBacklogIteration.class, timeline.getId(), processCommon, (IProgressMonitor)progress.newChild(1));
        return backlogIteration != null ? IterationsHelper.resolveIterationFromPath((IProcessAreaHandle)timeline.getProjectArea(), (String)backlogIteration.getPath(), (IAuditableCommon)auditableCommon, (IProgressMonitor)progress.newChild(1)) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IItemFilter<E extends IItemHandle>
    implements IFilter<E> {
        private E fItemHandle;
        final /* synthetic */ PlanningCommonImpl this$0;

        public IItemFilter(E itemHandle) {
            this.this$0 = var1_1;
            this.fItemHandle = itemHandle;
        }

        @Override
        public boolean accept(E element) {
            return this.fItemHandle == element || element != null && element.sameItemId(this.fItemHandle);
        }
    }
}

