/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.apt.internal.common.util.SortMode;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterations {
    public static final String PARENT_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"parent");
    public static final String DEVELOPMENT_LINE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"developmentLine");
    public static final String ID_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"id");
    public static final String NAME_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"name");
    public static final String START_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"startDate");
    public static final String END_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"endDate");
    public static final ItemProfile<IIteration> UI_PROFILE = ItemProfile.createProfile((IItemType)IIteration.ITEM_TYPE, (Collection)AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(Arrays.asList(NAME_PROPERTY, ID_PROPERTY, START_DATE_PROPERTY, END_DATE_PROPERTY));
    public static final ItemProfile<IIteration> LARGE_PROFILE = ItemProfile.createProfile((IItemType)IIteration.ITEM_TYPE, (Collection)AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension(Arrays.asList(PARENT_PROPERTY, DEVELOPMENT_LINE_PROPERTY, NAME_PROPERTY, ID_PROPERTY, START_DATE_PROPERTY, END_DATE_PROPERTY));
    public static final ItemProfile<IIteration> FULL_PROFILE = ItemProfile.createFullProfile((IItemType)IIteration.ITEM_TYPE);
    private static final ItemProfile<IDevelopmentLine> TIMELINE_PROFILE = ItemProfile.createFullProfile((IItemType)IDevelopmentLine.ITEM_TYPE);

    public static int compareTo(IIteration i1, IIteration i2) {
        return new IterationComparator(SortMode.ASC).compare(i1, i2);
    }

    public static List<IIteration> sort(Collection<IIteration> intervals) {
        return Iterations.sort(intervals, SortMode.ASC);
    }

    public static List<IIteration> sort(Collection<IIteration> iterations, SortMode mode) {
        ArrayList<IIteration> sorted = new ArrayList<IIteration>();
        for (IIteration iteration : iterations) {
            sorted.add(iteration);
        }
        Iterations.sort(sorted, mode);
        return sorted;
    }

    public static void sort(List<IIteration> intervals, SortMode mode) {
        Collections.sort(intervals, new IterationComparator(mode));
    }

    public static List<IIteration>[] splitByTime(List<? extends IIteration> iterations) {
        ArrayList<IIteration> current = new ArrayList<IIteration>();
        ArrayList<IIteration> past = new ArrayList<IIteration>();
        ArrayList<IIteration> future = new ArrayList<IIteration>();
        long currentTime = System.currentTimeMillis();
        for (IIteration iIteration : iterations) {
            Date endDate = iIteration.getEndDate();
            Date startDate = iIteration.getStartDate();
            if (endDate == null || startDate == null || endDate.getTime() < currentTime) {
                past.add(iIteration);
                continue;
            }
            if (startDate.getTime() > currentTime) {
                future.add(iIteration);
                continue;
            }
            current.add(iIteration);
        }
        Iterations.sort(current, SortMode.ASC);
        Iterations.sort(past, SortMode.DESC);
        Iterations.sort(future, SortMode.ASC);
        return new List[]{past, current, future};
    }

    public static boolean hasDates(IIteration iteration) {
        return iteration.getStartDate() != null && iteration.getEndDate() != null;
    }

    public static IterationHierarchy fetchIterationHierarchy(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return IterationHierarchy.create(handle, auditableCommon, monitor);
    }

    public static ItemList<IIteration> fetchAllChildren(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, EnumSet<Options> options, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemArrayList<IIteration> result = new ItemArrayList<IIteration>();
        IDevelopmentLine developmentLine = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.DEVELOPMENT_LINE_DEFAULT, monitor);
        IIterationHandle[] iIterationHandleArray = developmentLine.getIterations();
        int n = iIterationHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIterationHandle iteration = iIterationHandleArray[n2];
            ItemList<IIteration> children = Iterations.fetchAllChildren(iteration, auditableCommon, options, monitor);
            result.addAll(children);
            ++n2;
        }
        return result;
    }

    public static ItemList<IIteration> fetchAllChildren(IIterationHandle handle, IAuditableCommon auditableCommon, EnumSet<Options> options, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemArrayList<IIteration> result = new ItemArrayList<IIteration>();
        IIteration iteration = (IIteration)auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.ITERATION_DEFAULT, monitor);
        IIterationHandle[] childrenHandles = iteration.getChildren();
        if (childrenHandles.length != 0) {
            List children = auditableCommon.resolveAuditables(Arrays.asList(childrenHandles), FULL_PROFILE, monitor);
            for (IIteration child : children) {
                if (child.isArchived() != options.contains((Object)Options.ARCHIVED) || child.hasDeliverable() != options.contains((Object)Options.DELIVERABLE)) continue;
                result.add(child);
                result.addAll(Iterations.fetchAllChildren((IIterationHandle)child, auditableCommon, options, monitor));
            }
        }
        return result;
    }

    public static IIteration fetchCurrentIteration(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IDevelopmentLine developmentLine = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.createFullProfile((IItemType)IDevelopmentLine.ITEM_TYPE), (IProgressMonitor)progress.newChild(1));
        IIterationHandle currentHandle = developmentLine.getCurrentIteration();
        IIteration current = currentHandle != null ? (IIteration)auditableCommon.resolveAuditable((IAuditableHandle)currentHandle, FULL_PROFILE, (IProgressMonitor)progress.newChild(1)) : null;
        SubMonitor nestedProgress = progress.newChild(1);
        while (current != null && !current.hasDeliverable() && current.getParent() != null) {
            current = (IIteration)auditableCommon.resolveAuditable((IAuditableHandle)current.getParent(), FULL_PROFILE, (IProgressMonitor)nestedProgress.newChild(1));
        }
        if (monitor != null) {
            monitor.done();
        }
        return current;
    }

    public static Node<IIteration> fetchIterationTree(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IDevelopmentLine developmentLine = (IDevelopmentLine)auditableCommon.resolveAuditable((IAuditableHandle)handle, ItemProfile.createFullProfile((IItemType)IDevelopmentLine.ITEM_TYPE), monitor);
        Node<Object> node = new Node<Object>(null, null);
        IIterationHandle[] iIterationHandleArray = developmentLine.getIterations();
        int n = iIterationHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIterationHandle iterationHandle = iIterationHandleArray[n2];
            IIteration iteration = (IIteration)auditableCommon.resolveAuditable((IAuditableHandle)iterationHandle, FULL_PROFILE, monitor);
            node.getChildren().add(Iterations.buildIterationTree(node, iteration, auditableCommon, EnumSet.of(Options.DELIVERABLE), monitor));
            ++n2;
        }
        return node;
    }

    public static Node<IIteration> fetchIterationTree(IIterationHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        IIteration iteration = (IIteration)auditableCommon.resolveAuditable((IAuditableHandle)handle, FULL_PROFILE, monitor);
        return Iterations.buildIterationTree(null, iteration, auditableCommon, EnumSet.of(Options.DELIVERABLE), monitor);
    }

    private static Node<IIteration> buildIterationTree(Node<IIteration> parentNode, IIteration iteration, IAuditableCommon auditableCommon, EnumSet<Options> options, IProgressMonitor monitor) throws TeamRepositoryException {
        Node<IIteration> node = new Node<IIteration>(parentNode, iteration);
        List children = auditableCommon.resolveAuditables(Arrays.asList(iteration.getChildren()), FULL_PROFILE, monitor);
        for (IIteration child : children) {
            boolean checkSubtree = false;
            checkSubtree |= child.isArchived() && !options.contains((Object)Options.ARCHIVED);
            checkSubtree |= !child.hasDeliverable() && options.contains((Object)Options.DELIVERABLE);
            boolean keepSubtree = !(checkSubtree &= !options.isEmpty());
            Node<IIteration> subtree = Iterations.buildIterationTree(node, child, auditableCommon, options, monitor);
            if (checkSubtree) {
                Iterator<Node<IIteration>> iter = subtree.breadthFirstIterator();
                while (!keepSubtree && iter.hasNext()) {
                    IIteration element = iter.next().getElement();
                    keepSubtree = true;
                    if (!options.contains((Object)Options.ARCHIVED)) {
                        keepSubtree &= !element.isArchived();
                    }
                    if (!options.contains((Object)Options.DELIVERABLE)) continue;
                    keepSubtree &= element.hasDeliverable();
                }
            }
            if (!keepSubtree) continue;
            node.getChildren().add(subtree);
        }
        return node;
    }

    public static IIteration getCurrentPlanLeafIteration(IDevelopmentLineHandle handle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        List iterations = auditableCommon.findCurrentIterations(handle, monitor);
        ListIterator iter = iterations.listIterator(iterations.size());
        while (iter.hasPrevious()) {
            IIteration previous = (IIteration)iter.previous();
            if (!previous.hasDeliverable() || previous.isArchived()) continue;
            return previous;
        }
        return null;
    }

    public static TimeKind getIterationTimeKind(IIteration iteration, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        ItemHashSet currentIterations = new ItemHashSet(auditableCommon.findCurrentIterations(iteration.getDevelopmentLine(), monitor));
        if (currentIterations.contains(iteration)) {
            return TimeKind.CURRENT;
        }
        Object parent = Iterations.getParent(iteration, auditableCommon, monitor);
        while (parent != null) {
            IIterationHandle[] siblings = Iterations.getChildren(parent);
            boolean currentVisited = false;
            boolean iterationVisited = false;
            IIterationHandle[] iIterationHandleArray = siblings;
            int n = siblings.length;
            int n2 = 0;
            while (n2 < n) {
                IIterationHandle sibling = iIterationHandleArray[n2];
                if (currentIterations.contains(sibling)) {
                    if (iterationVisited) {
                        return TimeKind.PAST;
                    }
                    currentVisited = true;
                }
                if (sibling.sameItemId((IItemHandle)iteration)) {
                    if (currentVisited) {
                        return TimeKind.FUTURE;
                    }
                    iterationVisited = true;
                }
                ++n2;
            }
            iteration = parent instanceof IIteration ? (IIteration)parent : null;
            parent = Iterations.getParent(iteration, auditableCommon, monitor);
        }
        return TimeKind.UNKNOWN;
    }

    private static Object getParent(Object element, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        if (element instanceof IIteration) {
            IIteration iteration = (IIteration)element;
            if (iteration.getParent() != null) {
                return auditableCommon.resolveAuditable((IAuditableHandle)iteration.getParent(), FULL_PROFILE, monitor);
            }
            return auditableCommon.resolveAuditable((IAuditableHandle)iteration.getDevelopmentLine(), TIMELINE_PROFILE, monitor);
        }
        return null;
    }

    private static IIterationHandle[] getChildren(Object element) {
        if (element instanceof IIteration) {
            return ((IIteration)element).getChildren();
        }
        if (element instanceof IDevelopmentLine) {
            return ((IDevelopmentLine)element).getIterations();
        }
        return new IIterationHandle[0];
    }

    public static void distributeIterations(ItemCollection<IIteration> primaryIterations, ItemCollection<IIteration> secondaryIterations, IIteration iteration, ItemSet<IIteration> currentIterations, Node<IIteration> tree, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        TimeKind kind = Iterations.getIterationTimeKind(iteration, auditableCommon, monitor);
        if (tree == null) {
            tree = Iterations.fetchIterationTree((IIterationHandle)iteration, auditableCommon, monitor);
        }
        switch (kind) {
            case PAST: {
                primaryIterations.add(iteration);
                for (Node<IIteration> child : tree.getChildren()) {
                    Iterations.addAll(secondaryIterations, child);
                }
                break;
            }
            case CURRENT: {
                if (currentIterations == null) {
                    currentIterations = new ItemHashSet<IIteration>(auditableCommon.findCurrentIterations(iteration.getDevelopmentLine(), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                }
                Iterations.distributeCurrent(primaryIterations, secondaryIterations, tree, currentIterations);
                break;
            }
            case FUTURE: 
            case UNKNOWN: {
                Iterations.addAll(primaryIterations, tree);
            }
        }
    }

    private static void distributeCurrent(ItemCollection<IIteration> primaryIterations, ItemCollection<IIteration> secondaryIterations, Node<IIteration> node, ItemSet<IIteration> currentIterations) {
        IIteration iteration = node.getElement();
        primaryIterations.add(iteration);
        boolean currentVisted = false;
        for (Node<IIteration> childNode : node.getChildren()) {
            IIteration child = childNode.getElement();
            if (currentIterations.contains(child)) {
                currentVisted = true;
                Iterations.distributeCurrent(primaryIterations, secondaryIterations, childNode, currentIterations);
                continue;
            }
            if (currentVisted) {
                Iterations.addAll(primaryIterations, childNode);
                continue;
            }
            Iterations.addAll(secondaryIterations, childNode);
        }
    }

    private static void addAll(ItemCollection<IIteration> list, Node<IIteration> node) {
        IIteration iteration = node.getElement();
        if (!iteration.hasDeliverable() && node.getChildren().isEmpty()) {
            return;
        }
        list.add(iteration);
        for (Node<IIteration> child : node.getChildren()) {
            Iterations.addAll(list, child);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IterationComparator
    implements Comparator<IIteration> {
        private final SortMode fMode;

        private IterationComparator(SortMode mode) {
            this.fMode = mode;
        }

        @Override
        public int compare(IIteration o1, IIteration o2) {
            boolean noDate2;
            boolean isAscending;
            if (o1 == o2) {
                return 0;
            }
            boolean bl = isAscending = this.fMode == SortMode.ASC;
            if (o1 == null) {
                return isAscending ? -1 : 1;
            }
            if (o2 == null) {
                return isAscending ? 1 : -1;
            }
            boolean noDate1 = o1.getStartDate() == null || o1.getEndDate() == null;
            boolean bl2 = noDate2 = o2.getStartDate() == null || o2.getEndDate() == null;
            if (noDate1 && noDate2) {
                return 0;
            }
            if (noDate1) {
                return isAscending ? -1 : 1;
            }
            if (noDate2) {
                return isAscending ? 1 : -1;
            }
            if (o1.getEndDate().getTime() <= o2.getStartDate().getTime()) {
                return isAscending ? -1 : 1;
            }
            if (o1.getStartDate().getTime() >= o2.getEndDate().getTime()) {
                return isAscending ? 1 : -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Options {
        ARCHIVED,
        DELIVERABLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeKind {
        PAST,
        CURRENT,
        FUTURE,
        UNKNOWN;

    }
}

