/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.workitem.common.model.Duration;
import java.util.Date;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instant
implements Comparable<Instant> {
    private final Date fDate;

    public Instant(Date date) {
        Assert.isNotNull((Object)date);
        this.fDate = date;
    }

    public Date getDate() {
        return this.fDate;
    }

    public boolean before(Instant instant) {
        return this.fDate.before(instant.fDate);
    }

    public boolean after(Instant instant) {
        return this.fDate.after(instant.fDate);
    }

    public Instant plus(Duration duration) {
        return new Instant(new Date(this.fDate.getTime() + duration.longValue()));
    }

    public Instant minus(Duration duration) {
        return new Instant(new Date(this.fDate.getTime() - duration.longValue()));
    }

    @Override
    public int compareTo(Instant o) {
        return Dates.compareTo(this.fDate, o.fDate);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Instant)) {
            return false;
        }
        Instant other = (Instant)obj;
        return this.fDate.equals(other.fDate);
    }

    public int hashCode() {
        return this.fDate.hashCode();
    }
}

