/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.wiki;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.common.wiki.transformer.Token;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attachments {
    public static final List<String> IMAGE_CONTENT_TYPES = Arrays.asList("image/jpeg", "image/jpg", "image/png", "image/gif");

    public static String asWiki(ResolvedWikiPageAttachment attachment) {
        return Attachments.asWiki(attachment.getAttachment());
    }

    public static String asWiki(IWikiPageAttachment attachment) {
        Assert.isNotNull((Object)attachment);
        boolean image = IMAGE_CONTENT_TYPES.contains(attachment.getContent().getContentType());
        StringBuilder text = new StringBuilder();
        text.append(image ? Token.IMG_START.wiki : Token.LINK_START.wiki);
        text.append(Attachments.escapeName(attachment.getName(), image));
        text.append(image ? Token.IMG_END.wiki : Token.LINK_END.wiki);
        return text.toString();
    }

    private static String escapeName(String name, boolean image) {
        int len = name.length();
        StringBuilder text = new StringBuilder((int)((float)len * 1.1f));
        int i = 0;
        while (i < len) {
            String end;
            char c = name.charAt(i);
            String start = image ? Token.IMG_START.wiki : Token.LINK_START.wiki;
            String string = end = image ? Token.IMG_END.wiki : Token.LINK_END.wiki;
            if (start.indexOf(c) == 0 || end.indexOf(c) == 0) {
                text.append('~');
            }
            text.append(c);
            ++i;
        }
        return text.toString();
    }

    public static List<IWikiPageAttachment> getAttachments(List<ResolvedWikiPageAttachment> attachments) {
        ArrayList<IWikiPageAttachment> list = new ArrayList<IWikiPageAttachment>(attachments.size());
        Iterator<ResolvedWikiPageAttachment> iter = attachments.iterator();
        while (iter.hasNext()) {
            list.add(iter.next().getAttachment());
        }
        return list;
    }

    public static boolean isPredefined(IWikiPageAttachment attachment, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)attachment).itemManager();
        IWikiPageHandle ownerHandle = attachment.getOwner();
        IWikiPage owner = (IWikiPage)manager.fetchPartialItem((IItemHandle)ownerHandle, 0, Arrays.asList(IWikiPage.OWNER_PROPERTY), monitor);
        return owner.getOwner() == null;
    }
}

