/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.util;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_ResolvedWorkItem2;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.internal.util.ThreeWayDiffReport;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItems {
    public static Identifier<IState> createState(String id) {
        if (id != null && id.length() > 0) {
            return Identifier.create(IState.class, (String)id);
        }
        return null;
    }

    public static boolean isOpen(IWorkItem workItem, IWorkflowInfo info) {
        Assert.isNotNull((Object)workItem);
        Assert.isNotNull((Object)info);
        return info.stateGroupContains(1, workItem.getState2());
    }

    public static boolean isResolved(IWorkItem workItem, IWorkflowInfo info) {
        Assert.isNotNull((Object)workItem);
        Assert.isNotNull((Object)info);
        return info.stateGroupContains(2, workItem.getState2());
    }

    public static long getTimeSpent(IWorkItem workItem) {
        return ((WorkItem)workItem).getTimeSpent();
    }

    public static long getCorrectedEstimate(IWorkItem workItem) {
        return ((WorkItem)workItem).getCorrectedEstimate();
    }

    public static IWorkItemHandle createHandle(IWorkItem item) {
        return (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(item.getOrigin(), item.getItemId(), item.getStateId());
    }

    public static Location createLocation(IWorkItem item) {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)item);
        return Location.itemLocation((IItemHandle)item, (String)repository.getRepositoryURI());
    }

    public static IWorkItemHandle getParent(IWorkItemWorkingCopyManager manager, IWorkItemHandle item, ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2> parentMap) {
        boolean connected = false;
        IWorkItemHandle result = null;
        try {
            WorkItemWorkingCopy wc;
            connected = manager.connectLocal(item, ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, Collections.emptyList(), (boolean)true));
            if (connected && (wc = manager.getWorkingCopy(item)) != null) {
                result = WorkItems.getParent(wc, parentMap);
            }
        }
        finally {
            if (connected) {
                manager.disconnect(item);
            }
        }
        return result;
    }

    public static IWorkItemHandle getParent(WorkItemWorkingCopy wc, ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2> parentMap) {
        DTO_ResolvedWorkItem2 dto;
        IWorkItemHandle referencedItem = null;
        if (wc.isReferencesSet()) {
            IWorkItemReferences references = wc.getReferences();
            List parents = references.getReferences(WorkItemEndPoints.PARENT_WORK_ITEM);
            if (parents.size() == 0) {
                return null;
            }
            IReference reference = (IReference)parents.get(0);
            if (!reference.isItemReference()) {
                return null;
            }
            referencedItem = ((IItemReference)reference).getReferencedItem();
        } else if (parentMap != null && (dto = (DTO_ResolvedWorkItem2)parentMap.get((IItemHandle)wc.getWorkItem())) != null) {
            referencedItem = dto.getParent();
        }
        if (!(referencedItem instanceof IWorkItemHandle)) {
            return null;
        }
        return referencedItem;
    }

    public static void setParent(WorkItemWorkingCopy wc, IWorkItem parent, Set<String> topLevelWorkItemTypes) {
        IEndPointDescriptor endPoint = WorkItemEndPoints.PARENT_WORK_ITEM;
        IWorkItemReferences references = wc.getReferences();
        List parents = references.getReferences(endPoint);
        for (IReference reference : parents) {
            references.remove(reference);
        }
        if (parent != null) {
            IItemReference newParent = WorkItemLinkTypes.createWorkItemReference((IWorkItem)parent);
            references.add(endPoint, (IReference)newParent);
        }
    }

    public static void loadLinks(WorkItemWorkingCopy wc, IProgressMonitor monitor) throws TeamRepositoryException {
        if (wc.isReferencesSet()) {
            return;
        }
        ITeamRepository repository = wc.getTeamRepository();
        IWorkItemWorkingCopyManager manager = PlanningClientPlugin.getWorkItemClient(repository).getWorkItemWorkingCopyManager();
        ILinkManager linkManager = (ILinkManager)repository.getClientLibrary(ILinkManager.class);
        IItemReference reference = WorkItemLinkTypes.createWorkItemReference((IWorkItem)wc.getWorkItem());
        ILinkCollection links = linkManager.findLinksBySource((IReference)reference, monitor).getAllLinksFromHereOn();
        manager.applyLinksUpdate((IWorkItemHandle)wc.getWorkItem(), new ArrayList(links));
    }

    public static void refreshAndMergeWithServer(IReconcileReport report, WorkItemWorkingCopy workingCopy) {
        IWorkItem oldBaseState = ((WorkItemWorkingCopyImpl)workingCopy).getBaseState();
        ((WorkItemWorkingCopyImpl)workingCopy).setBaseState((IWorkItem)EMFHelper.copy((Object)report.getIncoming()));
        IWorkItem base = (IWorkItem)oldBaseState.getWorkingCopy();
        IWorkItem outgoing = workingCopy.getWorkItem();
        IWorkItem incoming = (IWorkItem)report.getIncoming().getWorkingCopy();
        ThreeWayDiffReport diffReport = new ThreeWayDiffReport((IAuditable)base, (IAuditable)outgoing, (IAuditable)incoming);
        diffReport.merge();
    }
}

