/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.scripting.environment;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.scripting.IScriptEnvironment;
import com.ibm.team.apt.internal.common.scripting.environment.FileLocalizationFeature;
import com.ibm.team.apt.internal.common.scripting.environment.FileScriptFeature;
import com.ibm.team.apt.internal.common.scripting.environment.IScriptEnvironmentFeature;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DojoFeature
implements IScriptEnvironmentFeature {
    private static final String DOJO_PLUGIN = PlanningClientPlugin.getPluginId();
    private final List<IScriptEnvironmentFeature> fDojoFileFeatures = new ArrayList<IScriptEnvironmentFeature>();

    public DojoFeature() {
        this.fileFeature("dojo.js.uncompressed.js");
        this.dojoLocalizationFeature("colors");
        this.cldrLocalizationFeature("buddhist");
        this.cldrLocalizationFeature("chinese");
        this.cldrLocalizationFeature("coptic");
        this.cldrLocalizationFeature("currency");
        this.cldrLocalizationFeature("ethiopic");
        this.cldrLocalizationFeature("gregorian");
        this.cldrLocalizationFeature("hebrew");
        this.cldrLocalizationFeature("indian");
        this.cldrLocalizationFeature("islamic-civil");
        this.cldrLocalizationFeature("islamic");
        this.cldrLocalizationFeature("japanese");
        this.cldrLocalizationFeature("number");
        this.cldrLocalizationFeature("persian");
        this.cldrLocalizationFeature("roc");
    }

    public void define(Context cx, Scriptable scope, IScriptEnvironment scriptEnvironment) {
        for (IScriptEnvironmentFeature dojoFeature : this.fDojoFileFeatures) {
            dojoFeature.define(cx, scope, scriptEnvironment);
        }
        String[] stringArray = new String[]{"java", "Packages"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String topName = stringArray[n2];
            Object topProperty = ScriptableObject.getProperty((Scriptable)scope, (String)topName);
            if (topProperty != Scriptable.NOT_FOUND) {
                ScriptableObject.deleteProperty((Scriptable)scope, (String)topName);
            }
            ++n2;
        }
    }

    private void fileFeature(String fileName) {
        this.fDojoFileFeatures.add((IScriptEnvironmentFeature)new FileScriptFeature(DOJO_PLUGIN, (IPath)new Path("scripts/dojo/" + fileName)));
    }

    private void cldrLocalizationFeature(String name) {
        this.fDojoFileFeatures.add((IScriptEnvironmentFeature)new FileLocalizationFeature("dojo.cldr", name, DOJO_PLUGIN, (IPath)new Path("scripts/dojo/cldr/nls/")));
    }

    private void dojoLocalizationFeature(String name) {
        this.fDojoFileFeatures.add((IScriptEnvironmentFeature)new FileLocalizationFeature("dojo", name, DOJO_PLUGIN, (IPath)new Path("scripts/dojo/nls/")));
    }
}

