/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.planchecker;

import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.IPlanCheckReportAcceptor;
import com.ibm.team.apt.internal.client.planchecker.Messages;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckReport;
import com.ibm.team.apt.internal.common.plantype.IProblemDescription;
import com.ibm.team.apt.internal.common.util.IEventCondition;
import com.ibm.team.apt.internal.common.util.PlanRunnable;
import com.ibm.team.apt.internal.common.util.SimpleEventCondition;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanCheckEngine {
    private ResolvedPlan fPlan;
    private IPlanElementListener fListener;
    private IPlanCheckReportAcceptor fAcceptor;
    private PlanDetectionQueue fQueue;
    private Collection<PlanCheck> fChecks = new HashSet<PlanCheck>();
    private volatile boolean fCancelled;

    public PlanCheckEngine(ResolvedPlan plan, IPlanCheckReportAcceptor acceptor) {
        this.fPlan = plan;
        this.fAcceptor = acceptor;
        this.fListener = new IPlanElementListener(){

            public void planElementChanged(IPlanElementChangeEvent event) {
                if (PlanCheckEngine.this.fCancelled) {
                    return;
                }
                IPlanElementDelta delta = event.getDelta();
                if (PlanCheckEngine.this.isRelevantForPlanCheckerChecker(delta)) {
                    PlanCheckEngine.this.runDeltaCheck(delta);
                }
            }
        };
        this.fPlan.addListener(this.fListener);
    }

    public void addCheck(PlanCheck check) {
        this.fChecks.add(check);
    }

    public void removeCheck(PlanCheck check) {
        this.fChecks.remove(check);
    }

    public Collection<PlanCheck> getChecks() {
        return new HashSet<PlanCheck>(this.fChecks);
    }

    public IProblemDescription getProblemDefinition(String problemId) {
        for (PlanCheck check : this.fChecks) {
            IProblemDescription problemDefinition = check.getProblemDefinition(problemId);
            if (problemDefinition == null) continue;
            return problemDefinition;
        }
        return null;
    }

    public void dispose() {
        this.fPlan.removeListener(this.fListener);
        this.fPlan = null;
        this.fListener = null;
        this.fAcceptor = null;
    }

    public synchronized void runDeltaCheck(IPlanElementDelta delta) {
        this.run(new DeltaCheckRun(delta, this.fChecks));
    }

    public synchronized void runItemCheck(Collection<? extends PlanElement> items) {
        this.run(new ItemCheckRun(items, this.fChecks));
    }

    public synchronized void runFullCheck() {
        this.runFullCheck(this.fChecks);
    }

    public synchronized void runFullCheck(Collection<PlanCheck> checks) {
        this.run(new FullCheckRun(checks));
    }

    public synchronized void cancel() {
        this.fCancelled = true;
        if (this.fQueue != null) {
            this.fQueue.cancel();
        }
    }

    public synchronized boolean isActive() {
        return this.fQueue != null;
    }

    public void join(IProgressMonitor monitor) throws InterruptedException {
        Job.getJobManager().join((Object)this.fPlan, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IEventCondition getPlanCheckerExecutedCondition() {
        final SimpleEventCondition result = new SimpleEventCondition();
        if (this.fQueue != null) {
            PlanDetectionQueue planDetectionQueue = this.fQueue;
            synchronized (planDetectionQueue) {
                if (this.fQueue.isActive()) {
                    this.fQueue.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            result.setEventTriggered();
                        }
                    });
                } else {
                    result.setEventTriggered();
                }
            }
        } else {
            result.setEventTriggered();
        }
        return result;
    }

    private void acceptPlanCheckReport(PlanCheckReport report) {
        this.fAcceptor.accept(report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void run(CheckRun run) {
        if (this.fQueue == null) {
            this.scheduleJob(run);
        } else {
            PlanDetectionQueue planDetectionQueue = this.fQueue;
            synchronized (planDetectionQueue) {
                if (this.fQueue.isActive()) {
                    this.fQueue.add(run);
                } else {
                    this.scheduleJob(run);
                }
            }
        }
    }

    private void scheduleJob(CheckRun run) {
        this.fQueue = new PlanDetectionQueue();
        this.fQueue.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PlanCheckEngine.this.resetQueue(event.getJob());
            }
        });
        this.fQueue.add(run);
        this.fQueue.schedule();
    }

    private synchronized void resetQueue(Job queue) {
        if (this.fQueue == queue) {
            this.fQueue = null;
        }
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private boolean isRelevantForPlanCheckerChecker(IPlanElementDelta delta) {
        final boolean[] result = new boolean[1];
        delta.accept(new IPlanElementDeltaVisitor(){

            public boolean visit(IPlanElementDelta delta) {
                if (delta.isContentChange() || delta.isStructuralChange()) {
                    result[0] = true;
                    return false;
                }
                IPlanAttributeDelta[] deltas = delta.getAttributeDeltas();
                if (deltas.length >= 1 && deltas[0].getAttribute() != PlanElement.PLANCHECK_REPORT) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    private class CancelAwareProgressMonitor
    extends ProgressMonitorWrapper {
        protected CancelAwareProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public boolean isCanceled() {
            return PlanCheckEngine.this.fCancelled || super.isCanceled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CheckRun {
        Collection<PlanCheck> fCheckRunChecks;

        public CheckRun(Collection<PlanCheck> checks) {
            this.fCheckRunChecks = checks;
        }

        public abstract PlanCheckReport execute(IProgressMonitor var1) throws TeamRepositoryException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeltaCheckRun
    extends CheckRun {
        private IPlanElementDelta fDelta;

        public DeltaCheckRun(IPlanElementDelta delta, Collection<PlanCheck> checks) {
            super(checks);
            this.fDelta = delta;
        }

        @Override
        public PlanCheckReport execute(IProgressMonitor monitor) throws TeamRepositoryException {
            PlanCheckReport currentReport = PlanCheckEngine.this.fPlan.getPlanCheckReport();
            PlanCheckReport result = currentReport != null ? new PlanCheckReport(currentReport) : new PlanCheckReport(PlanCheckEngine.this.fPlan);
            monitor.beginTask("", this.fCheckRunChecks.size());
            for (PlanCheck check : this.fCheckRunChecks) {
                check.runDeltaCheck(result, this.fDelta, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FullCheckRun
    extends CheckRun {
        public FullCheckRun(Collection<PlanCheck> checks) {
            super(checks);
        }

        @Override
        public PlanCheckReport execute(IProgressMonitor monitor) throws TeamRepositoryException {
            PlanCheckReport currentReport = PlanCheckEngine.this.fPlan.getPlanCheckReport();
            PlanCheckReport result = currentReport != null ? new PlanCheckReport(currentReport) : new PlanCheckReport(PlanCheckEngine.this.fPlan);
            monitor.beginTask("", this.fCheckRunChecks.size());
            for (PlanCheck check : this.fCheckRunChecks) {
                check.runFullCheck(result, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemCheckRun
    extends CheckRun {
        private Collection<? extends PlanElement> fItems;

        public ItemCheckRun(Collection<? extends PlanElement> items, Collection<PlanCheck> checks) {
            super(checks);
            this.fItems = items;
        }

        @Override
        public PlanCheckReport execute(IProgressMonitor monitor) throws TeamRepositoryException {
            PlanCheckReport currentReport = PlanCheckEngine.this.fPlan.getPlanCheckReport();
            PlanCheckReport result = currentReport != null ? new PlanCheckReport(currentReport) : new PlanCheckReport(PlanCheckEngine.this.fPlan);
            monitor.beginTask("", this.fCheckRunChecks.size());
            for (PlanCheck check : this.fCheckRunChecks) {
                check.runElementCheck(result, this.fItems, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
            }
            return result;
        }
    }

    private class PlanDetectionQueue
    extends Job {
        private List fChecks;

        public PlanDetectionQueue() {
            super(Messages.ProblemChecker_NAME);
            this.fChecks = new ArrayList();
        }

        public boolean belongsTo(Object family) {
            return family == PlanCheckEngine.this.fPlan;
        }

        public synchronized boolean isActive() {
            return this.fChecks != null;
        }

        public synchronized boolean add(CheckRun run) {
            if (this.fChecks == null) {
                return false;
            }
            this.fChecks.add(run);
            return true;
        }

        protected IStatus run(IProgressMonitor monitor) {
            CancelAwareProgressMonitor cancelMonitor = new CancelAwareProgressMonitor(monitor);
            CheckRun run = null;
            IStatus result = null;
            while ((run = this.getNextCheckRun()) != null) {
                try {
                    PlanCheckEngine.this.checkCanceled((IProgressMonitor)cancelMonitor);
                    final CheckRun finalRun = run;
                    PlanCheckEngine.this.fPlan.runConnected(new PlanRunnable<TeamRepositoryException>((IProgressMonitor)cancelMonitor){
                        private final /* synthetic */ IProgressMonitor val$cancelMonitor;
                        {
                            this.val$cancelMonitor = iProgressMonitor;
                        }

                        public void run() throws TeamRepositoryException {
                            PlanCheckEngine.this.acceptPlanCheckReport(finalRun.execute(this.val$cancelMonitor));
                        }
                    });
                }
                catch (TeamRepositoryException e) {
                    PlanningClientPlugin.log(e);
                }
            }
            if (result == null) {
                return Status.OK_STATUS;
            }
            return result;
        }

        private synchronized CheckRun getNextCheckRun() {
            if (this.fChecks.size() > 0) {
                return (CheckRun)this.fChecks.remove(0);
            }
            this.fChecks = null;
            return null;
        }
    }
}

