/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.ICorePlanItemFilter;
import com.ibm.team.apt.internal.client.IItemResolveService;
import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.IterationPlanLoadInformation;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.IterationPlanSequenceManager;
import com.ibm.team.apt.internal.client.LinkResolver;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.MissingFutureExecutorServiceException;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanSaveResult;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.progress.ProgressClient;
import com.ibm.team.apt.internal.client.progress.ProgressScriptEnvironment;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningEvent;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.testing.IResolvedIterationPlanTestingAccessor;
import com.ibm.team.apt.internal.client.util.Categories;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.client.wiki.IWikiPageSafeRunnable;
import com.ibm.team.apt.internal.common.EMFUtils;
import com.ibm.team.apt.internal.common.IStore;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.PlanConfigurationStore;
import com.ibm.team.apt.internal.common.ProcessAreaInfo;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_ResolvedWorkItem2;
import com.ibm.team.apt.internal.common.rcp.dto.RcpFactory;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemAwareMap;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedIterationPlan
extends ResolvedPlan {
    public static final String AUXILIARY_DATA_ENCODING = "utf-8";
    private boolean fContentChanged;
    private IIterationPlanRecord fPlanRecord;
    private IPlanType fPlanType;
    private boolean fAlwaysShowAllExecutionItems;
    private Node<IIteration> fIterationHierarchy;
    private Node<IIteration> fContextIterations;
    private ItemSet<IIteration> fPrimaryIterations;
    private ItemSet<IIteration> fSecondaryIterations;
    private IComplexityAttribute fComplexityAttribute;
    private ItemMap<IIterationHandle, LoadInformation> fLoadInformations = new ItemHashMap(CMode.CURRENT);
    private IProcessArea fTeamMemberArea;
    private IDevelopmentLine fDevelopmentLine;
    private IIteration fIteration;
    private IProjectArea fProjectArea;
    private ICategory fPrimaryCategory;
    private ItemSet<ICategoryHandle> fPrimaryCategories;
    private ItemSet<ICategoryHandle> fSecondaryCategories;
    private Set<String> fUnsupportedWorkItemTypes;
    private List<IIteration> fFutureIterations;
    private ItemSet<? extends IContributor> fTeamMembers;
    private ItemSet<? extends IContributor> fAdditionalPlanMembers;
    private ItemSet<? extends IContributor> fOtherOwners;
    private ItemList<IIteration> fRelatedIterations;
    private ItemMap<IContributorHandle, Collection<OutOfOfficeItem>> fAbsences;
    private List<ICorePlanItemFilter> fCoreItemCriteria = new ArrayList<ICorePlanItemFilter>();
    private ItemMap<IContributorHandle, IterationPlanSequenceManager> fSequenceManagers;
    private ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2> fWorkItem2DTOMap = ItemAwareMap.map((CMode)CMode.CURRENT_HANDLEONLY, new ConcurrentHashMap());
    private ItemMap<ICategoryHandle, IProcessArea> fCategories2ProcessArea = new ItemHashMap();
    private ItemMap<IProcessAreaHandle, ICategory> fProcessAreas2PrimaryCategory = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IProcessAreaHandle, ProcessAreaInfo> fProcessAreaMap = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private boolean fCanSavePlan;
    private List<LinkResolver> fFailedLinkLoads = Collections.synchronizedList(new ArrayList());
    private IStore fStore;
    private boolean fAuxiliaryDataChanged;

    public ResolvedIterationPlan(IIterationPlanRecord planRecord, IPlanType planType, IComplexityAttribute complexityAttribute, Node<IIteration> contextIterations, Node<IIteration> iterationHierarchy, IDevelopmentLine developmentLine, IProcessArea teamMemberArea, ItemList<? extends ICategory> categories, IIteration iteration, List<? extends DTO_ResolvedWorkItem2> workItems, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, Collection<IPlanningAttribute<?, ?>> customAttributes, Collection<PlanCheck> planChecks, ItemList<? extends IIteration> relatedIntervals, List<? extends IContributor> teamMembers, List<? extends IContributor> additionalPlanMembers, List<? extends IContributor> otherOwners, Collection<? extends IContributor> creators, Set<String> topLevelWorkItemTypes, List<ProcessAreaInfo> processAreas, IStore store, DurationSupport durationSupport, boolean canSave) {
        super(workItems, attributeDescriptors, customAttributes, planChecks, teamMembers, creators, Arrays.asList(developmentLine), categories.toList(), Arrays.asList(iteration), durationSupport, topLevelWorkItemTypes);
        Assert.isTrue((!categories.isEmpty() ? 1 : 0) != 0, (String)"A plan must have categories");
        this.fCanSavePlan = canSave;
        this.fPlanRecord = planRecord;
        this.fPlanType = planType;
        this.fContextIterations = contextIterations;
        this.fComplexityAttribute = complexityAttribute;
        this.fIterationHierarchy = iterationHierarchy;
        this.fSequenceManagers = new ItemHashMap();
        this.fDevelopmentLine = developmentLine;
        this.fIteration = iteration;
        this.fTeamMembers = new ItemHashSet(teamMembers);
        if (!categories.isEmpty()) {
            ItemCollections.sort(categories, Categories.DEFAULT_COMPARATOR);
            this.fPrimaryCategory = categories.size() == 1 ? (ICategory)categories.get(0) : (!((ICategory)categories.get(0)).isUnassigned() ? (ICategory)categories.get(0) : (ICategory)categories.get(1));
        }
        this.fAdditionalPlanMembers = new ItemHashSet(additionalPlanMembers);
        for (IContributor owner : this.fAdditionalPlanMembers) {
            this.addResolvedOwner(owner);
        }
        this.fOtherOwners = new ItemHashSet(otherOwners);
        for (IContributor owner : this.fOtherOwners) {
            this.addResolvedOwner(owner);
        }
        Iterator iter = iterationHierarchy.depthFirstIterator(null);
        while (iter.hasNext()) {
            this.addResolvedIteration((IIteration)((Node)iter.next()).getElement());
        }
        for (IIteration relatedInterval : relatedIntervals) {
            this.addResolvedIteration(relatedInterval);
        }
        this.fTeamMemberArea = teamMemberArea;
        this.fStore = store;
        if (this.fStore != null) {
            this.fAlwaysShowAllExecutionItems = new PlanConfigurationStore(this.fStore).getAlwaysLoadExecutionItems();
        }
        this.fPrimaryCategories = new ItemHashSet();
        this.fSecondaryCategories = new ItemHashSet();
        for (ProcessAreaInfo info : processAreas) {
            IProcessArea processArea = info.getProcessArea();
            this.fProcessAreaMap.put((IItemHandle)((IProcessAreaHandle)processArea.getItemHandle()), (Object)info);
            ICategory primaryCategory = null;
            if (processArea.sameItemId((IItemHandle)this.getTeamMemberArea())) {
                this.fPrimaryCategories.addAll(info.getCategories());
            } else {
                this.fSecondaryCategories.addAll(info.getCategories());
            }
            for (ICategoryHandle category : info.getCategories()) {
                this.fCategories2ProcessArea.put((IItemHandle)category, (Object)processArea);
                ICategory resolved = this.getResolvedCategory(category);
                if (resolved == null) continue;
                if (primaryCategory == null || primaryCategory.isUnassigned()) {
                    primaryCategory = resolved;
                    continue;
                }
                if (resolved.getCategoryId().compareTo(primaryCategory.getCategoryId()) >= 0) continue;
                primaryCategory = resolved;
            }
            this.addResolvedProcessArea(processArea);
            if (primaryCategory == null) continue;
            this.fProcessAreas2PrimaryCategory.put((IItemHandle)((IProcessAreaHandle)processArea.getItemHandle()), primaryCategory);
        }
    }

    public boolean canSavePlan() {
        return this.fCanSavePlan;
    }

    public IIterationPlanRecord getPlanRecord() {
        return this.fPlanRecord;
    }

    public IPlanType getPlanType() {
        return this.fPlanType;
    }

    public IComplexityAttribute getComplexityAttribute() {
        return this.fComplexityAttribute;
    }

    public IProcessArea getTeamMemberArea() {
        return this.fTeamMemberArea;
    }

    @Override
    public IWorkItemType getDefaultWorkItemType() {
        boolean isIteartionPlan = !this.getPlanType().getPlanItems().isProductPlan() && !this.getPlanType().getPlanItems().isReleasePlan();
        Set<String> topLevelTypes = this.getTopLevelWorkItemTypes();
        List<IWorkItemType> workItemTypes = new ArrayList<IWorkItemType>(this.getWorkItemTypes());
        Iterator typeIterator = workItemTypes.iterator();
        while (typeIterator.hasNext()) {
            if (topLevelTypes.contains(((IWorkItemType)typeIterator.next()).getIdentifier()) != isIteartionPlan) continue;
            typeIterator.remove();
        }
        if (workItemTypes.isEmpty()) {
            workItemTypes = this.getWorkItemTypes();
        }
        if (workItemTypes.isEmpty()) {
            return null;
        }
        if (isIteartionPlan) {
            for (IWorkItemType workItemType : workItemTypes) {
                if (!"task".equals(workItemType.getIdentifier())) continue;
                return workItemType;
            }
        }
        return workItemTypes.get(0);
    }

    @Override
    public ItemCollection<IProcessArea> getTeamMemberAreas() {
        ItemArrayList result = new ItemArrayList(1);
        for (IProcessAreaHandle handle : this.fProcessAreaMap.keySet()) {
            result.add((Object)this.getResolvedProcessArea(handle));
        }
        return ItemCollections.unmodifiableItemCollection((ItemCollection)result);
    }

    @Override
    public IProcessArea getTeamMemberArea(ICategoryHandle category) {
        if (category == null) {
            return null;
        }
        return (IProcessArea)this.fCategories2ProcessArea.get((IItemHandle)category);
    }

    @Override
    public ICategory getPrimaryCategoryFor(IProcessArea area) {
        return (ICategory)this.fProcessAreas2PrimaryCategory.get((IItemHandle)area);
    }

    public IProcessArea getParentFor(IProcessArea area) {
        ProcessAreaInfo info = (ProcessAreaInfo)this.fProcessAreaMap.get((IItemHandle)area);
        if (info == null) {
            return null;
        }
        return this.getResolvedProcessArea(info.getParent());
    }

    public IIteration getInterval() {
        return this.fIteration;
    }

    public Node<IIteration> getIterationHierarchy() {
        return this.fIterationHierarchy;
    }

    public Node<IIteration> getContextIterations() {
        return this.fContextIterations;
    }

    public boolean canAdd(IWorkItemType workItemType, IIterationHandle iteration) {
        if (this.fAlwaysShowAllExecutionItems) {
            return true;
        }
        IIteration resolvedIteration = this.getResolvedIteration(iteration);
        if (resolvedIteration != null && !resolvedIteration.hasDeliverable()) {
            return false;
        }
        if (this.getTopLevelWorkItemTypes().contains(workItemType.getIdentifier())) {
            return true;
        }
        return this.isPrimaryIteration(iteration);
    }

    public boolean canAdd(IWorkItemType workItemType, ICategoryHandle category) {
        if (this.fAlwaysShowAllExecutionItems) {
            return true;
        }
        if (this.getTopLevelWorkItemTypes().contains(workItemType.getIdentifier())) {
            return true;
        }
        return this.isPrimaryCategory(category);
    }

    public boolean isPrimaryIteration(IIterationHandle iteration) {
        if (iteration == null) {
            return false;
        }
        return this.fPrimaryIterations.contains((Object)iteration);
    }

    private boolean isSecondaryIteration(IIterationHandle iteration) {
        if (iteration == null) {
            return false;
        }
        return this.fSecondaryIterations.contains((Object)iteration);
    }

    public boolean isPrimaryCategory(ICategoryHandle category) {
        if (category == null) {
            return false;
        }
        return this.fPrimaryCategories.contains((Object)category);
    }

    private boolean isSecondaryCategory(ICategoryHandle category) {
        if (category == null) {
            return false;
        }
        return this.fSecondaryCategories.contains((Object)category);
    }

    @Override
    public ItemCollection<IContributor> getMemberContributors() {
        return ItemCollections.unmodifiableItemCollection(this.fTeamMembers);
    }

    public ItemCollection<IContributor> getAdditionalPlanMembers() {
        return ItemCollections.unmodifiableItemCollection(this.fAdditionalPlanMembers);
    }

    public ItemCollection<IContributor> getOtherOwners() {
        return ItemCollections.unmodifiableItemCollection(this.fOtherOwners);
    }

    public Collection<IIteration> getFutureIterations() {
        if (this.fFutureIterations == null) {
            this.fFutureIterations = new ArrayList<IIteration>();
            IterationHierarchy iterationHierarchy = this.getDevelopmentLineIterationHierarchy((IDevelopmentLineHandle)this.fDevelopmentLine);
            if (iterationHierarchy != null) {
                this.fFutureIterations.addAll(iterationHierarchy.getFutureIterations().toList());
            }
        }
        return this.fFutureIterations;
    }

    public ItemList<IIteration> getRelatedIterations() {
        if (this.fRelatedIterations == null) {
            this.fRelatedIterations = super.getRelatedIterations((IDevelopmentLineHandle)this.fDevelopmentLine);
            if (!this.fRelatedIterations.contains((Object)this.fIteration)) {
                this.fRelatedIterations.add((Object)this.fIteration);
            }
        }
        return this.fRelatedIterations;
    }

    @Override
    public IIteration suggestCurrentIteration(PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fIteration;
    }

    public boolean isEditingSupported(PlanItem item) {
        return !this.fUnsupportedWorkItemTypes.contains(item.getItemType().getIdentifier());
    }

    public IIterationPlanRecord overwriteRecord(IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager manager = this.getTeamRepository().itemManager();
        IIterationPlanRecord current = (IIterationPlanRecord)manager.fetchCompleteItem((IItemHandle)this.fPlanRecord, 2, monitor);
        EObject from = (EObject)current.getWorkingCopy();
        EObject to = (EObject)this.fPlanRecord.getWorkingCopy();
        EMFUtils.assign((EObject)to, (EObject)from, (EClass)RepositoryPackage.eINSTANCE.getAuditable(), (String[])new String[0]);
        this.fPlanRecord = (IIterationPlanRecord)to;
        return this.fPlanRecord;
    }

    public void setCoreElementCriteria(ICorePlanItemFilter[] filters) {
        this.fCoreItemCriteria.clear();
        this.fCoreItemCriteria.addAll(Arrays.asList(filters));
        this.accept(new IPlanElementVisitor(){

            public boolean visit(PlanElement element) {
                if (element instanceof IterationPlanItem) {
                    ((IterationPlanItem)element).updatePrimaryItemState();
                }
                return true;
            }
        });
    }

    public boolean isActive(PlanItem planItem) {
        IWorkItem workItem = planItem.getWorkItem(false);
        if (workItem == null) {
            return false;
        }
        return this.isInProgress(planItem);
    }

    public boolean isCoreItem(PlanItem item) {
        if (!this.matchesPlanQuery(item.getWorkItem(false))) {
            return false;
        }
        for (ICorePlanItemFilter filter : this.fCoreItemCriteria) {
            if (filter.isCoreItem(item)) continue;
            return false;
        }
        return true;
    }

    boolean wasCoreItem(PlanItem item, WorkItemChangeEvent event) {
        ChangeDetails typeDetails;
        IAdaptable details = event.getAttributeChangeDetails(IWorkItem.TARGET_PROPERTY);
        ChangeDetails targetDetails = details instanceof ChangeDetails ? (ChangeDetails)details : null;
        details = event.getAttributeChangeDetails(IWorkItem.CATEGORY_PROPERTY);
        ChangeDetails categoryDetails = details instanceof ChangeDetails ? (ChangeDetails)details : null;
        details = event.getAttributeChangeDetails(IWorkItem.PROJECT_AREA_PROPERTY);
        ChangeDetails projectAreaDetails = details instanceof ChangeDetails ? (ChangeDetails)details : null;
        if (!this.matchesPlanQuery(projectAreaDetails != null ? (IProjectAreaHandle)projectAreaDetails.getOldValue() : this.getProjectAreaHandle(), categoryDetails != null ? (ICategoryHandle)categoryDetails.getOldValue() : item.getCategoryHandle(), targetDetails != null ? (IIterationHandle)targetDetails.getOldValue() : item.getTargetHandle(), (typeDetails = (details = event.getAttributeChangeDetails(IWorkItem.TYPE_PROPERTY)) instanceof ChangeDetails ? (ChangeDetails)details : null) != null ? (String)typeDetails.getOldValue() : item.getItemType().getIdentifier())) {
            return false;
        }
        for (ICorePlanItemFilter filter : this.fCoreItemCriteria) {
            if (filter.wasCoreItem(item, event)) continue;
            return false;
        }
        return true;
    }

    public IResolvedIterationPlanTestingAccessor getTestingAccessor() {
        return new IResolvedIterationPlanTestingAccessor(){};
    }

    public IWorkHoursDefinition getWorkHourDefinitions(IContributorHandle contributorHandle) {
        IterationPlanSequenceManager sequenceManager = this.getItemSequenceManager(contributorHandle);
        return sequenceManager != null ? sequenceManager.getWorkHourDefinition() : null;
    }

    public IterationPlanSequenceManager getItemSequenceManager(IContributorHandle owner) {
        return owner != null ? (IterationPlanSequenceManager)this.fSequenceManagers.get((IItemHandle)owner) : null;
    }

    @Override
    public ItemSequenceManager getItemSequenceManager(IScheduleItem scheduleItem) {
        return this.getItemSequenceManager((IContributorHandle)scheduleItem.getOwner());
    }

    public IStore getStore() {
        return this.fStore;
    }

    void addFailedLinkLoad(LinkResolver resolver) {
        this.fFailedLinkLoads.add(resolver);
    }

    @Override
    public IterationPlanItem getPlanItem(IWorkItemHandle handle) {
        return (IterationPlanItem)super.getPlanItem(handle);
    }

    @Override
    public String getName() {
        return this.fPlanRecord.getName();
    }

    @Override
    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    @Override
    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fTeamMemberArea.getProjectArea();
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return (ITeamRepository)this.fPlanRecord.getOrigin();
    }

    @Override
    public LoadInformation getLoadInformation(IIterationHandle handle) {
        return (LoadInformation)this.fLoadInformations.get((IItemHandle)handle);
    }

    @Override
    public Date getEndDate() {
        return this.fIteration.getEndDate();
    }

    @Override
    public Date getStartDate() {
        return this.fIteration.getStartDate();
    }

    @Override
    public ItemSet<IIteration> getPlannedIterations() {
        ItemHashSet result = new ItemHashSet();
        result.add((IItemHandle)this.fIteration);
        return result;
    }

    @Override
    public Collection<OutOfOfficeItem> getAbsences() {
        ArrayList<OutOfOfficeItem> result = new ArrayList<OutOfOfficeItem>();
        for (Collection absences : this.fAbsences.values()) {
            result.addAll(absences);
        }
        return result;
    }

    public Collection<OutOfOfficeItem> getAbsences(IContributorHandle teamMember) {
        if (!this.fAbsences.containsKey((IItemHandle)teamMember)) {
            return null;
        }
        return (Collection)this.fAbsences.get((IItemHandle)teamMember);
    }

    @Override
    public synchronized void connect(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 10);
        this.fPrimaryIterations = new ItemHashSet();
        this.fSecondaryIterations = new ItemHashSet();
        IAuditableClient auditableCommon = PlanningClientPlugin.getAuditableClient((IItemHandle)this.fPlanRecord);
        Iterations.distributeIterations(this.fPrimaryIterations, this.fSecondaryIterations, (IIteration)this.fIteration, null, this.fIterationHierarchy, (IAuditableCommon)auditableCommon, (IProgressMonitor)new NullProgressMonitor());
        super.connect((IProgressMonitor)new SubProgressMonitor(monitor, 8));
    }

    @Override
    protected void doConnect(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 4 + this.getOwners().size());
        try {
            this.fUnsupportedWorkItemTypes = new HashSet<String>();
            this.fProjectArea = (IProjectArea)PlanningClientPlugin.getTeamRepository((IItemHandle)this.fPlanRecord).itemManager().fetchCompleteItem((IItemHandle)this.fTeamMemberArea.getProjectArea(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fAbsences = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
            IContributorInfo contributorInfo = this.fetchContributorInfo(this.getOwners(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (IContributor owner : this.fTeamMembers) {
                this.fAbsences.put((IItemHandle)owner, this.doCreateAbsences(contributorInfo.getAbsences((IContributorHandle)owner)));
                IterationPlanSequenceManager sequenceManager = new IterationPlanSequenceManager(this, (IContributorHandle)owner);
                int workAssignment = contributorInfo.getWorkAssignment((IContributorHandle)owner, (IProcessAreaHandle)this.fTeamMemberArea, (IDevelopmentLineHandle)this.fDevelopmentLine);
                sequenceManager.initialize(contributorInfo.getWorkLocation((IContributorHandle)owner), workAssignment, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fSequenceManagers.put((IItemHandle)owner, (Object)sequenceManager);
            }
            IterationPlanLoadInformation loadInformation = new IterationPlanLoadInformation(this, this.getInterval(), this.getCategories());
            loadInformation.connect(monitor);
            this.fLoadInformations.put((IItemHandle)this.getInterval(), (Object)loadInformation);
            this.fContentChanged = this.getDirtyWorkingCopies(false).length > 0;
        }
        finally {
            monitor.done();
        }
    }

    private void addAll(Node<IIteration> node, ItemSet<IIteration> target) {
        target.add((Object)((IIteration)node.getElement()));
        for (Node child : node.getChildren()) {
            this.addAll((Node<IIteration>)child, target);
        }
    }

    @Override
    protected IWorkItem doConnectWorkItem(IWorkItemWorkingCopyManager workingCopyManager, Object workItemTransportObject, IProgressMonitor monitor) throws TeamRepositoryException {
        DTO_ResolvedWorkItem2 resolvedWorkItem = (DTO_ResolvedWorkItem2)workItemTransportObject;
        IWorkItem wi = resolvedWorkItem.getWorkItem();
        ItemProfile profile = ItemProfile.computeProfile((IAuditable)wi);
        workingCopyManager.connect((IWorkItemHandle)wi, profile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return wi;
    }

    @Override
    protected void doDisconnect() {
        for (IterationPlanSequenceManager sequenceManager : this.fSequenceManagers.values()) {
            sequenceManager.dispose();
        }
        this.fSequenceManagers.clear();
        for (LoadInformation next : this.fLoadInformations.values()) {
            next.disconnect();
            next.dispose();
        }
        this.fLoadInformations.clear();
    }

    @Override
    public void triggerCheckerCalculation() {
        super.triggerCheckerCalculation();
    }

    @Override
    public void setReferenceTime(Date referenceTime) {
        super.setReferenceTime(referenceTime);
        for (IterationPlanSequenceManager sequenceManager : this.fSequenceManagers.values()) {
            sequenceManager.updateReferenceTime();
        }
    }

    @Override
    public void adopt(IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemWorkingCopyManager workingCopyManager = this.getWorkingCopyManager(false);
        try {
            boolean categoryMatchesPlan;
            if (workingCopyManager.connectLocal((IWorkItemHandle)item, this.getWorkItemProfile())) {
                try {
                    WorkItemWorkingCopy workingCopy = workingCopyManager.getWorkingCopy((IWorkItemHandle)item);
                    Assert.isTrue((boolean)this.fWorkItem2DTOMap.isEmpty());
                    if (this.getPlanItem((IWorkItemHandle)workingCopy.getWorkItem()) == null || this.isResolvingRequired(workingCopy)) {
                        List<IWorkItemHandle> toResolve = Collections.singletonList((IWorkItemHandle)workingCopy.getWorkItem().getItemHandle());
                        List<Object> workItemDTOs = this.internalResolveWorkItem(toResolve, monitor);
                        for (Object dtoObject : workItemDTOs) {
                            DTO_ResolvedWorkItem2 workItemDTO = (DTO_ResolvedWorkItem2)dtoObject;
                            IWorkItem resolvedWorkItem = workItemDTO.getWorkItem();
                            if (!this.contains((IWorkItemHandle)resolvedWorkItem)) {
                                this.addResolvedWorkItem(resolvedWorkItem);
                            }
                            this.fWorkItem2DTOMap.put((IItemHandle)((IWorkItemHandle)resolvedWorkItem.getItemHandle()), (Object)workItemDTO);
                        }
                    }
                }
                finally {
                    workingCopyManager.disconnect((IWorkItemHandle)item);
                }
            }
            for (ICorePlanItemFilter filter : this.fCoreItemCriteria) {
                filter.adopt(item);
            }
            item.setTarget((IIterationHandle)this.fIteration);
            ICategoryHandle currentCategory = item.getCategory();
            boolean bl = categoryMatchesPlan = currentCategory != null && this.getResolvedCategory(currentCategory) != null;
            if (this.fPrimaryCategory != null && !categoryMatchesPlan || currentCategory != null && currentCategory.sameItemId((IItemHandle)this.getUnassignedCategory())) {
                item.setCategory((ICategoryHandle)this.fPrimaryCategory);
            }
            if (item.getOwner() == null) {
                item.setOwner((IContributorHandle)this.getNullOwner());
            }
        }
        finally {
            this.fWorkItem2DTOMap.clear();
        }
    }

    @Override
    protected void initializeNewPlanItem(PlanItem item, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    @Override
    public List<String> getUnrelevantWorkItemReasons(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 3 + this.fCoreItemCriteria.size());
        try {
            ArrayList<String> result = new ArrayList<String>();
            if (this.getResolvedCategory(workItem.getCategory()) == null) {
                IWorkItemClient workItemClient = (IWorkItemClient)this.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                IProcessAreaHandle processAreaHandle = workItemClient.findProcessArea((IWorkItemHandle)workItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (processAreaHandle instanceof ITeamAreaHandle) {
                    ITeamArea teamArea = (ITeamArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(NLS.bind((String)Messages.ResolvedIterationPlan_BELONGS_TO_TEAM_AREA, (Object)teamArea.getName(), (Object[])new Object[0]));
                }
            } else {
                monitor.worked(2);
            }
            if (!this.fIteration.sameItemId((IItemHandle)workItem.getTarget())) {
                if (workItem.getTarget() == null) {
                    result.add(Messages.ResolvedIterationPlan_BELONGS_TO_UNASSIGNED_ITERATION);
                } else {
                    IIteration iteration = (IIteration)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workItem.getTarget(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(NLS.bind((String)Messages.ResolvedIterationPlan_BELONGS_TO_ITERATION, (Object)iteration.getLabel(), (Object[])new Object[0]));
                }
            } else {
                monitor.worked(1);
            }
            IterationPlanItem planItem = this.getPlanItem((IWorkItemHandle)workItem);
            if (planItem != null) {
                for (ICorePlanItemFilter filter : this.fCoreItemCriteria) {
                    result.addAll(filter.getUnrelevantWorkItemReasons(planItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                }
            } else {
                monitor.worked(this.fCoreItemCriteria.size());
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected PlanItem doCreateNewPlanItem(PlanElement parent, WorkItemWorkingCopy workingCopy) {
        if (parent instanceof PlanItem) {
            IWorkItem workItemParent = ((PlanItem)parent).getWorkItem(false);
            IWorkItemHandle currentParent = WorkItems.getParent(workingCopy, this.fWorkItem2DTOMap);
            if (currentParent == null || !workItemParent.sameItemId((IItemHandle)currentParent)) {
                WorkItems.setParent(workingCopy, workItemParent, this.getTopLevelWorkItemTypes());
            }
        }
        return new IterationPlanItem(this, parent, workingCopy);
    }

    @Override
    protected void doProcessResourcePlanningUpdate(ResourcePlanningEvent event) {
        final IterationPlanSequenceManager sequenceManager = (IterationPlanSequenceManager)this.fSequenceManagers.get((IItemHandle)event.getAuditable());
        if (sequenceManager != null) {
            IResourcePlanningInfo planningInfo = event.getInfo();
            if (planningInfo instanceof IContributorInfo) {
                this.updateWorkTime(planningInfo, sequenceManager);
            } else {
                FoundationJob updateJob = new FoundationJob(Messages.ResolvedPersonalPlan_JOB_UPDATE_RESOURCEPLANNINGDATA){

                    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                        ResolvedIterationPlan.this.updateWorkTime(ResolvedIterationPlan.this.fetchContributorInfo((ItemCollection<? extends IContributorHandle>)ItemCollections.singleton((Object)sequenceManager.getOwner()), monitor), sequenceManager);
                        return Status.OK_STATUS;
                    }
                };
                updateJob.setUser(false);
                updateJob.setSystem(true);
                updateJob.schedule();
            }
        }
    }

    private void updateWorkTime(IResourcePlanningInfo planningInfo, ItemSequenceManager sequenceManager) {
        this.connectDeltaBuilder();
        try {
            IContributorInfo contributorInfo = (IContributorInfo)planningInfo;
            IContributorHandle owner = sequenceManager.getOwner();
            int workAssignment = contributorInfo.getWorkAssignment(owner, (IProcessAreaHandle)this.fTeamMemberArea, (IDevelopmentLineHandle)this.fDevelopmentLine);
            sequenceManager.updateWorkTime(contributorInfo.getWorkLocation(owner), workAssignment);
            this.addAttributeChange(RESOURCE_PLANNING, null, null);
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    @Override
    protected void processItems(List workItemTransportObjects) {
        List resolvedWorkItems = workItemTransportObjects;
        ItemHashMap itemMap = new ItemHashMap(resolvedWorkItems.size() * 2);
        for (DTO_ResolvedWorkItem2 resolvedWorkItem : resolvedWorkItems) {
            itemMap.put((IItemHandle)resolvedWorkItem.getWorkItem(), (Object)resolvedWorkItem);
        }
        for (Object object : workItemTransportObjects) {
            DTO_ResolvedWorkItem2 resolvedWorkItem = (DTO_ResolvedWorkItem2)object;
            if (this.getPlanItem((IWorkItemHandle)resolvedWorkItem.getWorkItem()) != null) continue;
            this.processItem(resolvedWorkItem, (ItemHashSet<IWorkItemHandle>)new ItemHashSet(), (ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2>)itemMap);
        }
    }

    protected List<IterationPlanItem> processItem(IWorkItem item) {
        DTO_ResolvedWorkItem2 resolvedWorkItem = RcpFactory.eINSTANCE.createDTO_ResolvedWorkItem2();
        resolvedWorkItem = (DTO_ResolvedWorkItem2)this.fWorkItem2DTOMap.get((IItemHandle)item);
        if (resolvedWorkItem == null) {
            resolvedWorkItem = RcpFactory.eINSTANCE.createDTO_ResolvedWorkItem2();
            resolvedWorkItem.setWorkItem(item);
            resolvedWorkItem.setParent(WorkItems.getParent(this.getWorkingCopyManager(false), (IWorkItemHandle)item, this.fWorkItem2DTOMap));
            ItemHashMap itemMap = new ItemHashMap();
            itemMap.put((IItemHandle)item, (Object)resolvedWorkItem);
            return this.processItem(resolvedWorkItem, (ItemHashSet<IWorkItemHandle>)new ItemHashSet(), (ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2>)itemMap);
        }
        return this.processItem(resolvedWorkItem, (ItemHashSet<IWorkItemHandle>)new ItemHashSet(), this.fWorkItem2DTOMap);
    }

    @Override
    public boolean isRelevantForPlan(IWorkItem wi) {
        if (this.matchesPlanQuery(wi)) {
            return true;
        }
        IterationPlanItem planItem = this.getPlanItem((IWorkItemHandle)wi);
        if (planItem == null) {
            return false;
        }
        if (!((PlanItem)planItem).isProgressPlanItem()) {
            return this.isPlanItemRelevant(planItem);
        }
        PlanElement parent = planItem.getParent();
        while (parent != null) {
            PlanItem parentItem;
            if (parent instanceof PlanItem && !(parentItem = (PlanItem)parent).isProgressPlanItem() && this.isPlanItemRelevant(parentItem)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private boolean isPlanItemRelevant(PlanItem item) {
        if (this.matchesPlanQuery(item.getWorkItem(false))) {
            return true;
        }
        PlanElement[] planElementArray = item.getChildren();
        int n = planElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlanElement child = planElementArray[n2];
            if (child instanceof PlanItem && this.isPlanItemRelevant((PlanItem)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public PlanSaveResult save(IWikiPageSafeRunnable[] wikiSaves, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        boolean oldDirty = this.isDirty();
        PlanDeltaBuilder builder = this.connectDeltaBuilder();
        try {
            monitor.beginTask(Messages.ResolvedPlan_MONITOR_SAVE, 3);
            this.writeSequenceValues(this.getAllPlanItems(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            Iterator<LinkResolver> iter = this.fFailedLinkLoads.iterator();
            while (iter.hasNext()) {
                LinkResolver resolver = iter.next();
                if (resolver.getWorkingCopy().isReferencesSet()) {
                    iter.remove();
                    continue;
                }
                this.getResolveService().blockingResolve(resolver);
                resolver.getPlanItem().updateReferences();
                iter.remove();
            }
            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)this.fPlanRecord);
            WorkItemWorkingCopy[] dirtyWorkingCopies = this.getDirtyWorkingCopies(true);
            IterationPlanSaveResult result = client.save(this.canSavePlan(), this.fPlanRecord, this.getWorkingCopyManager(false), dirtyWorkingCopies, this.fAuxiliaryDataChanged ? this.fStore : null, wikiSaves, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!result.getStatus().matches(4)) {
                this.fPlanRecord = result.getPlanRecord();
                this.fAuxiliaryDataChanged = false;
                WorkItemWorkingCopy[] workItemWorkingCopyArray = dirtyWorkingCopies;
                int n = dirtyWorkingCopies.length;
                int n2 = 0;
                while (n2 < n) {
                    WorkItemWorkingCopy workingCopy = workItemWorkingCopyArray[n2];
                    IterationPlanItem planItem = this.getPlanItem((IWorkItemHandle)workingCopy.getWorkItem());
                    if (planItem != null) {
                        planItem.updatePrimaryItemState(builder);
                    }
                    ++n2;
                }
            }
            if (!result.getStatus().matches(4)) {
                this.fContentChanged = false;
                this.disconnectRemovedPlanItems();
            }
            IterationPlanSaveResult iterationPlanSaveResult = result;
            return iterationPlanSaveResult;
        }
        finally {
            monitor.done();
            if (oldDirty != this.isDirty()) {
                builder.changed(this, DIRTY, new Boolean(oldDirty), new Boolean(this.isDirty()));
            }
            this.disconnectDeltaBuilder();
        }
    }

    @Override
    public boolean isDirty() {
        return this.fContentChanged || this.fAuxiliaryDataChanged;
    }

    @Override
    public void markAsDirty() {
        boolean oldDirty = this.isDirty();
        this.fContentChanged = true;
        if (!oldDirty) {
            this.addAttributeChange(DIRTY, false, true);
        }
    }

    public void setAuxiliaryDataChanged() {
        boolean oldDirty = this.isDirty();
        this.fAuxiliaryDataChanged = true;
        if (!oldDirty) {
            this.addAttributeChange(DIRTY, false, true);
        }
    }

    @Override
    protected void doRecomputeWorkItemDirtyState() {
        if (this.hasDirtyWorkingCopies()) {
            this.markAsDirty();
        } else if (this.fContentChanged) {
            this.fContentChanged = false;
            if (!this.isDirty()) {
                this.addAttributeChange(DIRTY, true, false);
            }
        }
    }

    @Override
    protected void handleDirtyStateChanged(WorkingCopyEvent event) {
        this.connectDeltaBuilder();
        try {
            IterationPlanItem planItem = this.getPlanItem((IWorkItemHandle)event.getSource().getWorkItem());
            if (planItem != null) {
                if (event.getSource().isDirty() && planItem.isWriteable()) {
                    this.markAsDirty();
                } else {
                    this.doRecomputeWorkItemDirtyState();
                }
            }
            super.handleDirtyStateChanged(event);
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    protected void onWriteableStateChange(IterationPlanItem item, boolean isWriteable) {
        this.connectDeltaBuilder();
        try {
            if (isWriteable && item.isDirty()) {
                this.markAsDirty();
            } else {
                this.doRecomputeWorkItemDirtyState();
            }
        }
        finally {
            this.disconnectDeltaBuilder();
        }
    }

    @Override
    protected boolean isResolvingRequired(WorkItemWorkingCopy workingCopy) {
        IWorkItem workItem = workingCopy.getWorkItem();
        IContributorHandle ownerHandle = workItem.getOwner();
        IContributor owner = this.getResolvedContributor(ownerHandle);
        if (owner == null) {
            IItemManager manager = this.getTeamRepository().itemManager();
            owner = (IContributor)manager.getSharedItemIfKnown((IItemHandle)ownerHandle);
            if (owner == null) {
                return true;
            }
            this.addResolvedOwner(owner);
        }
        if (!this.fWorkItem2DTOMap.containsKey((IItemHandle)workItem) && !workingCopy.isReferencesSet()) {
            return true;
        }
        IWorkItemHandle parentHandle = WorkItems.getParent(workingCopy, this.fWorkItem2DTOMap);
        return parentHandle != null && this.getResolvedWorkItem(parentHandle) == null;
    }

    @Override
    protected void doResolvePlanItems(final List<IWorkItemHandle> workItemHandles, final IDeferredResolveListener<List<Object>> listener, boolean isBlocking) throws MissingFutureExecutorServiceException {
        IItemResolveService resolveService = this.getResolveService();
        Assert.isNotNull((Object)resolveService);
        for (IWorkItemHandle workItemHandle : workItemHandles) {
            this.setWorkItemIgnored(workItemHandle, true);
        }
        IDeferredResolver<List<Object>> resolver = new IDeferredResolver<List<Object>>(){

            @Override
            public List<Object> resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    List list = ResolvedIterationPlan.this.internalResolveWorkItem(workItemHandles, monitor);
                    return list;
                }
                finally {
                    monitor.done();
                }
            }
        };
        resolveService.deferredResolve(resolver, new IDeferredResolveListener<List<Object>>(){

            @Override
            public void resolved(List<Object> result) {
                ItemHashMap itemMap = new ItemHashMap();
                for (DTO_ResolvedWorkItem2 dTO_ResolvedWorkItem2 : result) {
                    itemMap.put((IItemHandle)dTO_ResolvedWorkItem2.getWorkItem(), (Object)dTO_ResolvedWorkItem2);
                    ResolvedIterationPlan.this.addResolvedWorkItem(dTO_ResolvedWorkItem2.getWorkItem());
                }
                try {
                    ResolvedIterationPlan.this.connectDeltaBuilder();
                    for (IWorkItemHandle workItemHandle : workItemHandles) {
                        DTO_ResolvedWorkItem2 item = (DTO_ResolvedWorkItem2)itemMap.get((IItemHandle)workItemHandle);
                        try {
                            if (item != null) {
                                List items = ResolvedIterationPlan.this.processItem(item, (ItemHashSet<IWorkItemHandle>)new ItemHashSet(), (ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2>)((ItemMap)itemMap));
                                if (listener != null) {
                                    listener.resolved(result);
                                }
                                if (!items.isEmpty()) {
                                    ResolvedIterationPlan.this.itemsAdded(items);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            ResolvedIterationPlan.this.setWorkItemIgnored(workItemHandle, item != null);
                            throw throwable;
                        }
                        ResolvedIterationPlan.this.setWorkItemIgnored(workItemHandle, item != null);
                    }
                }
                finally {
                    ResolvedIterationPlan.this.disconnectDeltaBuilder();
                }
            }

            @Override
            public void canceled() {
                if (listener != null) {
                    listener.canceled();
                }
            }

            @Override
            public void failed(IStatus state) {
                PlanningClientPlugin.log(state);
                if (listener != null) {
                    listener.failed(state);
                }
            }
        }, true);
    }

    @Override
    public boolean matchesPlanQuery(PlanItem item) {
        return this.matchesPlanQuery(item.getWorkItem(false));
    }

    boolean matchesPlanQuery(IWorkItem wi) {
        return this.matchesPlanQuery(wi.getProjectArea(), wi.getCategory(), wi.getTarget(), wi.getWorkItemType());
    }

    private boolean matchesPlanQuery(IProjectAreaHandle projectAreaHandle, ICategoryHandle categoryHandle, IIterationHandle iterationHandle, String workItemType) {
        if (!projectAreaHandle.sameItemId((IItemHandle)this.getProjectAreaHandle())) {
            return false;
        }
        boolean isPlanCategory = this.isPrimaryCategory(categoryHandle);
        boolean isPlanIteration = this.isPrimaryIteration(iterationHandle);
        if (isPlanCategory && isPlanIteration) {
            return true;
        }
        if ((isPlanCategory |= this.isSecondaryCategory(categoryHandle)) && (isPlanIteration |= this.isSecondaryIteration(iterationHandle))) {
            return this.fAlwaysShowAllExecutionItems || this.getTopLevelWorkItemTypes().contains(workItemType);
        }
        return false;
    }

    private List<IterationPlanItem> processItem(DTO_ResolvedWorkItem2 resolvedWorkItem, ItemHashSet<IWorkItemHandle> childSet, ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2> itemMap) {
        IWorkItem item = resolvedWorkItem.getWorkItem();
        IterationPlanItem planItem = this.getPlanItem((IWorkItemHandle)item);
        if (planItem != null) {
            return Collections.EMPTY_LIST;
        }
        if (childSet.contains((Object)item)) {
            PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), "Ignored parent to avoid a reference cycle; consider reopening all jazz related editors"));
            return Collections.EMPTY_LIST;
        }
        WorkItemWorkingCopy wc = this.getWorkingCopyManager(true).getWorkingCopy((IWorkItemHandle)item);
        IWorkItemHandle parent = resolvedWorkItem.getParent();
        IWorkItem parentWorkItem = parent != null ? this.getResolvedWorkItem(parent) : null;
        PlanElement parentElement = this;
        ArrayList<IterationPlanItem> result = new ArrayList<IterationPlanItem>();
        if (parentWorkItem != null) {
            IterationPlanItem parentItem = this.getPlanItem((IWorkItemHandle)parentWorkItem);
            if (parentItem == null) {
                childSet.add((IItemHandle)item);
                result.addAll(this.processItem((DTO_ResolvedWorkItem2)itemMap.get((IItemHandle)parent), childSet, itemMap));
                Assert.isTrue((!result.isEmpty() ? 1 : 0) != 0);
                parentItem = (IterationPlanItem)result.get(result.size() - 1);
                childSet.remove((Object)item);
            }
            if (parentItem != null) {
                parentElement = parentItem;
            }
        }
        IterationPlanItem newItem = new IterationPlanItem(this, parentElement, wc);
        if (resolvedWorkItem.getProgress() != null) {
            newItem.setProgressInfo(ProgressClient.convert(resolvedWorkItem.getProgress(), new ProgressScriptEnvironment()));
        }
        result.add(newItem);
        return result;
    }

    @Override
    protected void itemsAdded(List<? extends PlanItem> items) {
        for (PlanItem planItem : items) {
            IterationPlanSequenceManager sequenceManager = this.getItemSequenceManager((IContributorHandle)planItem.getOwner());
            if (sequenceManager == null) continue;
            sequenceManager.itemAdded(planItem);
        }
        super.itemsAdded(items);
    }

    private List<Object> internalResolveWorkItem(List<IWorkItemHandle> workItemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemWorkingCopyManager workingCopyManager = this.getWorkingCopyManager(true);
        Assert.isNotNull((Object)workingCopyManager);
        monitor.beginTask(Messages.ResolvedIterationPlan_MONITOR_RESOLVING_ITEMS, -1);
        ITeamRepository teamRepository = this.getTeamRepository();
        IItemManager itemManager = teamRepository.itemManager();
        ItemProfile<IWorkItem> workItemProfile = this.getWorkItemProfile();
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<IWorkItemHandle> iterator = workItemHandles.iterator();
        while (iterator.hasNext()) {
            IWorkItemHandle workItemHandle;
            IWorkItemHandle toResolve = workItemHandle = iterator.next();
            while (toResolve != null) {
                IWorkItem workItem = this.getResolvedWorkItem(toResolve);
                if (workItem == null || !this.isParentKnown(workingCopyManager, workItem)) {
                    DTO_ResolvedWorkItem2 resolvedWorkItem = ((IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)toResolve)).fetchResolvedWorkItem(toResolve, this.getWorkItemProfile(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    workItem = resolvedWorkItem.getWorkItem();
                    if (workItem.getProjectArea().sameItemId((IItemHandle)this.getProjectAreaHandle())) {
                        result.add(resolvedWorkItem);
                        workingCopyManager.connect((IWorkItemHandle)workItem, workItemProfile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        IContributorHandle ownerHandle = workItem.getOwner();
                        IContributor owner = this.getResolvedContributor(ownerHandle);
                        if (owner == null) {
                            owner = (IContributor)itemManager.getSharedItemIfKnown((IItemHandle)ownerHandle);
                            if (owner == null) {
                                owner = (IContributor)itemManager.fetchCompleteItem((IItemHandle)ownerHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            this.addResolvedOwner(owner);
                        }
                    }
                    toResolve = resolvedWorkItem.getParent();
                    continue;
                }
                toResolve = null;
            }
        }
        return result;
    }

    private boolean isParentKnown(IWorkItemWorkingCopyManager workingCopyManager, IWorkItem workItem) {
        WorkItemWorkingCopy wc = workingCopyManager.getWorkingCopy((IWorkItemHandle)workItem);
        return wc != null && wc.isReferencesSet();
    }
}

