/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.UnsupportedReceiverTypeException;
import com.ibm.team.apt.internal.client.planchecker.CheckerReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;

public abstract class PlanElement
extends PlatformObject
implements IAdaptable {
    public static final IPlanningAttributeIdentifier CHILDREN = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.children");
    public static final IPlanningAttributeIdentifier CHILDREN_COUNT = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.childrenCount");
    public static final IPlanningAttributeIdentifier PLANCHECK_REPORT = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.verificationReport");
    public static final IPlanningAttributeIdentifier DIRTY = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.dirty");
    public static final PlanElement[] EMPTY_ARRAY = new PlanElement[0];
    private final List<PlanElement> fChildren;

    protected PlanElement() {
        this(false);
    }

    protected PlanElement(boolean createChildren) {
        this.fChildren = Collections.synchronizedList(createChildren ? new ArrayList() : new ArrayList(0));
    }

    public abstract ResolvedPlan getPlan();

    public abstract CheckerReport getPlanCheckReport();

    public abstract boolean isDirty();

    public abstract PlanElement getParent();

    public abstract void moveTo(PlanElement var1);

    public PlanElement[] getChildren() {
        return this.fChildren.toArray(new PlanElement[this.fChildren.size()]);
    }

    public int getChildrenCount() {
        return this.fChildren.size();
    }

    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public void accept(IPlanElementVisitor visitor) {
        if (visitor.visit(this)) {
            PlanElement[] planElementArray = this.fChildren.toArray(new PlanElement[this.fChildren.size()]);
            int n = planElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlanElement element = planElementArray[n2];
                element.accept(visitor);
                ++n2;
            }
        }
    }

    public void addChild(PlanElement element) {
        this.fChildren.add(element);
        this.childAdded(this, element);
    }

    public boolean removeChild(PlanElement element) {
        if (this.fChildren.remove((Object)element)) {
            this.childRemoved(this, element);
            return true;
        }
        return false;
    }

    public Object getAttributeValue(IPlanningAttributeIdentifier attributeIdentifier) {
        IPlanningAttribute attribute = this.getPlan().findAttribute(attributeIdentifier);
        if (!attribute.isSupported(((Object)((Object)this)).getClass())) {
            throw new UnsupportedReceiverTypeException(attribute, ((Object)((Object)this)).getClass());
        }
        return attribute.getValue(this);
    }

    public void setAttributeValue(IPlanningAttributeIdentifier attributeIdentifier, Object value) {
        IPlanningAttribute attribute = this.getPlan().findAttribute(attributeIdentifier);
        if (!attribute.isSupported(((Object)((Object)this)).getClass())) {
            throw new UnsupportedReceiverTypeException(attribute, ((Object)((Object)this)).getClass());
        }
        attribute.setValue(this, value);
    }

    protected abstract void doChildAdded(PlanElement var1, PlanElement var2);

    protected abstract void doChildRemoved(PlanElement var1, PlanElement var2);

    private void childAdded(PlanElement parent, PlanElement child) {
        this.doChildAdded(parent, child);
    }

    private void childRemoved(PlanElement parent, PlanElement child) {
        this.doChildRemoved(parent, child);
    }

    protected void clearChildren() {
        PlanElement[] planElementArray = this.fChildren.toArray(new PlanElement[this.fChildren.size()]);
        int n = planElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlanElement child = planElementArray[n2];
            child.clearChildren();
            ++n2;
        }
        this.fChildren.clear();
    }
}

