/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.IterationPlanSequenceManager;
import com.ibm.team.apt.internal.client.LinkResolver;
import com.ibm.team.apt.internal.client.MissingFutureExecutorServiceException;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.duration.IQueryableProgressInformation;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlanItem
extends PlanItem {
    private static final long CALCULATED_DURATION_UNSPECIFIED = Duration.UNSPECIFIED.longValue();
    private final List<PlanItem> fDependentItems = new ArrayList<PlanItem>();
    private final List<PlanItem> fDependsOnItems = new ArrayList<PlanItem>();
    private IQueryableProgressInformation fProgressInfo;
    private boolean fIsPrimaryItem;
    private static final Map<String, IPlanningAttributeIdentifier> ATTRIBUTE_MAP = new HashMap<String, IPlanningAttributeIdentifier>();

    static {
        ATTRIBUTE_MAP.put(IWorkItem.ID_PROPERTY, ID);
        ATTRIBUTE_MAP.put(IWorkItem.TYPE_PROPERTY, ITEM_TYPE);
        ATTRIBUTE_MAP.put(IWorkItem.SUMMARY_PROPERTY, SUMMARY);
        ATTRIBUTE_MAP.put(IWorkItem.DESCRIPTION_PROPERTY, DESCRIPTION);
        ATTRIBUTE_MAP.put(IWorkItem.OWNER_PROPERTY, OWNER);
        ATTRIBUTE_MAP.put(IWorkItem.TARGET_PROPERTY, TARGET);
        ATTRIBUTE_MAP.put(IWorkItem.CATEGORY_PROPERTY, CATEGORY);
        ATTRIBUTE_MAP.put(IWorkItem.STATE_PROPERTY, STATE);
        ATTRIBUTE_MAP.put(IWorkItem.DURATION_PROPERTY, ORIGINAL_ESTIMATE);
        ATTRIBUTE_MAP.put(WorkItem.CORRECTED_ESTIMATE_PROPERTY, CORRECTED_ESTIMATE);
        ATTRIBUTE_MAP.put(WorkItem.TIME_SPENT_PROPERTY, TIMESPENT);
        ATTRIBUTE_MAP.put(IWorkItem.DUE_DATE_PROPERTY, DUE_DATE);
        ATTRIBUTE_MAP.put(IWorkItem.TAGS_PROPERTY, TAGS);
    }

    public IterationPlanItem(ResolvedPlan plan, PlanElement parent, WorkItemWorkingCopy wc) {
        super(wc, plan, parent);
        this.getParent().addChild(this);
        if (parent instanceof PlanItem && wc.isReferencesSet()) {
            IWorkItem parentWorkItem = ((PlanItem)parent).getWorkItem(false);
            List currentParents = wc.getReferences().getReferences(WorkItemEndPoints.PARENT_WORK_ITEM);
            boolean exists = false;
            for (IReference reference : currentParents) {
                if (reference.isItemReference() && ((IItemReference)reference).getReferencedItem().getItemId().equals((Object)parentWorkItem.getItemId())) {
                    exists = true;
                    continue;
                }
                wc.getReferences().remove(reference);
            }
            if (!exists) {
                IReference reference;
                reference = WorkItemLinkTypes.createWorkItemReference((IWorkItem)parentWorkItem);
                wc.getReferences().add(WorkItemEndPoints.PARENT_WORK_ITEM, reference);
            }
        }
        this.fIsPrimaryItem = !this.isAuxiliaryPlanItem();
    }

    @Override
    public ResolvedIterationPlan getPlan() {
        return (ResolvedIterationPlan)super.getPlan();
    }

    public Duration getDeepDuration() {
        long duration = this.calculateDeepDuration();
        if (CALCULATED_DURATION_UNSPECIFIED == duration) {
            return Duration.UNSPECIFIED;
        }
        return new Duration(duration);
    }

    public void addDependentItem(IterationPlanItem item) {
        if (this.fDependentItems.contains(item)) {
            return;
        }
        this.fDependentItems.add(item);
        item.addDependsOnItem(this);
    }

    public PlanItem[] getDependentItems() {
        return this.fDependentItems.toArray(new PlanItem[0]);
    }

    public PlanItem[] getDependsOnItems() {
        return this.fDependsOnItems.toArray(new PlanItem[0]);
    }

    public void addDependsOnItem(IterationPlanItem item) {
        if (this.fDependsOnItems.contains(item)) {
            return;
        }
        this.fDependsOnItems.add(item);
        item.addDependentItem(this);
    }

    public IterationPlanItem getTaskGroupRoot() {
        PlanElement parentElement = this.getParent();
        return parentElement instanceof IterationPlanItem ? ((IterationPlanItem)parentElement).getTaskGroupRoot() : this;
    }

    public void setProgressInfo(IQueryableProgressInformation progress) {
        this.fProgressInfo = progress;
    }

    public IQueryableProgressInformation getProgressInfo() {
        return this.fProgressInfo;
    }

    @Override
    public ItemList<IIteration> getRelatedIterations() {
        IIteration currentTarget = this.getTarget();
        if (currentTarget == null) {
            currentTarget = this.getPlan().getInterval();
        }
        return this.fPlan.getRelatedIterations(currentTarget.getDevelopmentLine());
    }

    @Override
    protected Map<String, IPlanningAttributeIdentifier> getRelevantAttributes() {
        return ATTRIBUTE_MAP;
    }

    @Override
    public boolean canHaveChildren() {
        return true;
    }

    @Override
    public boolean isAuxiliaryPlanItem() {
        return !this.getPlan().isCoreItem(this);
    }

    @Override
    public boolean isPrimaryPlanItem() {
        return this.fIsPrimaryItem;
    }

    void updatePrimaryItemState(PlanDeltaBuilder deltaBuilder) {
        if (this.fIsPrimaryItem && this.isAuxiliaryPlanItem()) {
            this.fIsPrimaryItem = false;
            deltaBuilder.changed(this, PRIMARY_ITEM, true, false);
        }
    }

    void updatePrimaryItemState() {
        this.fIsPrimaryItem = !this.isAuxiliaryPlanItem() || this.fIsPrimaryItem && this.isDirty();
    }

    @Override
    public boolean isProgressPlanItem() {
        return this.fProgressInfo != null;
    }

    @Override
    public boolean isTopLevelPlanItem() {
        return this.getPlan().isTopLevelItem(this);
    }

    @Override
    public void moveTo(PlanElement newParent) {
        super.moveTo(newParent);
        final IWorkItemWorkingCopyManager manager = this.getPlan().getWorkingCopyManager(false);
        WorkItemWorkingCopy workingCopy = this.getWorkItemWorkingCopy(false);
        if (workingCopy.isReferencesSet()) {
            this.updateReferences(newParent, manager);
        } else {
            ((WorkItemWorkingCopyImpl)this.getWorkItemWorkingCopy(true)).setDirty(true);
            final LinkResolver resolver = new LinkResolver(this, workingCopy);
            this.getPlan().getResolveService().deferredResolve(resolver, new IDeferredResolveListener<Void>(){

                @Override
                public void resolved(Void result) {
                    if (IterationPlanItem.this.getPlan().isConnected()) {
                        IterationPlanItem.this.updateReferences(IterationPlanItem.this.getParent(), manager);
                    }
                }

                @Override
                public void canceled() {
                }

                @Override
                public void failed(IStatus state) {
                    IterationPlanItem.this.getPlan().addFailedLinkLoad(resolver);
                }
            }, false);
        }
    }

    void updateReferences() {
        if (!this.getPlan().isConnected() || this.getParent() == null) {
            return;
        }
        this.updateReferences(this.getParent(), this.getPlan().getWorkingCopyManager(false));
    }

    private void updateReferences(PlanElement newParent, IWorkItemWorkingCopyManager manager) {
        try {
            List oldReferences;
            manager.beginCompoundWorkItemChange(this.getWorkItemHandle());
            WorkItemWorkingCopy workingCopy = this.getWorkItemWorkingCopy(true);
            IWorkItemReferences references = workingCopy.getReferences();
            IItemReference newReference = null;
            IEndPointDescriptor endPoint = WorkItemEndPoints.PARENT_WORK_ITEM;
            if (newParent instanceof PlanItem) {
                IWorkItem parentWorkItem = ((PlanItem)newParent).getWorkItem(false);
                newReference = WorkItemLinkTypes.createWorkItemReference((IWorkItem)parentWorkItem);
            }
            if ((oldReferences = references.getReferences(endPoint)).size() != 1 || newReference == null || !newReference.sameDetailsAs((IReference)oldReferences.get(0))) {
                references.set(endPoint, (IReference)newReference);
            }
        }
        finally {
            manager.endCompoundWorkItemChange(this.getWorkItemHandle());
        }
    }

    @Override
    protected void doProcessWorkItemChangeEvent(PlanDeltaBuilder builder, WorkItemChangeEvent event) {
        boolean isCoreItem = this.getPlan().isCoreItem(this);
        if (this.getPlan().wasCoreItem(this, event) ^ isCoreItem) {
            builder.changed(this, AUXILIARY_ITEM, isCoreItem, !isCoreItem);
            if (!this.fIsPrimaryItem && isCoreItem) {
                this.fIsPrimaryItem = true;
                builder.changed(this, PRIMARY_ITEM, false, true);
            }
        }
        if (event.affects(IWorkItem.OWNER_PROPERTY)) {
            IterationPlanSequenceManager newSequenceManager;
            ChangeDetails ownerChange = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.OWNER_PROPERTY);
            IContributor oldContributor = this.getContributor(ownerChange.getOldValue());
            IContributor newContributor = this.getContributor(ownerChange.getNewValue());
            builder.changed(this, OWNER, oldContributor, newContributor);
            IterationPlanSequenceManager oldSequenceManager = this.getPlan().getItemSequenceManager((IContributorHandle)oldContributor);
            if (oldSequenceManager != null) {
                oldSequenceManager.itemRemoved(this);
            }
            if ((newSequenceManager = this.getPlan().getItemSequenceManager((IContributorHandle)newContributor)) != null) {
                newSequenceManager.itemAdded(this);
            }
        }
        if (event.affects(IWorkItem.DURATION_PROPERTY) || event.affects(WorkItem.CORRECTED_ESTIMATE_PROPERTY) || event.affects(WorkItem.TIME_SPENT_PROPERTY)) {
            PlanElement subject = this.getParent();
            while (subject instanceof PlanItem) {
                builder.changed(subject, DURATION, ((PlanItem)subject).getDuration(), ((PlanItem)subject).getDuration());
                subject = subject.getParent();
            }
        }
        ResolvedIterationPlan resolvedPlan = this.getPlan();
        if (event.affects("references")) {
            IWorkItemHandle newParent;
            IWorkItemHandle oldParent;
            IWorkItemHandle newParentCandidate;
            IAdaptable change = event.getAttributeChangeDetails("references");
            IWorkItemHandle oldParentCandidate = null;
            if (change != null) {
                ReferencesChangeDetails referenceChange = (ReferencesChangeDetails)change.getAdapter(ReferencesChangeDetails.class);
                if (referenceChange != null) {
                    oldParentCandidate = this.extractParentFromChange(referenceChange.getRemoved());
                }
            } else {
                oldParentCandidate = this.extractParentFromPlanModel();
            }
            if ((newParentCandidate = WorkItems.getParent(this.getWorkItemWorkingCopy(false), null)) != null) {
                PlanElement cycleDetectionSubject = ((ResolvedPlan)resolvedPlan).getPlanItem(newParentCandidate);
                while (cycleDetectionSubject != null) {
                    if (cycleDetectionSubject == this) {
                        PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), "Ignored parent change event to avoid a reference cycle; consider reopening all jazz related editors."));
                        newParentCandidate = null;
                        break;
                    }
                    cycleDetectionSubject = ((PlanElement)cycleDetectionSubject).getParent();
                }
            }
            if (this.isParentChange(oldParent = oldParentCandidate, newParent = newParentCandidate)) {
                if (newParent != null && resolvedPlan.getResolvedWorkItem(newParent) == null) {
                    try {
                        resolvedPlan.resolvePlanItem(newParent, new IDeferredResolveListener<List<Object>>(){

                            @Override
                            public void resolved(List<Object> result) {
                                this.runEventCode();
                            }

                            @Override
                            public void canceled() {
                            }

                            @Override
                            public void failed(IStatus state) {
                                PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), "Resolving the parent item failed."));
                                this.runEventCode();
                            }

                            private void runEventCode() {
                                ResolvedIterationPlan resolvedPlan = IterationPlanItem.this.getPlan();
                                try {
                                    PlanDeltaBuilder builder = resolvedPlan.connectDeltaBuilder();
                                    IterationPlanItem.this.propagateParentChangedEvent(resolvedPlan, oldParent, newParent, builder);
                                }
                                finally {
                                    resolvedPlan.disconnectDeltaBuilder();
                                }
                            }
                        });
                    }
                    catch (MissingFutureExecutorServiceException missingFutureExecutorServiceException) {
                        PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), 4, "No resolver service available.", null));
                    }
                } else {
                    this.propagateParentChangedEvent(this.getPlan(), oldParent, newParent, builder);
                }
            }
        }
    }

    @Override
    protected void doHandleWorkItemBecomesIrrelevant(PlanDeltaBuilder deltaBuilder, WorkItemChangeEvent event) {
        if (this.isDraftItem() || !this.isDirty()) {
            this.getParent().removeChild(this);
        }
        boolean isCoreItem = this.getPlan().isCoreItem(this);
        if (this.getPlan().wasCoreItem(this, event) ^ isCoreItem) {
            deltaBuilder.changed(this, AUXILIARY_ITEM, isCoreItem, !isCoreItem);
        }
    }

    @Override
    protected void handleWriteableStateChanged(boolean isWriteable) {
        ResolvedIterationPlan resolvedPlan;
        this.getPlan().onWriteableStateChange(this, isWriteable);
        if (!isWriteable && (resolvedPlan = this.getPlan()).contains(this.getWorkItemHandle())) {
            PlanDeltaBuilder builder = resolvedPlan.connectDeltaBuilder();
            try {
                this.updatePrimaryItemState(builder);
            }
            finally {
                resolvedPlan.disconnectDeltaBuilder();
            }
        }
    }

    private IWorkItemHandle extractParentFromPlanModel() {
        PlanElement parent = this.getParent();
        if (!(parent instanceof PlanItem)) {
            return null;
        }
        return ((PlanItem)parent).getWorkItemHandle();
    }

    private IWorkItemHandle extractParentFromChange(List<IReference> references) {
        for (IReference reference : references) {
            ILink link = reference.getLink();
            if (link == null || !reference.isItemReference() || WorkItemEndPoints.PARENT_WORK_ITEM != link.getThisEndpointDescriptor(reference)) continue;
            IItemHandle referencedItem = ((IItemReference)reference).getReferencedItem();
            Assert.isTrue((boolean)(referencedItem instanceof IWorkItemHandle));
            return (IWorkItemHandle)referencedItem;
        }
        return null;
    }

    private boolean isParentChange(IWorkItemHandle oldParent, IWorkItemHandle newParent) {
        if (oldParent == newParent) {
            return false;
        }
        if (oldParent != null && newParent == null || oldParent == null && newParent != null) {
            return true;
        }
        return !oldParent.sameItemId((IItemHandle)newParent);
    }

    private void propagateParentChangedEvent(ResolvedPlan plan, IWorkItemHandle oldParentHandle, IWorkItemHandle newParentHandle, PlanDeltaBuilder builder) {
        PlanElement newParentItem;
        PlanItem oldParentItem = oldParentHandle != null ? plan.getPlanItem(oldParentHandle) : null;
        PlanItem planItem = newParentItem = newParentHandle != null ? plan.getPlanItem(newParentHandle) : null;
        if (newParentItem == null) {
            newParentItem = plan;
        }
        if (this.getParent() != newParentItem) {
            this.moveTo(newParentItem);
        }
        builder.changed(this, PARENT, oldParentItem, (Object)newParentItem);
    }

    private long calculateDeepDuration() {
        long result = this.fDuration.isSpecified() ? this.fDuration.longValue() : CALCULATED_DURATION_UNSPECIFIED;
        PlanElement[] planElementArray = this.getChildren();
        int n = planElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            long childDuration;
            PlanElement element = planElementArray[n2];
            if (element instanceof IterationPlanItem && (childDuration = ((IterationPlanItem)element).calculateDeepDuration()) != CALCULATED_DURATION_UNSPECIFIED) {
                result = result != CALCULATED_DURATION_UNSPECIFIED ? (result += childDuration) : childDuration;
            }
            ++n2;
        }
        return result;
    }

    private IContributor getContributor(Object value) {
        if (value instanceof IContributor) {
            IContributor contributor = (IContributor)value;
            this.getPlan().addResolvedOwner(contributor);
            return contributor;
        }
        if (value instanceof IContributorHandle) {
            IContributor contributor = this.getPlan().getResolvedContributor((IContributorHandle)value);
            if (contributor != null) {
                return contributor;
            }
            IItemManager manager = this.getPlan().getTeamRepository().itemManager();
            contributor = (IContributor)manager.getSharedItemIfKnown((IItemHandle)((IContributorHandle)value));
            if (contributor == null) {
                try {
                    contributor = (IContributor)manager.fetchCompleteItem((IItemHandle)((IContributorHandle)value), 0, null);
                }
                catch (TeamRepositoryException e) {
                    PlanningClientPlugin.log(e);
                    Assert.isTrue((boolean)false, (String)"Should not happen");
                }
            }
            this.getPlan().addResolvedOwner(contributor);
            return contributor;
        }
        throw new IllegalArgumentException("Argument must be a contributor or contributor handle");
    }
}

