/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.IterationPlanWizardContext;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.NewIterationPlanData;
import com.ibm.team.apt.internal.client.PlanSaveResult;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.progress.ProgressClient;
import com.ibm.team.apt.internal.client.progress.ProgressScriptEnvironment;
import com.ibm.team.apt.internal.client.util.AssignmentAwareProcessAreaComparator;
import com.ibm.team.apt.internal.client.util.Items;
import com.ibm.team.apt.internal.client.util.IterationClient;
import com.ibm.team.apt.internal.client.util.LRUElementCache;
import com.ibm.team.apt.internal.client.wiki.IWikiPageSafeRunnable;
import com.ibm.team.apt.internal.common.IPlanningCommon;
import com.ibm.team.apt.internal.common.IStore;
import com.ibm.team.apt.internal.common.IterationPlanNoCategoriesException;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.PlanningCommonImpl;
import com.ibm.team.apt.internal.common.ProcessAreaInfo;
import com.ibm.team.apt.internal.common.WorkItemLinkCycleException;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.duration.IQueryableProgressInformation;
import com.ibm.team.apt.internal.common.nucleus.query.BaseIterationPlanRecordQueryModel;
import com.ibm.team.apt.internal.common.nucleus.query.BaseSharedPlanModeQueryModel;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.plantype.ISharedPlanMode;
import com.ibm.team.apt.internal.common.plantype.ISharedPlanModeHandle;
import com.ibm.team.apt.internal.common.plantype.ResolvedPlanMode;
import com.ibm.team.apt.internal.common.process.AttributeDefinitionMassage;
import com.ibm.team.apt.internal.common.process.ConfigurationElementCache;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.EstimateConfiguration;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.IConfigurationElementMassage;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.apt.internal.common.process.PlanTypeNameMassage;
import com.ibm.team.apt.internal.common.process.ProjectAreaBasedMassage;
import com.ibm.team.apt.internal.common.process.StaticConfigurationDataRegistry;
import com.ibm.team.apt.internal.common.rcp.IIterationPlanService;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanProgress2;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanProgressResult2;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanSaveResult;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_PersonalPlan;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_PlannedWorkItems;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_ProcessAreaInfo;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_ResolvedIterationPlanRecord;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_ResolvedWorkItem2;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_WorkItemProgress;
import com.ibm.team.apt.internal.common.scripting.environment.AbstractScriptFeature;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.EstimateOutputFormat;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.ItemQueryResults;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.apt.internal.common.util.Tuple;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.internal.common.service.IProcessService;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.client.DetailedStatus;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.ClientServiceContext;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlanClient
extends EventSource
implements IIterationPlanClient {
    private static final long LONG_EXPIRATION_INTERVAL = 0x6DDD00L;
    private final LRUElementCache<IItemHandle, CacheEntry<EstimateMode>> fEstimateCache = new LRUElementCache(20, 10);
    private final LRUElementCache<IItemHandle, CacheEntry<EstimateOutputFormat>> fEstimateOutputFormatCache = new LRUElementCache(20, 10);
    static final boolean TRACE_FETCH_ITERATION_PLAN;
    private final IClientLibraryContext fContext;
    private IIterationPlanService fService;
    private final IPlanningCommon fPlanningCommonImpl;

    static {
        String value = Platform.getDebugOption((String)"com.ibm.team.apt.client/traceFetchIterationPlan");
        TRACE_FETCH_ITERATION_PLAN = value != null && value.equalsIgnoreCase("true");
    }

    public IterationPlanClient(IClientLibraryContext context) {
        this.fContext = context;
        this.fPlanningCommonImpl = new PlanningCommonImpl((ICommonServiceContext)new ClientServiceContext(context));
        new CacheCleaner(this, this.getItemManager());
        this.fPlanningCommonImpl.getConfigurationElementMassages().add(new ResourceLocationMassage());
        this.fPlanningCommonImpl.getConfigurationElementMassages().add(new AttributeDefinitionMassage((IWorkItemCommon)PlanningClientPlugin.getWorkItemClient(this.getTeamRepository())));
        this.fPlanningCommonImpl.getConfigurationElementMassages().add(new PlanTypeNameMassage());
    }

    public ITeamRepository getTeamRepository() {
        return this.fContext.teamRepository();
    }

    public IItemManager getItemManager() {
        return this.getTeamRepository().itemManager();
    }

    public IQueryService getQueryService() {
        return (IQueryService)this.fContext.getServiceInterface(IQueryService.class);
    }

    public IterationPlanData fetchIterationPlanData(final IIterationPlanRecordHandle handle, IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)9);
        IClientLibraryContext.IServiceRunnable<DTO_ResolvedIterationPlanRecord> runnable = new IClientLibraryContext.IServiceRunnable<DTO_ResolvedIterationPlanRecord>(){

            public DTO_ResolvedIterationPlanRecord run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().fetchResolvedIterationPlan2(handle);
            }
        };
        DTO_ResolvedIterationPlanRecord data = (DTO_ResolvedIterationPlanRecord)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, (IProgressMonitor)progress.newChild(1));
        try {
            this.acquire();
            FutureTask<ProgressScriptEnvironment> future = IterationPlanClient.submit(ProgressScriptEnvironment.getScriptEnvironmentFuture());
            IItemManager manager = this.fContext.teamRepository().itemManager();
            List acceptedItems = manager.applyItemUpdates(Arrays.asList(data.getIterationPlanRecord(), data.getOwner(), data.getIteration(), data.getDevelopmentLine()));
            IIterationPlanRecord plan = (IIterationPlanRecord)acceptedItems.get(0);
            IProcessArea processArea = (IProcessArea)acceptedItems.get(1);
            IIteration iteration = (IIteration)acceptedItems.get(2);
            IDevelopmentLine developmentLine = (IDevelopmentLine)acceptedItems.get(3);
            IProjectArea projectArea = processArea instanceof IProjectArea ? (IProjectArea)processArea : (IProjectArea)manager.fetchCompleteItem((IItemHandle)processArea.getProjectArea(), 0, (IProgressMonitor)progress.newChild(1));
            IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea);
            IAuditableCommonProcess processCommon = auditableClient.getProcess((IProcessAreaHandle)projectArea, (IProgressMonitor)progress.newChild(1));
            String planTypeId = plan.getPlanType();
            IPlanType planType = this.findPlanType(processCommon, planTypeId, (IProgressMonitor)progress.newChild(1));
            ArrayList<ResolvedPlanMode> planModes = new ArrayList<ResolvedPlanMode>();
            IPlanModeDescription[] iPlanModeDescriptionArray = planType.getPlanModes();
            int n = iPlanModeDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlanModeDescription planMode = iPlanModeDescriptionArray[n2];
                planModes.add(new ResolvedPlanMode(projectArea.getProcessDefinition(), plan.getPlanType(), planMode));
                ++n2;
            }
            Iterator iter = data.getSharedPlanModes().iterator();
            while (iter.hasNext()) {
                ISharedPlanMode sharedPlanMode = (ISharedPlanMode)((ISharedPlanMode)iter.next()).getWorkingCopy();
                IPlanModeDescription planMode = (IPlanModeDescription)IPlanModeDescription.FACTORY.create2(sharedPlanMode, (IPlanningCommon)this, processCommon, (IProgressMonitor)progress.newChild(1)).getResult();
                if (planMode == null) continue;
                planModes.add(new ResolvedPlanMode(sharedPlanMode, planMode));
            }
            List<IFilterDescription> allFilters = this.findConfigurationElements(IFilterDescription.class, processCommon, (IProgressMonitor)progress.newChild(1));
            Node iterationHierarchy = Iterations.fetchIterationTree((IIterationHandle)iteration, (IAuditableCommon)auditableClient, (IProgressMonitor)progress.newChild(1));
            IComplexityAttribute complexityAttribute = this.findComplexityAttribute((IProcessAreaHandle)processArea, (IProgressMonitor)progress.newChild(1));
            ItemArrayList categories = new ItemArrayList((Collection)manager.applyItemUpdates(data.getWorkItemCategories()));
            ItemArrayList relatedIntervals = new ItemArrayList((Collection)manager.applyItemUpdates(data.getIterations()));
            ItemArrayList wikiPages = new ItemArrayList((Collection)manager.applyItemUpdates(data.getWikiPages()), CMode.CURRENT_HANDLEONLY);
            IQueryableProgressInformation progressInformation = ProgressClient.convert(data.getProgressInformation(), IterationPlanClient.joinResult(future));
            List processDTOs = data.getProcessAreas();
            ArrayList<ProcessAreaInfo> processAreas = new ArrayList<ProcessAreaInfo>(processDTOs.size());
            for (DTO_ProcessAreaInfo info : processDTOs) {
                ProcessAreaInfo newInfo = new ProcessAreaInfo(info.getProcessArea(), info.getParent(), info.getCategories().size());
                newInfo.addCategories((Collection)info.getCategories());
                processAreas.add(newInfo);
            }
            IterationPlanData iterationPlanData = new IterationPlanData(plan, planType, planModes, allFilters, (Node<IIteration>)iterationHierarchy, complexityAttribute, developmentLine, projectArea, processArea, iteration, (ItemList<ICategory>)categories, (ItemList<IIteration>)relatedIntervals, processAreas, progressInformation, (ItemList<IWikiPage>)wikiPages, data.isCanSavePlan(), data.isCanSavePages(), data.isShowChartPage());
            return iterationPlanData;
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    @Override
    public ResolvedIterationPlan fetchIterationPlan(IIterationPlanRecordHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            ResolvedIterationPlan resolvedIterationPlan = this.fetchIterationPlan(this.fetchIterationPlanData(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 1)), Collections.EMPTY_LIST, Collections.EMPTY_SET, Collections.EMPTY_SET, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return resolvedIterationPlan;
        }
        finally {
            monitor.done();
        }
    }

    public ResolvedIterationPlan fetchIterationPlan(final IterationPlanData data, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, Collection<IPlanningAttribute<?, ?>> customAttributes, Collection<PlanCheck> planChecks, IProgressMonitor monitor) throws TeamRepositoryException, OperationCanceledException {
        DTO_PlannedWorkItems items = (DTO_PlannedWorkItems)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().fetchPlannedWorkItems((IIterationPlanRecordHandle)data.getPlanRecord());
            }
        }, monitor);
        if (data.getCategories().isEmpty()) {
            throw new IterationPlanNoCategoriesException((IIterationPlanRecordHandle)data.getPlanRecord(), data.getPlanRecord().getName());
        }
        try {
            this.acquire();
            IItemManager manager = this.fContext.teamRepository().itemManager();
            List teamMembers = manager.applyItemUpdates(items.getTeamMembers());
            List additionalPlanMembers = manager.applyItemUpdates(items.getAdditionalPlanMembers());
            List otherOwners = manager.applyItemUpdates(items.getOtherOwners());
            List creators = manager.applyItemUpdates(items.getCreators());
            List resolvedWorkItems = items.getWorkItems();
            this.applyWorkItemUpdates(resolvedWorkItems, manager, monitor);
            DTO_ResolvedWorkItem2 cycle = this.checkForParentCycles(resolvedWorkItems);
            if (cycle != null) {
                IWorkItem workItem = cycle.getWorkItem();
                throw new WorkItemLinkCycleException((IWorkItemHandle)workItem, workItem.getId(), workItem.getHTMLSummary().getPlainText());
            }
            IStore store = IStore.FACTORY.createStore((IIterationPlanRecordHandle)data.getPlanRecord(), (IAuditableCommon)PlanningClientPlugin.getAuditableClient((IItemHandle)data.getPlanRecord()), monitor);
            DurationSupport durationSupport = DurationSupport.FACTORY.getInstance((IProcessAreaHandle)data.getProjectArea(), monitor);
            Node<IIteration> contextIterations = this.fetchContextIterations((IIterationPlanRecordHandle)data.getPlanRecord(), monitor);
            ResolvedIterationPlan resolvedIterationPlan = new ResolvedIterationPlan(data.getPlanRecord(), data.getPlanType(), data.getComplexityAttribute(), contextIterations, data.getIterationHierarchy(), data.getDevelopmentLine(), data.getOwner(), data.getCategories(), data.getIteration(), items.getWorkItems(), attributeDescriptors, customAttributes, planChecks, data.getRelatedIterations(), teamMembers, additionalPlanMembers, otherOwners, creators, new HashSet<String>(items.getTopLevelWorkItemTypes()), data.getProcessAreaInfos(), store, durationSupport, data.canSavePlan());
            return resolvedIterationPlan;
        }
        finally {
            this.release();
        }
    }

    private void applyWorkItemUpdates(List<DTO_ResolvedWorkItem2> resolvedWorkItems, IItemManager manager, IProgressMonitor monitor) throws TeamRepositoryException {
        for (DTO_ResolvedWorkItem2 resolvedWorkItem : resolvedWorkItems) {
            IWorkItem updated = (IWorkItem)manager.applyItemUpdates(Collections.singletonList(resolvedWorkItem.getWorkItem())).get(0);
            if (updated != null) {
                resolvedWorkItem.setWorkItem(updated);
                continue;
            }
            IWorkItem fetchedWorkItem = resolvedWorkItem.getWorkItem();
            Set<String> fetchedProperties = Items.setProperties((IItem)fetchedWorkItem);
            IItem currentSharedItem = manager.getSharedItemIfKnown((IItemHandle)fetchedWorkItem);
            Set<String> cachedProperties = Items.setProperties(currentSharedItem);
            HashSet<String> merged = new HashSet<String>(fetchedProperties);
            merged.addAll(cachedProperties);
            resolvedWorkItem.setWorkItem((IWorkItem)manager.fetchPartialItem((IItemHandle)fetchedWorkItem, 1, merged, monitor));
        }
    }

    private DTO_ResolvedWorkItem2 checkForParentCycles(List<DTO_ResolvedWorkItem2> items) {
        ItemHashMap map = new ItemHashMap();
        for (DTO_ResolvedWorkItem2 dto_workItem : items) {
            map.put((IItemHandle)dto_workItem.getWorkItem(), (Object)dto_workItem);
        }
        for (DTO_ResolvedWorkItem2 item : items) {
            if (!this.checkForParentCycles((ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2>)map, item)) continue;
            return item;
        }
        return null;
    }

    private boolean checkForParentCycles(ItemMap<IWorkItemHandle, DTO_ResolvedWorkItem2> items, DTO_ResolvedWorkItem2 item) {
        if (item.getParent() == null) {
            return false;
        }
        HashSet<DTO_ResolvedWorkItem2> visited = new HashSet<DTO_ResolvedWorkItem2>();
        visited.add(item);
        Object parent = (DTO_ResolvedWorkItem2)items.get((IItemHandle)item.getParent());
        while (parent != null) {
            if (visited.contains(parent)) {
                return true;
            }
            IWorkItemHandle parentHandle = parent.getParent();
            parent = parentHandle == null ? null : (DTO_ResolvedWorkItem2)items.get((IItemHandle)parentHandle);
        }
        return false;
    }

    public DTO_ResolvedWorkItem2 fetchResolvedWorkItem(final IWorkItemHandle handle, final ItemProfile<IWorkItem> itemProfile, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        DTO_ResolvedWorkItem2 result = (DTO_ResolvedWorkItem2)this.fContext.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

            public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().fetchResolvedWorkItem(handle, itemProfile.getPropertiesArray());
            }
        }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IItemManager itemManager = this.getTeamRepository().itemManager();
        result.setWorkItem((IWorkItem)itemManager.applyItemUpdatesOrRefresh(Collections.singletonList(result.getWorkItem()), (IProgressMonitor)new SubProgressMonitor(monitor, 1)).get(0));
        return result;
    }

    @Override
    public ResolvedPersonalPlan fetchPersonalPlan(IProjectAreaHandle projectAreaHandle, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, Collection<IPlanningAttribute<?, ?>> customAttributes, Collection<PlanCheck> planChecks, IContributorHandle contributorHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.IterationPlanClient_LOADING_MY_WORK_DATA, 4);
        long start = System.currentTimeMillis();
        if (TRACE_FETCH_ITERATION_PLAN) {
            System.out.println("\n\nEntering IterationPlanClient#fetchPersonalPlan");
            System.out.println("    >> entering client method: " + start);
        }
        DTO_PersonalPlan data = this.getService().fetchPersonalPlan(projectAreaHandle, contributorHandle);
        monitor.worked(3);
        try {
            ResolvedPersonalPlan result;
            start = System.currentTimeMillis();
            this.acquire();
            IItemManager manager = this.fContext.teamRepository().itemManager();
            IContributor owner = (IContributor)manager.applyItemUpdates(Collections.singletonList(data.getOwner())).get(0);
            boolean isMemberOfProjectArea = data.getProjectArea() != null;
            List teamMemberAreas = manager.applyItemUpdates(data.getTeamMemberAreas());
            List developmentLines = manager.applyItemUpdates(data.getDevelopmentLines());
            List categories = manager.applyItemUpdates(data.getCategories());
            List intervals = manager.applyItemUpdates(data.getIterations());
            List relatedPlans = manager.applyItemUpdates(data.getRelatedPlans());
            List creators = manager.applyItemUpdates(data.getCreators());
            List currentWorkItems = manager.applyItemUpdatesOrRefresh(data.getCurrentWorkItems(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            List otherWorkItems = data.getOtherWorkItemHandles();
            DurationSupport support = DurationSupport.FACTORY.getInstance((IProcessAreaHandle)projectAreaHandle, monitor);
            ResolvedPersonalPlan resolvedPersonalPlan = result = new ResolvedPersonalPlan(projectAreaHandle, attributeDescriptors, customAttributes, planChecks, owner, isMemberOfProjectArea, teamMemberAreas, developmentLines, categories, intervals, currentWorkItems, otherWorkItems, creators, relatedPlans, support, new HashSet<String>(data.getTopLevelWorkItemTypes()));
            return resolvedPersonalPlan;
        }
        finally {
            this.release();
            monitor.done();
        }
    }

    public ItemSet<IWorkItem> refreshWorkItems(ItemSet<IWorkItemHandle> changedItems, ItemProfile<IWorkItem> workItemProfile, IProgressMonitor monitor) throws TeamRepositoryException {
        long start = System.currentTimeMillis();
        if (TRACE_FETCH_ITERATION_PLAN) {
            System.out.println("\n\nEntering IterationPlanClient#refreshWorkItems");
            System.out.println("    >> entering client method: " + start);
        }
        try {
            start = System.currentTimeMillis();
            this.acquire();
            IItemManager itemManager = this.fContext.teamRepository().itemManager();
            List<IWorkItemHandle> handleList = Arrays.asList((IWorkItemHandle[])changedItems.toArray((Object[])new IWorkItemHandle[changedItems.size()]));
            List fetchedItems = itemManager.fetchPartialItems(handleList, 1, workItemProfile.getProperties(), monitor);
            if (TRACE_FETCH_ITERATION_PLAN) {
                System.out.println("    >> fetching items: " + (System.currentTimeMillis() - start));
            }
            ItemHashSet result = new ItemHashSet();
            for (Object item : fetchedItems) {
                result.add((Object)((IWorkItem)item));
            }
            ItemHashSet itemHashSet = result;
            return itemHashSet;
        }
        finally {
            this.release();
        }
    }

    private IIterationPlanService getService() {
        if (this.fService != null) {
            return this.fService;
        }
        this.fService = (IIterationPlanService)this.fContext.getServiceInterface(IIterationPlanService.class);
        return this.fService;
    }

    public IterationPlanWizardContext completeAndValidateContext(IterationPlanWizardContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (context.getIterationPlanHandle() != null) {
            IIterationPlanRecord plan = (IIterationPlanRecord)this.fetchItem((IItemHandle)context.getIterationPlanHandle(), monitor, IIterationPlanRecord.OWNER_PROPERTY, IIterationPlanRecord.ITERATION_PROPERTY);
            IIteration iteration = (IIteration)this.fetchItem((IItemHandle)plan.getIteration(), monitor, new String[0]);
            context.setIteration((IIterationHandle)iteration);
            IDevelopmentLine line = (IDevelopmentLine)this.fetchItem((IItemHandle)iteration.getDevelopmentLine(), monitor, new String[0]);
            context.setDevelopmentLineHandle((IDevelopmentLineHandle)line);
            IProcessArea owner = (IProcessArea)this.fetchItem((IItemHandle)plan.getOwner(), monitor, new String[0]);
            context.setTeamMemberArea((IProcessAreaHandle)owner);
            context.setProjectArea((IProjectAreaHandle)((IProjectArea)this.fetchItem((IItemHandle)owner.getProjectArea(), monitor, new String[0])));
            context.setSelectedPlanType(plan.getPlanType());
            context.setName(plan.getName());
            IStore store = IStore.FACTORY.createStore((IIterationPlanRecordHandle)plan, (IAuditableCommon)PlanningClientPlugin.getAuditableClient((IItemHandle)plan), monitor);
            context.setAuxiliaryDataStore(store);
            return context;
        }
        if (context.getTeamMemberArea() != null && context.getIteration() != null) {
            IIteration iteration = (IIteration)this.fetchItem((IItemHandle)context.getIteration(), monitor, new String[0]);
            IDevelopmentLine line = (IDevelopmentLine)this.fetchItem((IItemHandle)iteration.getDevelopmentLine(), monitor, new String[0]);
            context.setDevelopmentLineHandle((IDevelopmentLineHandle)line);
            context.setSelectedPlanType(this.fetchPlanType(context.getTeamMemberArea(), (IIterationHandle)iteration, monitor).getId());
            return context;
        }
        if (context.getIteration() != null) {
            IIteration iteration = (IIteration)this.fetchItem((IItemHandle)context.getIteration(), monitor, new String[0]);
            IDevelopmentLine line = (IDevelopmentLine)this.fetchItem((IItemHandle)iteration.getDevelopmentLine(), monitor, new String[0]);
            context.setDevelopmentLineHandle((IDevelopmentLineHandle)line);
        } else if (context.getDevelopmentLineHandle() != null) {
            IDevelopmentLine line = (IDevelopmentLine)this.fetchItem((IItemHandle)context.getDevelopmentLineHandle(), monitor, new String[0]);
            context.setIteration((IIterationHandle)IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, monitor));
        }
        if (context.getTeamMemberArea() == null && context.getDevelopmentLineHandle() != null) {
            IDevelopmentLine line;
            IDevelopmentLine tl = (IDevelopmentLine)this.fetchItem((IItemHandle)context.getDevelopmentLineHandle(), monitor, new String[0]);
            IProjectArea pa = (IProjectArea)this.fetchItem((IItemHandle)tl.getProjectArea(), monitor, new String[0]);
            IProcessItemService pis = PlanningClientPlugin.getProcessItemService((IItemHandle)pa);
            IContributor contributor = this.getTeamRepository().loggedInContributor();
            IProcessArea[] teamMemberAreas = this.getAssociatedProcessAreas(contributor, pa, monitor);
            IProcessArea candidate = null;
            IProcessArea[] iProcessAreaArray = teamMemberAreas;
            int n = teamMemberAreas.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessArea area = iProcessAreaArray[n2];
                if (area instanceof ITeamArea) {
                    line = pis.getDevelopmentLine(area, monitor);
                    if (context.getDevelopmentLineHandle().sameItemId((IItemHandle)line)) {
                        candidate = area;
                        break;
                    }
                }
                ++n2;
            }
            if (candidate != null) {
                context.setTeamMemberArea((IProcessAreaHandle)candidate);
                context.setProjectArea((IProjectAreaHandle)pa);
            } else {
                List teamAreas = pa.getTeamAreaHierarchy().getTeamAreas();
                if (teamAreas.isEmpty()) {
                    context.setTeamMemberArea((IProcessAreaHandle)pa);
                    context.setProjectArea((IProjectAreaHandle)pa);
                } else {
                    for (ITeamAreaHandle handle : teamAreas) {
                        ITeamArea teamArea = (ITeamArea)this.fetchItem((IItemHandle)handle, monitor, new String[0]);
                        line = pis.getDevelopmentLine((IProcessArea)teamArea, monitor);
                        if (!context.getDevelopmentLineHandle().sameItemId((IItemHandle)line)) continue;
                        context.setTeamMemberArea((IProcessAreaHandle)teamArea);
                        context.setProjectArea((IProjectAreaHandle)pa);
                        break;
                    }
                }
            }
            if (context.getTeamMemberArea() == null) {
                context.setTeamMemberArea((IProcessAreaHandle)pa);
                context.setProjectArea((IProjectAreaHandle)pa);
            }
        }
        if (context.getTeamMemberArea() != null && context.getDevelopmentLineHandle() != null && context.getIteration() != null) {
            context.setSelectedPlanType(this.fetchPlanType(context.getTeamMemberArea(), context.getIteration(), monitor).getId());
            return context;
        }
        if (context.getProjectArea() != null && context.getTeamMemberArea() == null) {
            Object area = this.inferTeamMemberArea(context.getProjectArea(), monitor);
            if (area == null) {
                IProjectArea projectArea = (IProjectArea)this.fetchItem((IItemHandle)context.getProjectArea(), monitor, new String[0]);
                List teamAreas = projectArea.getTeamAreaHierarchy().getTeamAreas();
                area = !teamAreas.isEmpty() ? (IProcessArea)this.fetchItem((IItemHandle)teamAreas.get(0), monitor, new String[0]) : projectArea;
            }
            if (area != null) {
                IDevelopmentLineHandle[] lines;
                IProcessItemService pis = PlanningClientPlugin.getProcessItemService((IItemHandle)area);
                context.setTeamMemberArea((IProcessAreaHandle)area);
                if (area instanceof ITeamArea) {
                    IDevelopmentLine line = pis.getDevelopmentLine(area, monitor);
                    if (line != null) {
                        context.setDevelopmentLineHandle((IDevelopmentLineHandle)line);
                        context.setIteration((IIterationHandle)IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, monitor));
                    }
                } else if (area instanceof IProjectArea && (lines = ((IProjectArea)area).getDevelopmentLines()).length > 0) {
                    IDevelopmentLine line = (IDevelopmentLine)this.fetchItem((IItemHandle)lines[0], monitor, new String[0]);
                    context.setDevelopmentLineHandle((IDevelopmentLineHandle)line);
                    context.setIteration((IIterationHandle)IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, monitor));
                }
            }
        }
        if (context.getTeamMemberArea() != null && context.getDevelopmentLineHandle() != null && context.getIteration() != null) {
            context.setSelectedPlanType(this.fetchPlanType(context.getTeamMemberArea(), context.getIteration(), monitor).getId());
        }
        return context;
    }

    private IProcessArea inferTeamMemberArea(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        IProjectArea projectArea = (IProjectArea)this.getItemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(1));
        IContributor contributor = this.getTeamRepository().loggedInContributor();
        IProcessArea[] teamMemberAreas = this.getAssociatedProcessAreas(contributor, projectArea, (IProgressMonitor)progress.newChild(1));
        if (teamMemberAreas.length == 0) {
            return null;
        }
        AssignmentAwareProcessAreaComparator comparator = AssignmentAwareProcessAreaComparator.newInstance((IContributorHandle)contributor, (IProjectAreaHandle)projectArea, false, (IProgressMonitor)progress.newChild(1));
        Arrays.sort(teamMemberAreas, comparator);
        return teamMemberAreas[0];
    }

    private <T> T fetchItem(IItemHandle handle, IProgressMonitor monitor, String ... properties) throws TeamRepositoryException {
        if (properties.length == 0) {
            return (T)this.getItemManager().fetchCompleteItem(handle, 0, monitor);
        }
        return (T)this.getItemManager().fetchPartialItem(handle, 0, Arrays.asList(properties), monitor);
    }

    public NewIterationPlanData fetchNewIterationPlanData(IterationPlanWizardContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessAreaHandle teamMemberArea = context.getTeamMemberArea();
        if (teamMemberArea == null) {
            return this.fetchNewIterationPlanData(context.getProjectArea(), teamMemberArea, monitor);
        }
        IProcessArea pa = (IProcessArea)this.fetchItem((IItemHandle)teamMemberArea, monitor, new String[0]);
        return this.fetchNewIterationPlanData(pa.getProjectArea(), teamMemberArea, monitor);
    }

    public NewIterationPlanData fetchEditIterationPlanData(IProjectAreaHandle projectAreaHandle, IProcessAreaHandle defaultTeamMemberArea, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchNewIterationPlanData(projectAreaHandle, defaultTeamMemberArea, monitor);
    }

    private NewIterationPlanData fetchNewIterationPlanData(final IProjectAreaHandle projectAreaHandle, final IProcessAreaHandle teamMemberAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)projectAreaHandle);
        Assert.isNotNull((Object)teamMemberAreaHandle);
        IClientLibraryContext.IServiceRunnable<NewIterationPlanData> runnable = new IClientLibraryContext.IServiceRunnable<NewIterationPlanData>(){

            public NewIterationPlanData run(IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    List teamAreas;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.IterationPlanClient_FETCHING_ITERATION_PLAN_DATA, (int)7);
                    IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle).itemManager();
                    IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectAreaHandle);
                    IAuditableCommonProcess processCommon = auditableClient.getProcess((IProcessAreaHandle)projectAreaHandle, (IProgressMonitor)progress.newChild(1));
                    List<IPlanType> planTypes = IterationPlanClient.this.findPlanTypes(processCommon, (IProgressMonitor)progress.newChild(1));
                    IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(1));
                    IDevelopmentLine devLine = null;
                    if (teamMemberAreaHandle instanceof ITeamAreaHandle) {
                        ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
                        ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
                        ITeamAreaHandle current = (ITeamAreaHandle)teamMemberAreaHandle;
                        do {
                            teamAreaHandles.add(current);
                        } while ((current = hierarchy.getParent(current)) != null);
                        Collections.reverse(teamAreaHandles);
                        teamAreas = itemManager.fetchCompleteItems(teamAreaHandles, 0, (IProgressMonitor)progress.newChild(1));
                        devLine = auditableClient.getDevelopmentLine((ITeamAreaHandle)teamMemberAreaHandle, (IProgressMonitor)progress.newChild(1));
                    } else {
                        teamAreas = new ArrayList();
                        if (projectArea.getDevelopmentLines().length > 0) {
                            devLine = (IDevelopmentLine)IterationPlanClient.this.fetchItem((IItemHandle)projectArea.getDevelopmentLines()[0], monitor, new String[0]);
                        }
                    }
                    IIteration iteration = null;
                    if (devLine != null) {
                        iteration = Iterations.getCurrentPlanLeafIteration(devLine, (IAuditableCommon)auditableClient, (IProgressMonitor)progress.newChild(1));
                    }
                    boolean canSave = IterationPlanClient.this.checkPermission(teamMemberAreaHandle, "com.ibm.team.apt.server.saveIterationPlan", "modify/plan", (IProgressMonitor)progress.newChild(1));
                    NewIterationPlanData newIterationPlanData = new NewIterationPlanData(planTypes, projectArea, teamAreas, devLine, iteration, canSave);
                    return newIterationPlanData;
                }
                finally {
                    monitor.done();
                }
            }
        };
        return (NewIterationPlanData)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    public ITeamArea[] getAssociatedTeamAreas(IContributor contributor, IProjectArea area, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessService processService = (IProcessService)this.fContext.getServiceInterface(IProcessService.class);
        return processService.findTeamAreas(contributor, (IProjectAreaHandle)area, new String[]{IItem.ITEM_ID_PROPERTY, IItem.MODIFIED_PROPERTY, IItem.MODIFIED_BY_PROPERTY});
    }

    public IProcessArea[] getAssociatedProcessAreas(IContributor contributor, IProjectArea area, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessService processService = (IProcessService)this.fContext.getServiceInterface(IProcessService.class);
        return processService.findProcessAreas(contributor, (IProjectAreaHandle)area, new String[]{IItem.ITEM_ID_PROPERTY, IItem.MODIFIED_PROPERTY, IItem.MODIFIED_BY_PROPERTY});
    }

    public IterationPlanSaveResult create(IIterationPlanRecord plan, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.create(plan, null, null, monitor);
    }

    public IterationPlanSaveResult create(IIterationPlanRecord plan, IStore auxiliaryData, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.create(plan, auxiliaryData, null, monitor);
    }

    public IterationPlanSaveResult create(IIterationPlanRecord plan, XMLString planNotes, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.create(plan, null, planNotes, monitor);
    }

    public IterationPlanSaveResult create(IIterationPlanRecord plan, IStore auxiliaryData, XMLString planNotes, IProgressMonitor monitor) throws TeamRepositoryException {
        IWikiPage overviewPage = (IWikiPage)IWikiPage.ITEM_TYPE.createItem();
        overviewPage.setName("");
        overviewPage.setWikiID("overview");
        overviewPage.setCreator((IContributorHandle)this.getTeamRepository().loggedInContributor());
        overviewPage.setOwner((IItemHandle)plan);
        String xmlText = planNotes != null ? planNotes.getXMLText() : "";
        overviewPage.setContent(this.getTeamRepository().contentManager().storeContent("text/plain", xmlText, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        return this.save(monitor, plan.getOwner(), plan, auxiliaryData, overviewPage);
    }

    public IterationPlanSaveResult save(IIterationPlanRecord plan, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.save(monitor, plan.getOwner(), plan, null, new IWikiPage[0]);
    }

    public IterationPlanSaveResult save(IIterationPlanRecord plan, IStore auxiliaryData, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.save(monitor, plan.getOwner(), plan, auxiliaryData, new IWikiPage[0]);
    }

    private IterationPlanSaveResult save(IProgressMonitor monitor, final IProcessAreaHandle teamMemberArea, final IIterationPlanRecord plan, final IStore auxiliaryData, final IWikiPage ... pages) throws TeamRepositoryException {
        return (IterationPlanSaveResult)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IterationPlanSaveResult>(){

            public IterationPlanSaveResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                final DTO_IterationPlanSaveResult[] result = new DTO_IterationPlanSaveResult[1];
                IProcessClientService process = (IProcessClientService)IterationPlanClient.this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                IOperationReport report = process.execute(new ProcessRunnable("com.ibm.team.apt.server.saveIterationPlan"){

                    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                        if (auxiliaryData != null) {
                            try {
                                String value = ((IStore.Store)auxiliaryData).getRoot().asXMLString();
                                IContent content = IterationPlanClient.this.getTeamRepository().contentManager().storeContent("text/plain", value, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                plan.setAuxiliaryData(content);
                            }
                            catch (IOException e) {
                                throw new TeamRepositoryException((Throwable)e);
                            }
                        }
                        result[0] = IterationPlanClient.this.getService().save(teamMemberArea, plan, pages);
                        return null;
                    }
                }, Messages.IterationPlanClient_SAVE_ITERATION_PLAN, monitor);
                IIterationPlanRecord savedPlan = null;
                if (plan != null) {
                    savedPlan = (IIterationPlanRecord)IterationPlanClient.this.getTeamRepository().itemManager().applyItemUpdates(Arrays.asList(result[0].getIterationPlanRecord())).get(0);
                }
                return new IterationPlanSaveResult(savedPlan, result[0].getWikiPages(), result[0].getExceptionCause(), (IDetailedStatus)new DetailedStatus(Status.OK_STATUS, report));
            }
        }, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public IterationPlanSaveResult save(boolean canSavePlan, IIterationPlanRecord record, IWorkItemWorkingCopyManager manager, WorkItemWorkingCopy[] workingCopies, IStore store, IWikiPageSafeRunnable[] resolvedPages, IProgressMonitor monitor) throws MultiStaleDataException, TeamRepositoryException, IOException {
        saveWorkingCopies = workingCopies.length != 0;
        saveAuxiliaryData = store != null;
        savePages = resolvedPages != null && resolvedPages.length != 0;
        monitor.beginTask("", (saveWorkingCopies != false ? 1 : 0) + (saveAuxiliaryData != false ? 2 : 0));
        status = new DetailedStatus(0, PlanningClientPlugin.getPluginId(), 0, "", null);
        if (saveWorkingCopies) {
            status = manager.save(workingCopies, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (saveAuxiliaryData || savePages) {
            block10: {
                workingCopy = null;
                if (saveAuxiliaryData) {
                    workingCopy = (IIterationPlanRecord)record.getWorkingCopy();
                    value = ((IStore.Store)store).getRoot().asXMLString();
                    content = this.getTeamRepository().contentManager().storeContent("text/plain", value, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    workingCopy.setAuxiliaryData(content);
                }
                wikiPages = new ArrayList<IWikiPage>(resolvedPages.length);
                var17_15 = resolvedPages;
                var16_17 = resolvedPages.length;
                var15_20 = 0;
                while (var15_20 < var16_17) {
                    page = var17_15[var15_20];
                    wikiPages.add(page.preSave());
                    ++var15_20;
                }
                result = null;
                try {
                    result = this.save(monitor, record.getOwner(), canSavePlan != false && workingCopy != null ? workingCopy : null, null, wikiPages.toArray(new IWikiPage[resolvedPages.length]));
                    monitor.worked(1);
                    iter = result.getWikiPages().iterator();
                    var19_23 = resolvedPages;
                    var18_25 = resolvedPages.length;
                    var17_16 = 0;
                    while (var17_16 < var18_25) {
                        resolvedPage = var19_23[var17_16];
                        resolvedPage.postSave(iter.next());
                        ++var17_16;
                    }
                    if (!canSavePlan || workingCopy == null) {
                        result = new IterationPlanSaveResult(workingCopy != null ? workingCopy : record, result.getWikiPages(), result.getExceptionCause(), result.getStatus());
                    }
                    return result;
                }
                catch (TeamRepositoryException e) {
                    if (e.getData() == null || !(e.getData() instanceof IItemHandle)) break block10;
                    handle = (IItemHandle)e.getData();
                    var20_27 = resolvedPages;
                    var19_24 = resolvedPages.length;
                    var18_26 = 0;
                    ** while (var18_26 < var19_24)
                }
lbl-1000:
                // 1 sources

                {
                    page = var20_27[var18_26];
                    if (page.getWikiPage().getItemId().equals((Object)handle.getItemId())) {
                        page.handleException(e);
                    }
                    ++var18_26;
                    continue;
                }
            }
            throw e;
        }
        return new IterationPlanSaveResult(record, null, null, (IDetailedStatus)status);
    }

    public PlanSaveResult save(final IWorkItemWorkingCopyManager manager, final WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws MultiStaleDataException, TeamRepositoryException {
        return (PlanSaveResult)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<PlanSaveResult>(){

            public PlanSaveResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask("", workingCopies.length);
                DetailedStatus status = new DetailedStatus(0, PlanningClientPlugin.getPluginId(), 0, "", null);
                status = manager.save(workingCopies, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return new PlanSaveResult((IDetailedStatus)status);
            }
        }, monitor);
    }

    public IOperationReport delete(final IIterationPlanRecordHandle plan) throws TeamRepositoryException {
        IProcessClientService process = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
        IOperationReport report = process.execute(new ProcessRunnable("com.ibm.team.apt.server.deleteIterationPlan"){

            public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                IterationPlanClient.this.getService().delete(plan);
                IterationPlanClient.this.getItemManager().applyItemDeletes(Arrays.asList(plan));
                return null;
            }
        }, Messages.IterationPlanClient_DELETE_ITERATION_PLAN, null);
        return report;
    }

    public IterationPlanSaveResult renameAttachedPage(final IIterationPlanRecord plan, final IWikiPageSafeRunnable page, final String name, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        return (IterationPlanSaveResult)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IterationPlanSaveResult>(){

            public IterationPlanSaveResult run(IProgressMonitor monitor) throws TeamRepositoryException {
                IterationPlanSaveResult result;
                page.getWikiPage().setName(name);
                try {
                    result = IterationPlanClient.this.save(false, plan, null, new WorkItemWorkingCopy[0], null, new IWikiPageSafeRunnable[]{page}, monitor);
                }
                catch (IOException e) {
                    throw new TeamRepositoryException((Throwable)e);
                }
                return result;
            }
        }, monitor);
    }

    public void deleteAttachedPage(final IWikiPageHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Void>(){

            public Void run(IProgressMonitor monitor) throws TeamRepositoryException {
                IterationPlanClient.this.getService().deleteAttachedPage(handle);
                return null;
            }
        }, monitor);
    }

    public boolean checkPermission(final IProcessAreaHandle processAreaHandle, final String operationId, final String action, IProgressMonitor monitor) throws TeamRepositoryException {
        return (Boolean)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<Boolean>(){

            public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.getService().checkPermission(processAreaHandle, operationId, action);
            }
        }, monitor);
    }

    public List<IIterationPlanRecordHandle> fetchIterationPlanRecords(List<? extends IProcessAreaHandle> owners, List<? extends IIterationHandle> iterations, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isLegal((!owners.isEmpty() ? 1 : 0) != 0);
        Assert.isLegal((!iterations.isEmpty() ? 1 : 0) != 0);
        final Object[] params = new Object[iterations.size() + owners.size()];
        BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel model = BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel.ROOT;
        final IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        IItemHandleInputArg[] iterationArgHandles = new IItemHandleInputArg[iterations.size()];
        ListIterator<? extends IIterationHandle> iter1 = iterations.listIterator();
        while (iter1.hasNext()) {
            int index = iter1.nextIndex();
            iterationArgHandles[index] = query.newItemHandleArg();
            params[index] = iter1.next();
        }
        IPredicate filter = model.iteration()._in(iterationArgHandles);
        int offset = iterations.size();
        IItemHandleInputArg[] teamAreaArgHandles = new IItemHandleInputArg[owners.size()];
        ListIterator<? extends IProcessAreaHandle> iter2 = owners.listIterator();
        while (iter2.hasNext()) {
            int index = iter2.nextIndex();
            teamAreaArgHandles[index] = query.newItemHandleArg();
            params[offset + index] = iter2.next();
        }
        filter = filter._and(model.owner()._in(teamAreaArgHandles));
        query.filter(filter);
        query.orderByAsc((IField)model.iteration().internalEndDate());
        query.orderByAsc((IField)model.name());
        return (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<List<IIterationPlanRecordHandle>>(){

            public List<IIterationPlanRecordHandle> run(IProgressMonitor monitor) throws TeamRepositoryException {
                return new ItemQueryResults(IterationPlanClient.this.getQueryService(), query, params).getAllItems();
            }
        }, monitor);
    }

    public List<IIterationPlanRecordHandle> fetchIterationPlanRecords(List<? extends IProcessAreaHandle> owners, IIterationHandle iteration, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchIterationPlanRecords(owners, Collections.singletonList(iteration), monitor);
    }

    public List<IIterationPlanRecordHandle> fetchAllIterationPlans(ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            List handles;
            this.acquire();
            BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel iprModel = BaseIterationPlanRecordQueryModel.IterationPlanRecordQueryModel.ROOT;
            IItemQuery iprQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)iprModel);
            ItemQueryResults resultIterator = new ItemQueryResults(this.getQueryService(), iprQuery, new Object[0]);
            List list = handles = resultIterator.getAllItems();
            return list;
        }
        finally {
            this.release();
        }
    }

    @Override
    public List<String> fetchTopLevelWorkItemTypes(final IProcessAreaHandle processAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)processAreaHandle);
        IClientLibraryContext.IServiceRunnable<List<String>> runnable = new IClientLibraryContext.IServiceRunnable<List<String>>(){

            public List<String> run(IProgressMonitor monitor) throws TeamRepositoryException {
                ArrayList<String> result = new ArrayList<String>(5);
                IAuditableCommonProcess process = PlanningClientPlugin.getAuditableClient((IItemHandle)processAreaHandle).getProcess(processAreaHandle, monitor);
                IProcessConfigurationData data = process.findProcessConfiguration("com.ibm.team.apt.configuration.topLevelPlanWorkItemBinding", (IProgressMonitor)new NullProgressMonitor());
                if (data != null) {
                    IProcessConfigurationElement[] bindings;
                    IProcessConfigurationElement[] iProcessConfigurationElementArray = bindings = data.getElements();
                    int n = bindings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcessConfigurationElement binding = iProcessConfigurationElementArray[n2];
                        result.add(binding.getAttribute("workitemType"));
                        ++n2;
                    }
                }
                return Collections.unmodifiableList(result);
            }
        };
        return (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public EstimateMode fetchEstimationMode(IProcessAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (EstimateMode)((Object)this.updateEstimateConfiguration(handle, monitor).getElement1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EstimateMode findCachedEstimationMode(IProcessAreaHandle handle) {
        Assert.isNotNull((Object)handle);
        IItemHandle key = IterationPlanClient.key(handle);
        LRUElementCache<IItemHandle, CacheEntry<EstimateMode>> lRUElementCache = this.fEstimateCache;
        synchronized (lRUElementCache) {
            CacheEntry entry = (CacheEntry)this.fEstimateCache.get(key);
            if (entry != null) {
                if (entry.isValid(System.currentTimeMillis(), key.getStateId())) {
                    return (EstimateMode)((Object)entry.getElement());
                }
                this.fEstimateCache.remove(key);
            }
        }
        return null;
    }

    public EstimateOutputFormat fetchEstimateOutputFormatCached(IProcessAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        EstimateOutputFormat result = this.findCachedEstimationOutputFormat(handle);
        if (result != null) {
            return result;
        }
        return (EstimateOutputFormat)this.updateEstimateConfiguration(handle, monitor).getElement2();
    }

    public EstimateOutputFormat fetchEstimateOutputFormat(IProcessAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (EstimateOutputFormat)this.updateEstimateConfiguration(handle, monitor).getElement2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EstimateOutputFormat findCachedEstimationOutputFormat(IProcessAreaHandle handle) {
        Assert.isNotNull((Object)handle);
        IItemHandle key = IterationPlanClient.key(handle);
        LRUElementCache<IItemHandle, CacheEntry<EstimateOutputFormat>> lRUElementCache = this.fEstimateOutputFormatCache;
        synchronized (lRUElementCache) {
            CacheEntry entry = (CacheEntry)this.fEstimateOutputFormatCache.get(key);
            if (entry != null) {
                if (entry.isValid(System.currentTimeMillis(), key.getStateId())) {
                    return (EstimateOutputFormat)entry.getElement();
                }
                this.fEstimateOutputFormatCache.remove(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<EstimateMode, EstimateOutputFormat> updateEstimateConfiguration(final IProcessAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)handle);
        IClientLibraryContext.IServiceRunnable<IProcessConfigurationData> runnable = new IClientLibraryContext.IServiceRunnable<IProcessConfigurationData>(){

            public IProcessConfigurationData run(IProgressMonitor monitor) throws TeamRepositoryException {
                IAuditableCommonProcess process = PlanningClientPlugin.getAuditableClient((IItemHandle)handle).getProcess(handle, monitor);
                return process.findProcessConfiguration("com.ibm.team.apt.configuration.workItemProgressMode", (IProgressMonitor)new NullProgressMonitor());
            }
        };
        IProcessConfigurationData data = (IProcessConfigurationData)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
        EstimateConfiguration config = new EstimateConfiguration(data);
        EstimateMode estimateMode = EstimateMode.TimeSpent;
        try {
            estimateMode = Enum.valueOf(EstimateMode.class, config.getProgressMode());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        EstimateOutputFormat estimateOutputFormat = config.getEstimateOutputFormat();
        IItemHandle key = IterationPlanClient.key(handle);
        if (key.getStateId() == null) {
            IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
            key = manager.fetchPartialItem((IItemHandle)handle, 0, Collections.emptyList(), monitor);
        }
        LRUElementCache<IItemHandle, CacheEntry<EstimateMode>> lRUElementCache = this.fEstimateCache;
        synchronized (lRUElementCache) {
            this.fEstimateCache.put(key, new CacheEntry<EstimateMode>(System.currentTimeMillis(), key.getStateId(), estimateMode));
        }
        lRUElementCache = this.fEstimateOutputFormatCache;
        synchronized (lRUElementCache) {
            this.fEstimateOutputFormatCache.put(key, new CacheEntry<EstimateOutputFormat>(System.currentTimeMillis(), key.getStateId(), estimateOutputFormat));
        }
        return new Tuple((Object)estimateMode, (Object)estimateOutputFormat);
    }

    private static final IItemHandle key(IProcessAreaHandle handle) {
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
        IItem item = manager.getSharedItemIfKnown((IItemHandle)handle);
        if (item != null) {
            return item.getStateHandle();
        }
        return handle;
    }

    public IComplexityAttribute findComplexityAttribute(final IProcessAreaHandle processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<IComplexityAttribute> runnable = new IClientLibraryContext.IServiceRunnable<IComplexityAttribute>(){

            public IComplexityAttribute run(IProgressMonitor monitor) throws TeamRepositoryException {
                return IterationPlanClient.this.fPlanningCommonImpl.findComplexityAttribute(processArea, monitor);
            }
        };
        return (IComplexityAttribute)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public IQueryableProgressInformation fetchPlanProgress(IIterationPlanRecordHandle plan, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IQueryableProgressInformation> list = this.fetchPlanProgress(Arrays.asList(plan), monitor);
        return !list.isEmpty() ? list.get(0) : null;
    }

    @Override
    public List<IQueryableProgressInformation> fetchPlanProgress(final List<? extends IIterationPlanRecordHandle> plans, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<List<IQueryableProgressInformation>> runnable = new IClientLibraryContext.IServiceRunnable<List<IQueryableProgressInformation>>(){

            public List<IQueryableProgressInformation> run(IProgressMonitor monitor) throws TeamRepositoryException {
                int size = plans.size();
                if (size == 0) {
                    return Collections.EMPTY_LIST;
                }
                FutureTask future = IterationPlanClient.submit(ProgressScriptEnvironment.getScriptEnvironmentFuture());
                if (size == 1) {
                    DTO_IterationPlanProgressResult2 planProgress2 = IterationPlanClient.this.getService().fetchPlanProgress2((IIterationPlanRecordHandle)plans.get(0), new IIterationPlanRecordHandle[0]);
                    return Arrays.asList(ProgressClient.convert((DTO_IterationPlanProgress2)planProgress2.getPlanProgress().iterator().next(), (ProgressScriptEnvironment)((Object)IterationPlanClient.joinResult(future))));
                }
                DTO_IterationPlanProgressResult2 planProgress2 = IterationPlanClient.this.getService().fetchPlanProgress2((IIterationPlanRecordHandle)plans.get(0), plans.subList(1, size).toArray(new IIterationPlanRecordHandle[size - 1]));
                ArrayList<IQueryableProgressInformation> result = new ArrayList<IQueryableProgressInformation>(size);
                ListIterator iter = planProgress2.getPlanProgress().listIterator();
                while (iter.hasNext()) {
                    result.add(ProgressClient.convert((DTO_IterationPlanProgress2)iter.next(), (ProgressScriptEnvironment)((Object)IterationPlanClient.joinResult(future))));
                }
                return result;
            }
        };
        return (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    @Override
    public IQueryableProgressInformation fetchWorkItemProgress(final IWorkItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IQueryableProgressInformation)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IQueryableProgressInformation>(){

            public IQueryableProgressInformation run(IProgressMonitor monitor) throws TeamRepositoryException {
                FutureTask future = IterationPlanClient.submit(ProgressScriptEnvironment.getScriptEnvironmentFuture());
                DTO_WorkItemProgress dto = IterationPlanClient.this.getService().fetchWorkItemProgress(handle);
                return ProgressClient.convert(dto, (ProgressScriptEnvironment)((Object)IterationPlanClient.joinResult(future)));
            }
        }, monitor);
    }

    public List<IConfigurationElementMassage<?>> getConfigurationElementMassages() {
        return this.fPlanningCommonImpl.getConfigurationElementMassages();
    }

    public ConfigurationElementCache getConfigurationElementCacheIfExists(IProjectAreaHandle projectArea) {
        return this.fPlanningCommonImpl.getConfigurationElementCacheIfExists(projectArea);
    }

    public ConfigurationElementCache getConfigurationElementCache(IProjectAreaHandle projectArea) {
        return this.fPlanningCommonImpl.getConfigurationElementCache(projectArea);
    }

    public IPlanType findPlanType(IAuditableCommonProcess process, String planTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPlanningCommonImpl.findPlanType(process, planTypeId, monitor);
    }

    public List<IPlanType> findPlanTypes(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPlanningCommonImpl.findPlanTypes(process, monitor);
    }

    public <T extends IConfigurationElement> T findConfigurationElement(Class<T> type, String identifier, IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        return (T)this.fPlanningCommonImpl.findConfigurationElement(type, identifier, process, monitor);
    }

    public <T extends IConfigurationElement> List<T> findConfigurationElements(Class<T> type, IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPlanningCommonImpl.findConfigurationElements(type, process, monitor);
    }

    public List<AbstractScriptFeature> getAvailableScripts(IAuditableCommonProcess process, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPlanningCommonImpl.getAvailableScripts(process, monitor);
    }

    public Node<IIteration> fetchContextIterations(IIterationPlanRecordHandle planHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPlanningCommonImpl.fetchContextIterations(planHandle, monitor);
    }

    public IPlanType fetchPlanType(IProcessAreaHandle processAreaHandle, IIterationHandle iterationHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPlanningCommonImpl.fetchPlanType(processAreaHandle, iterationHandle, monitor);
    }

    public IItemQueryPage fetchRelatedPlans(IIterationPlanRecordHandle planHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fPlanningCommonImpl.fetchRelatedPlans(planHandle, monitor);
    }

    public List<ISharedPlanModeHandle> fetchSharedPlanModes(final IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<List<ISharedPlanModeHandle>> runnable = new IClientLibraryContext.IServiceRunnable<List<ISharedPlanModeHandle>>(){

            public List<ISharedPlanModeHandle> run(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                IProjectArea projectArea = (IProjectArea)IterationPlanClient.this.getItemManager().fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(1));
                List teamAreas = IterationPlanClient.this.getItemManager().fetchCompleteItems(projectArea.getTeamAreas(), 0, (IProgressMonitor)progress.newChild(1));
                BaseSharedPlanModeQueryModel.SharedPlanModeQueryModel model = BaseSharedPlanModeQueryModel.SharedPlanModeQueryModel.ROOT;
                IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
                IItemHandleInputArg[] list = new IItemHandleInputArg[teamAreas.size() + 1];
                Object[] parameters = new Object[teamAreas.size() + 1];
                list[0] = query.newItemHandleArg();
                parameters[0] = projectAreaHandle;
                ListIterator iter = teamAreas.listIterator();
                while (iter.hasNext()) {
                    int index = iter.nextIndex() + 1;
                    list[index] = query.newItemHandleArg();
                    parameters[index] = iter.next();
                }
                query.filter(model.owner()._in(list));
                ItemQueryResults results = new ItemQueryResults((IQueryService)IterationPlanClient.this.fContext.getServiceInterface(IQueryService.class), query, parameters);
                return results.getAllItems();
            }
        };
        return (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    public List<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>> fetchSharedPlanModeDescriptions(final IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<List<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>>> runnable = new IClientLibraryContext.IServiceRunnable<List<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>>>(){

            public List<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>> run(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                IAuditableCommonProcess process = PlanningClientPlugin.getAuditableClient((IItemHandle)projectArea).getProcess((IProcessAreaHandle)projectArea, (IProgressMonitor)progress.newChild(1));
                List<ISharedPlanModeHandle> handles = IterationPlanClient.this.fetchSharedPlanModes(projectArea, (IProgressMonitor)progress.newChild(1));
                List sharedPlanModes = IterationPlanClient.this.getItemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)progress.newChild(1));
                progress.setWorkRemaining(sharedPlanModes.size());
                ArrayList<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>> result = new ArrayList<IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>>();
                for (ISharedPlanMode sharedPlanMode : sharedPlanModes) {
                    result.add((IPlanModeDescription.ConfigurationElementCreationReport<IPlanModeDescription>)IPlanModeDescription.FACTORY.create2(sharedPlanMode, (IPlanningCommon)IterationPlanClient.this, process, (IProgressMonitor)progress.newChild(1)));
                }
                return result;
            }
        };
        return (List)this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)runnable, monitor);
    }

    public List<ISharedPlanMode> saveSharedPlanModeDescription(final List<ISharedPlanMode> planModes, IProgressMonitor monitor) throws TeamRepositoryException {
        final ArrayList<ISharedPlanMode> result = new ArrayList<ISharedPlanMode>(planModes.size());
        PlanningClientPlugin.getProcessItemService(this.getTeamRepository()).execute(new ProcessRunnable(){

            public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                int ticks = 2 * planModes.size();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
                for (ISharedPlanMode planMode : planModes) {
                    String content = planMode.getDescription();
                    if (!planMode.isNewItem()) {
                        planMode = (ISharedPlanMode)IterationPlanClient.this.getItemManager().fetchCompleteItem((IItemHandle)planMode, 1, (IProgressMonitor)progress.newChild(1)).getWorkingCopy();
                    }
                    planMode.setDescription(content);
                    planMode = IterationPlanClient.this.getService().saveSharedPlanMode(planMode);
                    IterationPlanClient.this.getItemManager().applyItemUpdates(Arrays.asList(planMode));
                    progress.setWorkRemaining(ticks -= 2);
                    result.add(planMode);
                }
                return null;
            }
        }, Messages.IterationPlanClient_OPERATION_SAVE_PLAN_MODE, monitor);
        return result;
    }

    public IOperationReport deleteSharedPlanModeDescription(final IProjectAreaHandle projectArea, final List<ISharedPlanMode> planModes, IProgressMonitor monitor) throws TeamRepositoryException {
        return PlanningClientPlugin.getProcessItemService(this.getTeamRepository()).execute(new ProcessRunnable(){

            public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
                int ticks = planModes.size();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
                for (ISharedPlanMode planMode : planModes) {
                    Object object = planMode = planMode.isWorkingCopy() ? planMode : planMode.getWorkingCopy();
                    if (planMode.isNewItem()) continue;
                    IterationPlanClient.this.getService().deleteSharedPlanMode(planMode);
                    progress.setWorkRemaining(--ticks);
                }
                IterationPlanClient.this.getConfigurationElementCache(projectArea).clear();
                return null;
            }
        }, Messages.IterationPlanClient_OPERATION_DELETE_PLAN_MODE, monitor);
    }

    private static <R> FutureTask<R> submit(FutureTask<R> future) {
        Executors.newSingleThreadExecutor().submit(future);
        return future;
    }

    private static <R> R joinResult(Future<R> future) throws TeamRepositoryException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new TeamRepositoryException(e.getCause());
        }
    }

    static final class CacheCleaner
    extends FoundationJob
    implements ISharedItemChangeListener {
        private ItemSet<IProjectAreaHandle> fProjectAreas = new ItemHashSet(CMode.CURRENT_HANDLEONLY);
        private IItemManager fItemManager;
        private final IPlanningCommon fPlanningCommon;

        CacheCleaner(IPlanningCommon planningCommon, IItemManager itemManager) {
            super("");
            this.setPriority(30);
            this.setUser(false);
            this.setSystem(true);
            this.fPlanningCommon = planningCommon;
            this.fItemManager = itemManager;
            this.fItemManager.addItemChangeListener(IProjectArea.ITEM_TYPE, (ISharedItemChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            ItemHashSet projectAreas = new ItemHashSet(CMode.CURRENT_HANDLEONLY);
            ItemSet<IProjectAreaHandle> itemSet = this.fProjectAreas;
            synchronized (itemSet) {
                projectAreas.addAll(this.fProjectAreas);
                this.fProjectAreas.clear();
            }
            for (IProjectAreaHandle projectArea : projectAreas) {
                ConfigurationElementCache cache = this.fPlanningCommon.getConfigurationElementCache(projectArea);
                if (cache == null) continue;
                final boolean[] projectAreaValid = new boolean[]{cache.knownOrigin(projectArea.getItemId())};
                IItem item = this.fItemManager.getSharedItemIfKnown((IItemHandle)projectArea);
                final UUID state = item != null && item.getStateId() != null ? item.getStateId() : projectArea.getStateId();
                cache.validate(projectArea.getItemId(), new ConfigurationElementCache.IInvalidationStrategy(){

                    public boolean validate(Object cachedState) {
                        boolean valid = state != null && state.equals(cachedState);
                        projectAreaValid[0] = projectAreaValid[0] & valid;
                        return valid;
                    }
                });
                final StaticConfigurationDataRegistry instance = StaticConfigurationDataRegistry.getInstance();
                cache.validate(instance.getOrigin(), new ConfigurationElementCache.IInvalidationStrategy(){

                    public boolean validate(Object cachedState) {
                        return projectAreaValid[0] && instance.getState().equals(cachedState);
                    }
                });
                cache.validate(ICacheEntryState.DEFAULT_ORIGIN, new ConfigurationElementCache.IInvalidationStrategy(){

                    public boolean validate(Object cachedState) {
                        return !(cachedState instanceof Long) || Math.abs((Long)cachedState - System.currentTimeMillis()) < 3600000L;
                    }
                });
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemsChanged(List events) {
            boolean schedule = false;
            Iterator iter = events.iterator();
            while (iter.hasNext() && !schedule) {
                ISharedItemChangeEvent next = (ISharedItemChangeEvent)iter.next();
                IProjectAreaHandle projectArea = (IProjectAreaHandle)next.getSharedItem();
                ConfigurationElementCache cache = this.fPlanningCommon.getConfigurationElementCacheIfExists(projectArea);
                if (cache == null) continue;
                ItemSet<IProjectAreaHandle> itemSet = this.fProjectAreas;
                synchronized (itemSet) {
                    schedule = this.fProjectAreas.add((Object)projectArea);
                }
            }
            if (schedule) {
                this.schedule();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CacheEntry<E> {
        private final long fTimestamp;
        private final E fElement;
        private final UUID fStateId;

        public CacheEntry(long timestamp, UUID stateId, E element) {
            this.fTimestamp = timestamp;
            this.fStateId = stateId;
            this.fElement = element;
        }

        public E getElement() {
            return this.fElement;
        }

        public long getTimestamp() {
            return this.fTimestamp;
        }

        public boolean isValid(long timeStamp, UUID stateId) {
            return timeStamp - this.getTimestamp() <= 0x6DDD00L && this.fStateId.equals((Object)stateId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ResourceLocationMassage
    extends ProjectAreaBasedMassage<IPlanType> {
        ResourceLocationMassage() {
        }

        public Class<IPlanType> getType() {
            return IPlanType.class;
        }

        public void massage(IProjectAreaHandle projectArea, IPlanType object, INode node, INodeProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
            URI definedURI = object.getIconURI();
            if (definedURI != null) {
                URI replacingURI = null;
                String scheme = definedURI.getScheme();
                if (scheme == null || "processattachment".equals(scheme)) {
                    try {
                        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.team.apt.scripts"), (IPath)new Path(definedURI.getSchemeSpecificPart()), null);
                        if (url != null) {
                            replacingURI = url.toURI();
                        }
                    }
                    catch (URISyntaxException e) {
                        PlanningClientPlugin.log(e);
                    }
                } else if ("bundleentry".equals(scheme)) {
                    replacingURI = definedURI;
                }
                ConfigurationElements.update((Object)object, (Object)definedURI, (Object)replacingURI);
            }
        }
    }
}

