/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.setup.internal;

import com.ibm.rational.connector.cq.common.cqgateway.CQGateway;
import com.ibm.rational.connector.cq.setup.ICQSetupService;
import com.ibm.rational.connector.cq.setup.internal.CQAdminService;
import com.ibm.rational.connector.cq.setup.internal.Messages;
import com.ibm.rational.connector.cq.setup.internal.SetupHelper;
import com.ibm.rational.connector.cq.teamapi.common.ICqDbInfo;
import com.ibm.rational.connector.cq.teamapi.common.ICqFieldDefinition;
import com.ibm.rational.connector.cq.teamapi.common.ICqFolder;
import com.ibm.rational.connector.cq.teamapi.common.ICqFolderItem;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.internal.BasicCQConnectionInfo;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.rational.connector.cq.teamapi.common.internal.InteropProperties;
import com.ibm.team.interop.common.InteropFactory;
import com.ibm.team.interop.common.dto.IPropertyInfoDTO;
import com.ibm.team.interop.common.dto.ITypeInfoDTO;
import com.ibm.team.interop.service.managers.clearquest.common.CQInteropConstants;
import com.ibm.team.interop.service.managers.clearquest.common.InteropConnectionInfo;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.rational.clearquest.cqjni.CQDatabase;
import com.rational.clearquest.cqjni.CQEntityDefs;
import com.rational.clearquest.cqjni.CQException;
import com.rational.clearquest.cqjni.CQPackageRev;
import com.rational.clearquest.cqjni.CQPackageRevs;
import com.rational.clearquest.cqjni.CQSchema;
import com.rational.clearquest.cqjni.CQSchemaRev;
import com.rational.clearquest.cqjni.CQSchemaRevs;
import com.rational.clearquest.cqjni.CQSchemas;
import com.rational.clearquest.cqjni.CQUser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQSetupService
extends CQAdminService
implements ICQSetupService {
    private CQSchema m_schema = null;
    private CQDatabase m_db = null;
    protected String m_cqInstallDirectory;
    protected String m_gatewayInstallPackageDirectory;
    protected boolean m_allowPackageEditing = false;
    protected InteropProperties m_properties;
    protected Map<String, PackageRevInfo> m_packageInfo = new HashMap<String, PackageRevInfo>();
    private static final String GOOD_RESULT = "+++";
    private static final String PACKAGE_EDITING_COMMAND_GOOD_RESULT = "abled the package editing option for user";
    private static final String CHECKIN_COMMAND_GOOD_RESULT = "--- Checked in";
    protected static final String JAZZ_INTEROP_PACKAGE_NAME = "JazzInterop";
    private static final String METADATA_REVISION_STRING = "Metadata Revision:";
    private static final String REVISION_STRING = "Revision:";
    private static final String SPACE = " ";
    public static final String CQ_INSTALL_DIRECTORY_PROPERTY = "cq.home";
    public static final String GATEWAY_INSTALL_PACKAGE_DIRECTORY_PROPERTY = "com.ibm.rational.connector.cq.gateway.cqPackageDir";
    private static final List<String> jazzConnectorInternalTables = Arrays.asList("JazzConnectorChangeEvents", "JazzConnectorProperties", "JazzConnectorQueryInfo", "JazzConnectorSyncHistory");
    private static final String[] jazzInteropPackageDependencies = new String[]{"Notes 5.0", "Email 7.1"};

    @Override
    public long getNewestSchemaRevId() throws InteropException {
        CQSchemaRev rev = this.getNewestSchemaRev(this.m_schema);
        try {
            return rev.GetRevID();
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    @Override
    public void ensureAdminUserCanBeSubscribed() throws Exception {
        CQUser user = this.getCQAdminSession().GetUser("admin");
        user.SetSubscribedToAllDatabases(true);
    }

    public CQSetupService(InteropProperties properties) throws InteropException {
        this.m_properties = properties;
        String osName = System.getProperty("os.name");
        if (!osName.contains("Windows")) {
            throw new InteropException(MessageFormat.format(Messages.getString("CQSetupService.ERROR_GATEWAY_SETUP_ONLY_ON_WINDOWS"), osName));
        }
        this.m_cqInstallDirectory = this.determineCQInstallDirectory();
        this.m_gatewayInstallPackageDirectory = this.determineGatewayInstallDirectory();
        String dbSetDbName = (String)this.m_properties.getConfigValue("cq.dbSetDbName");
        if (dbSetDbName != null) {
            String[] splitString = dbSetDbName.split("/");
            this.m_cqDbSetName = splitString[0];
            this.m_cqUserDbName = splitString[1];
        }
    }

    @Override
    public Map<String, Boolean> getRecordTypes() throws InteropException {
        if (!this.m_loggedIn) {
            throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_LOGGED_INTO_CQ"));
        }
        try {
            String[] recordTypeNames = this.getCQSession().GetEntityDefNames();
            CQDatabase db = this.getCQAdminSession().GetDatabase(this.m_cqUserDbName);
            CQSchemaRev schemaRev = db.GetSchemaRev();
            CQEntityDefs enabledRecordTypes = schemaRev.GetEnabledEntityDefs(JAZZ_INTEROP_PACKAGE_NAME, CQInteropConstants.EMPTY_STRING);
            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
            int i = 0;
            while (i < recordTypeNames.length) {
                String typeName = recordTypeNames[i];
                if (!jazzConnectorInternalTables.contains(typeName)) {
                    resultMap.put(typeName, false);
                }
                ++i;
            }
            if (enabledRecordTypes != null) {
                i = 0;
                while ((long)i < enabledRecordTypes.Count()) {
                    resultMap.put(enabledRecordTypes.Item((long)i).GetName(), true);
                    ++i;
                }
            }
            if (resultMap.containsKey("users")) {
                resultMap.put("users", true);
            }
            if (resultMap.containsKey("attachments")) {
                resultMap.put("attachments", true);
            }
            return resultMap;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    @Override
    public boolean specifyCQConnectorUser(String gatewayUserId, String password) throws InteropException {
        this.m_properties.setConfigValue("cq.userid", (Object)gatewayUserId);
        this.m_properties.setConfigValue("cq.password", (Object)password);
        return true;
    }

    @Override
    public boolean commitCQConnectorUserChoice(String gatewayUserId, String password) throws InteropException {
        if (!this.m_loggedIn) {
            throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_LOGGED_INTO_CQ"));
        }
        try {
            CQUser user = this.getCQAdminSession().GetUser(gatewayUserId);
            if (user == null) {
                throw new InteropException(MessageFormat.format(Messages.getString("CQSetupService.ERROR_NO_SUCH_CQ_USER"), gatewayUserId));
            }
            if (!(gatewayUserId.equals("admin") || user.GetUserPrivilege(4L) || user.GetUserPrivilege(7L))) {
                throw new InteropException(MessageFormat.format(Messages.getString("CQSetupService.ERROR_CQ_CONNECTOR_USER_PRIVILEGE_ISSUE"), gatewayUserId));
            }
            this.addUserToDb(user);
            this.specifyCQConnectorUser(gatewayUserId, password);
            return true;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    protected String generatePasswordString() {
        if (this.m_cqAdminPassword.equals(CQInteropConstants.EMPTY_STRING)) {
            return "\"\"";
        }
        return this.m_cqAdminPassword;
    }

    protected boolean invokeCommand(String command, String goodResultString) throws InteropException {
        block10: {
            StringBuffer sb = new StringBuffer();
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Executing: " + command));
            }
            Process process = Runtime.getRuntime().exec(command);
            boolean success = false;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line);
                    if (line.indexOf(goodResultString) != -1) {
                        success = true;
                    }
                    line = reader.readLine();
                }
                if (!success) {
                    throw new InteropException(sb.toString());
                }
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InteropException((Throwable)e);
                }
            }
            reader.close();
        }
        return true;
    }

    protected boolean invokeCommand(String command) throws InteropException {
        return this.invokeCommand(command, GOOD_RESULT);
    }

    public boolean registerPackageVersion(String packageVersion) throws InteropException {
        String registerPackageCommand = String.valueOf(this.m_cqInstallDirectory) + "packageutil registerpackage " + JAZZ_INTEROP_PACKAGE_NAME + SPACE + packageVersion + " \"" + this.m_cqInstallDirectory + "packages/" + JAZZ_INTEROP_PACKAGE_NAME + "/" + packageVersion + "\"";
        return this.invokeCommand(registerPackageCommand);
    }

    private boolean installPackageVersion(String packageVersion) throws InteropException {
        String installPackageCommand = String.valueOf(this.m_cqInstallDirectory) + "packageutil installintoschemarepo -dbset " + this.m_cqDbSetName + SPACE + this.m_cqAdminUserId + SPACE + this.generatePasswordString() + SPACE + JAZZ_INTEROP_PACKAGE_NAME + SPACE + packageVersion;
        return this.invokeCommand(installPackageCommand);
    }

    private boolean applyPackageToRecordTypes(List<String> recordTypeNames) throws InteropException {
        for (String typeName : recordTypeNames) {
            String enableRecordTypeCommand = String.valueOf(this.m_cqInstallDirectory) + "packageutil enablerecordtype -dbset " + this.m_cqDbSetName + SPACE + this.m_cqAdminUserId + SPACE + this.generatePasswordString() + SPACE + this.m_cqSchemaName + SPACE + JAZZ_INTEROP_PACKAGE_NAME + SPACE + typeName;
            this.invokeCommand(enableRecordTypeCommand);
        }
        return true;
    }

    private boolean enablePackageForSchema(Stack<String> versions) throws InteropException {
        while (!versions.isEmpty()) {
            String v = versions.pop();
            String enableSchemaCommand = String.valueOf(this.m_cqInstallDirectory) + "packageutil enableschema -dbset " + this.m_cqDbSetName + SPACE + this.m_cqAdminUserId + SPACE + this.generatePasswordString() + SPACE + this.m_cqSchemaName + SPACE + JAZZ_INTEROP_PACKAGE_NAME + SPACE + v;
            this.invokeCommand(enableSchemaCommand);
        }
        return true;
    }

    private boolean checkinSchema() throws InteropException {
        String checkinCommand = String.valueOf(this.m_cqInstallDirectory) + "packageutil checkin -dbset " + this.m_cqDbSetName + SPACE + this.m_cqAdminUserId + SPACE + this.generatePasswordString() + SPACE + this.m_cqSchemaName;
        return this.invokeCommand(checkinCommand, CHECKIN_COMMAND_GOOD_RESULT);
    }

    private void parseDiscoverInstalledVersionsCommandLine(String line) {
        int indexOfLastSlash = line.lastIndexOf("\\");
        String versionString = line.substring(indexOfLastSlash + 1);
        PackageRevInfo info = this.m_packageInfo.get(versionString);
        info.setInstalled(true);
    }

    private boolean discoverInstalledVersions() throws InteropException {
        block9: {
            String discoverInstalledVersionsCommand = String.valueOf(this.m_cqInstallDirectory) + "packageutil showinstalledpackages -dbset " + this.m_cqDbSetName + SPACE + this.m_cqAdminUserId + SPACE + this.generatePasswordString();
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Executing: " + discoverInstalledVersionsCommand));
            }
            Process discoverInstalledVersionsProcess = Runtime.getRuntime().exec(discoverInstalledVersionsCommand);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(discoverInstalledVersionsProcess.getInputStream()));
                StringBuffer sb = new StringBuffer();
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line);
                    if (line.indexOf(JAZZ_INTEROP_PACKAGE_NAME) != -1 && line.indexOf("Location") != -1) {
                        this.parseDiscoverInstalledVersionsCommandLine(line);
                    }
                    line = reader.readLine();
                }
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InteropException((Throwable)e);
                }
            }
            reader.close();
        }
        return true;
    }

    private void parseDiscoverRegisteredVersionsCommandLine(String line) {
        int indexOfRevision = line.indexOf(REVISION_STRING);
        int indexOfSemiColon = line.indexOf(";", indexOfRevision);
        String versionString = line.substring(indexOfRevision + REVISION_STRING.length() + 1, indexOfSemiColon);
        PackageRevInfo info = this.m_packageInfo.get(versionString);
        int indexOfMetadataRevision = line.indexOf(METADATA_REVISION_STRING);
        int version = Integer.parseInt(line.substring(indexOfMetadataRevision + METADATA_REVISION_STRING.length() + 1));
        info.setVersion(version);
        info.setRegistered(true);
    }

    private boolean discoverRegisteredVersions() throws InteropException {
        block9: {
            String discoverRegisteredVersionsCommand = String.valueOf(this.m_cqInstallDirectory) + "packageutil showregisteredpackages " + JAZZ_INTEROP_PACKAGE_NAME;
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Executing: " + discoverRegisteredVersionsCommand));
            }
            Process discoverRegisteredVersionsProcess = Runtime.getRuntime().exec(discoverRegisteredVersionsCommand);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(discoverRegisteredVersionsProcess.getInputStream()));
                StringBuffer sb = new StringBuffer();
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line);
                    if (line.indexOf(JAZZ_INTEROP_PACKAGE_NAME) != -1) {
                        this.parseDiscoverRegisteredVersionsCommandLine(line);
                    }
                    line = reader.readLine();
                }
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InteropException((Throwable)e);
                }
            }
            reader.close();
        }
        return true;
    }

    private boolean packageEditing(boolean enable) throws InteropException {
        String packageEditingCommand = String.valueOf(this.m_cqInstallDirectory) + "packageutil enablepackageediting -dbset " + this.m_cqDbSetName + SPACE + this.m_cqAdminUserId + SPACE + this.generatePasswordString() + (enable ? " -enable " : " -disable ") + this.m_cqAdminUserId;
        return this.invokeCommand(packageEditingCommand, PACKAGE_EDITING_COMMAND_GOOD_RESULT);
    }

    private boolean enablePackageEditing() throws InteropException {
        return this.packageEditing(true);
    }

    private boolean disablePackageEditing() throws InteropException {
        return this.packageEditing(false);
    }

    private String determineGatewayInstallDirectory() throws InteropException {
        String result = System.getProperty(GATEWAY_INSTALL_PACKAGE_DIRECTORY_PROPERTY);
        if (result == null) {
            throw new InteropException(MessageFormat.format(Messages.getString("CQSetupService.ERROR_MISSING_SYSTEM_PROPERTY"), GATEWAY_INSTALL_PACKAGE_DIRECTORY_PROPERTY));
        }
        if (!result.endsWith("\\") && !result.endsWith("/")) {
            result = String.valueOf(result) + "/";
        }
        return result;
    }

    private String determineCQInstallDirectory() throws InteropException {
        String result = System.getProperty(CQ_INSTALL_DIRECTORY_PROPERTY);
        if (result == null) {
            throw new InteropException(MessageFormat.format(Messages.getString("CQSetupService.ERROR_MISSING_SYSTEM_PROPERTY"), CQ_INSTALL_DIRECTORY_PROPERTY));
        }
        if (!result.endsWith("\\") && !result.endsWith("/")) {
            result = String.valueOf(result) + "/";
        }
        return result;
    }

    void copyPackageFilesFromGatewayInstallDir() throws InteropException {
        List<String> installedDirectories = null;
        File jazzInteropPackageDirectory = new File(String.valueOf(this.m_cqInstallDirectory) + "/packages/" + JAZZ_INTEROP_PACKAGE_NAME);
        if (jazzInteropPackageDirectory.exists()) {
            installedDirectories = Arrays.asList(jazzInteropPackageDirectory.list());
        } else {
            jazzInteropPackageDirectory.mkdir();
        }
        File packageDirectoryFromInstall = new File(String.valueOf(this.m_gatewayInstallPackageDirectory) + JAZZ_INTEROP_PACKAGE_NAME);
        if (packageDirectoryFromInstall.exists()) {
            File[] allVersionDirectories;
            File[] fileArray = allVersionDirectories = packageDirectoryFromInstall.listFiles();
            int n = allVersionDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String versionName = f.getName();
                PackageRevInfo info = new PackageRevInfo(versionName);
                this.m_packageInfo.put(versionName, info);
                info.setIncremental(new File(f, "incremental").exists());
                if (installedDirectories == null || !installedDirectories.contains(versionName)) {
                    File newSubDirectory = new File(jazzInteropPackageDirectory, versionName);
                    newSubDirectory.mkdir();
                    try {
                        if (this.m_log.isDebugEnabled()) {
                            this.m_log.debug((Object)("Executing: Copy " + f.getAbsolutePath() + " to " + newSubDirectory.getAbsolutePath()));
                        }
                        SetupHelper.copyDirectory(f, newSubDirectory);
                    }
                    catch (IOException e) {
                        throw new InteropException((Throwable)e);
                    }
                    this.registerPackageVersion(versionName);
                }
                ++n2;
            }
        } else {
            throw new InteropException(Messages.getString("CQSetupService.ERROR_INSTALL_ISSUE"));
        }
    }

    public CQSchemaRev getNewestSchemaRev(CQSchema schema) throws InteropException {
        try {
            CQSchemaRevs allSchemaRevs = schema.GetSchemaRevs();
            CQSchemaRev newest = allSchemaRevs.Item(0L);
            int i = 0;
            while ((long)i < allSchemaRevs.Count()) {
                CQSchemaRev possible = allSchemaRevs.Item((long)i);
                if (possible.GetRevID() > newest.GetRevID()) {
                    newest = possible;
                }
                ++i;
            }
            return newest;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    private Stack<String> discoverPackageRevToEnable(SortedSet<PackageRevInfo> packageInfoSortedList) throws InteropException {
        Stack<String> jazzInteropPackageVersionsToEnable = new Stack<String>();
        boolean foundANonIncremental = false;
        for (PackageRevInfo info : packageInfoSortedList) {
            if (!foundANonIncremental) {
                if (info.isIncremental()) {
                    throw new InteropException(Messages.getString("CQSetupService.ERROR_INSTALL_ISSUE"));
                }
                foundANonIncremental = true;
                jazzInteropPackageVersionsToEnable.push(info.getVersionString());
                continue;
            }
            if (!info.isIncremental()) break;
            jazzInteropPackageVersionsToEnable.push(info.getVersionString());
        }
        return jazzInteropPackageVersionsToEnable;
    }

    private Stack<String> discoverPackageRevToEnable(CQSchema schema) throws InteropException {
        Stack<String> newVersions;
        block5: {
            try {
                CQSchemaRev current = this.getNewestSchemaRev(schema);
                CQPackageRevs packageRevs = current.GetEnabledPackageRevs();
                ArrayList<String> jazzInteropPackageVersionsEnabled = new ArrayList<String>();
                int i = 0;
                while ((long)i < packageRevs.Count()) {
                    CQPackageRev rev = packageRevs.Item((long)i);
                    if (rev.GetPackageName().equals(JAZZ_INTEROP_PACKAGE_NAME)) {
                        jazzInteropPackageVersionsEnabled.add(rev.GetRevString());
                    }
                    ++i;
                }
                TreeSet<PackageRevInfo> packageInfoSortedList = new TreeSet<PackageRevInfo>(this.m_packageInfo.values());
                newVersions = this.discoverPackageRevToEnable(packageInfoSortedList);
                if (jazzInteropPackageVersionsEnabled.isEmpty() || newVersions.isEmpty() || !jazzInteropPackageVersionsEnabled.contains(newVersions.firstElement())) break block5;
                return null;
            }
            catch (CQException e) {
                throw new InteropException((Throwable)e);
            }
        }
        return newVersions;
    }

    private boolean upgradeDatabase(CQDatabase db, CQSchema schema) throws InteropException {
        try {
            db.Upgrade(this.getNewestSchemaRev(schema));
            return true;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
    }

    private void setupJazzInteropPackageVersions() throws InteropException {
        this.copyPackageFilesFromGatewayInstallDir();
        this.discoverInstalledVersions();
        this.discoverRegisteredVersions();
        Collection<PackageRevInfo> packageInfoList = this.m_packageInfo.values();
        for (PackageRevInfo info : packageInfoList) {
            if (info.isRegistered()) continue;
            this.registerPackageVersion(info.getVersionString());
        }
        for (PackageRevInfo info : packageInfoList) {
            if (info.isInstalled()) continue;
            this.installPackageVersion(info.getVersionString());
        }
        this.discoverRegisteredVersions();
    }

    @Override
    public boolean enableRecordTypesForSynchronization(List<String> recordTypeNames) throws InteropException {
        if (!this.m_loggedIn) {
            throw new IllegalStateException(Messages.getString("CQSetupService.ERROR_OPERATION_ILLEGAL_WITHOUT_LOGGED_INTO_CQ"));
        }
        boolean enabledPackageForEditing = false;
        try {
            this.setupJazzInteropPackageVersions();
            CQDatabase db = this.getCQAdminSession().GetDatabase(this.m_cqUserDbName);
            CQSchemaRev schemaRev = db.GetSchemaRev();
            CQSchema schema = schemaRev.GetSchema();
            this.m_cqSchemaName = schema.GetName();
            Stack<String> packageRevsToEnable = this.discoverPackageRevToEnable(schema);
            if (packageRevsToEnable != null && !packageRevsToEnable.isEmpty()) {
                this.enablePackageForSchema(packageRevsToEnable);
            }
            enabledPackageForEditing = this.enablePackageEditing();
            this.applyPackageToRecordTypes(recordTypeNames);
            this.checkinSchema();
            this.loginToCQ();
            db = this.getCQAdminSession().GetDatabase(this.m_cqUserDbName);
            schemaRev = db.GetSchemaRev();
            schema = schemaRev.GetSchema();
            this.upgradeDatabase(db, schema);
            return true;
        }
        catch (CQException e) {
            throw new InteropException((Throwable)e);
        }
        finally {
            if (enabledPackageForEditing) {
                this.disablePackageEditing();
            }
        }
    }

    @Override
    public List<String> updateQueryFolderStructure(String rootFolderFullPath, List<String> projectAreaNames, boolean deleteUnused) throws InteropException {
        ICqDbInfo dbInfo = this.loginToCM_API();
        this.m_properties.setConfigValue("cq.queryTreeRoot", (Object)rootFolderFullPath);
        ICqFolder rootFolder = dbInfo.findFolder(rootFolderFullPath);
        if (rootFolder == null) {
            rootFolder = dbInfo.createFolder(rootFolderFullPath);
        }
        if (projectAreaNames != null) {
            List children;
            if (deleteUnused && (children = rootFolder.getChildren()) != null) {
                for (ICqFolderItem child : children) {
                    String name;
                    if (!(child instanceof ICqFolder) || projectAreaNames.contains(name = child.getName())) continue;
                    ((ICqFolder)child).deleteFolder();
                }
            }
            ArrayList<String> foldersCreated = new ArrayList<String>();
            for (String name : projectAreaNames) {
                String folderPath = String.valueOf(rootFolderFullPath) + "/" + name;
                if (this.folderExists(folderPath, dbInfo)) continue;
                rootFolder.createFolder(name);
                foldersCreated.add(folderPath);
            }
            return foldersCreated;
        }
        return null;
    }

    private List<IPropertyInfoDTO> getPropertyInfo(List<ICqFieldDefinition> fields) throws InteropException {
        ArrayList<IPropertyInfoDTO> result = new ArrayList<IPropertyInfoDTO>();
        for (ICqFieldDefinition f : fields) {
            List allowedValues;
            IPropertyInfoDTO obj = InteropFactory.INSTANCE.createPropertyInfoDTO();
            obj.setIdentifier(f.isIdentifier());
            obj.setModifier(f.isModifier());
            obj.setName(f.getName());
            String referenceTypeName = f.getReferencedRecordTypeName();
            obj.setTransformer(f.getTransformer());
            if (referenceTypeName != null) {
                obj.setReferenceTypeName(CqGatewayConstants.objectFactory.createUniqueTypeName(referenceTypeName));
            }
            if ((allowedValues = f.getAllowedValues()) != null) {
                obj.getAllowedValues().addAll(allowedValues);
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public List<ITypeInfoDTO> getTypeInfo() throws InteropException {
        this.loginToCM_API();
        String dbSetDbName = String.valueOf(this.m_cqDbSetName) + '/' + this.m_cqUserDbName;
        CQGateway gateway = CQGateway.getCQGateway();
        gateway.connectToRepositoryLocal((InteropConnectionInfo)new BasicCQConnectionInfo(this.m_cqAdminUserId, this.m_cqAdminPassword, dbSetDbName));
        Object[] typeInfoArray = gateway.getSupportedTypeInfo(dbSetDbName, true);
        ArrayList<ITypeInfoDTO> result = new ArrayList<ITypeInfoDTO>();
        Object[] objectArray = typeInfoArray;
        int n = typeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ICqRecordType typeInfo = (ICqRecordType)o;
            ITypeInfoDTO obj = InteropFactory.INSTANCE.createTypeInfoDTO();
            obj.setName(typeInfo.getQualifiedName());
            obj.setMappedName(typeInfo.getJazzType());
            obj.setSyncAllStates(!typeInfo.getIsStateless());
            obj.getProperties().addAll(this.getPropertyInfo(typeInfo.getAllProperties()));
            result.add(obj);
            ++n2;
        }
        return result;
    }

    @Override
    public void setCqDbSetName(String cqDbSetName) {
        this.m_cqDbSetName = cqDbSetName;
        this.m_properties.setConfigValue("cq.dbSetDbName", (Object)(String.valueOf(this.m_cqDbSetName) + "/" + this.m_cqUserDbName));
    }

    @Override
    public void setCqUserDbName(String cqUserDbName) {
        this.m_cqUserDbName = cqUserDbName;
        this.m_properties.setConfigValue("cq.dbSetDbName", (Object)(String.valueOf(this.m_cqDbSetName) + "/" + this.m_cqUserDbName));
    }

    @Override
    public String getCqConnectorUserId() {
        return (String)this.m_properties.getConfigValue("cq.userid");
    }

    @Override
    public String getCqConnectorUserPassword() {
        return (String)this.m_properties.getConfigValue("cq.password");
    }

    @Override
    public String getCqQueryFolderRootName() {
        String result = (String)this.m_properties.getConfigValue("cq.queryTreeRoot");
        return result == null ? CQInteropConstants.EMPTY_STRING : result;
    }

    @Override
    public void setCqSchemaName(String schemaName) {
        this.m_cqSchemaName = schemaName;
    }

    public void setAllowPackageEditing(boolean packageEditing) {
        this.m_allowPackageEditing = packageEditing;
    }

    @Override
    public String getCqDbSetName() {
        String dbSetDbName = (String)this.m_properties.getConfigValue("cq.dbSetDbName");
        if (dbSetDbName == null) {
            return null;
        }
        String[] splitString = dbSetDbName.split("/");
        return splitString[0];
    }

    @Override
    public String getCqUserDbName() {
        String dbSetDbName = (String)this.m_properties.getConfigValue("cq.dbSetDbName");
        if (dbSetDbName == null) {
            return null;
        }
        String[] splitString = dbSetDbName.split("/");
        return splitString[1];
    }

    public String getCqSchemaName() {
        return this.m_cqSchemaName;
    }

    public CQSchemas getSchemas() throws Exception {
        return this.getCQAdminSession().GetSchemas();
    }

    @Override
    public boolean findSchema(String name) throws Exception {
        CQSchemas schemas = this.getSchemas();
        int i = 0;
        while ((long)i < schemas.Count()) {
            CQSchema schema = schemas.Item((long)i);
            if (schema.GetName().equals(name)) {
                this.m_schema = schema;
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean createDatabase(String fileName) throws Exception {
        CQDatabase newDb = this.getCQAdminSession().CreateDatabase(this.m_cqUserDbName);
        this.findSchema(this.m_cqSchemaName);
        CQSchemaRev schemaRev = this.getNewestSchemaRev(this.m_schema);
        newDb.SetVendor(2L);
        newDb.SetDatabaseName(new File(fileName).getAbsolutePath());
        newDb.SetInitialSchemaRev(schemaRev);
        newDb.SetName(this.m_cqUserDbName);
        newDb.ApplyPropertyChanges(false);
        newDb.UpgradeMasterUserInfo();
        this.m_db = newDb;
        return true;
    }

    @Override
    public boolean deleteDatabase(String dbName) throws Exception {
        this.getCQAdminSession().DeleteDatabase(dbName);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PackageRevInfo
    implements Comparable<PackageRevInfo> {
        private int m_version;
        private String m_versionString;
        private boolean m_incremental = false;
        private boolean m_registered;
        private boolean m_installed;

        @Override
        public int compareTo(PackageRevInfo other) {
            if (this.m_version == other.m_version) {
                return 0;
            }
            if (this.m_version < other.m_version) {
                return 1;
            }
            return -1;
        }

        private PackageRevInfo(String versionString) {
            this.m_versionString = versionString;
        }

        private void setRegistered(boolean value) {
            this.m_registered = value;
        }

        private void setInstalled(boolean value) {
            this.m_installed = value;
        }

        private void setIncremental(boolean value) {
            this.m_incremental = value;
        }

        public void setVersion(int m_version) {
            this.m_version = m_version;
        }

        private int getVersion() {
            return this.m_version;
        }

        private String getVersionString() {
            return this.m_versionString;
        }

        private boolean isIncremental() {
            return this.m_incremental;
        }

        private boolean isInstalled() {
            return this.m_installed;
        }

        private boolean isRegistered() {
            return this.m_registered;
        }
    }
}

