/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.common.cqgateway;

import com.ibm.rational.connector.cq.common.cqgateway.CQGateway;
import com.ibm.rational.connector.cq.teamapi.common.ICQInteropEventHandler;
import com.ibm.rational.connector.cq.teamapi.common.ISyncedTable;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import java.net.URLDecoder;

public class SyncedTable {
    private static ISyncedTable singleton = null;

    private static void setSingleton() throws InteropException {
        if (singleton == null) {
            singleton = CqGatewayConstants.objectFactory.createSyncedTable();
        }
    }

    public static void addIdToSyncTable(String dbid, String recordTypeName, String projectAreaId, CQGateway cqGateway, String dbName) throws InteropException {
        ICQInteropEventHandler handler = null;
        try {
            SyncedTable.setSingleton();
            handler = (ICQInteropEventHandler)cqGateway.getConnection(dbName, false);
            singleton.addIdToSyncTable(dbid, recordTypeName, projectAreaId, handler, dbName);
        }
        finally {
            if (handler != null) {
                handler.release();
            }
        }
    }

    public static void deleteIdFromSyncTable(String dbid, String recordTypeName, String projectAreaId, CQGateway cqGateway, String dbName) throws InteropException {
        ICQInteropEventHandler handler = null;
        try {
            SyncedTable.setSingleton();
            handler = (ICQInteropEventHandler)cqGateway.getConnection(dbName, true);
            singleton.deleteIdFromSyncTable(dbid, recordTypeName, projectAreaId, handler, dbName);
        }
        finally {
            if (handler != null) {
                handler.release();
            }
        }
    }

    public static boolean lookupIdInSyncTable(String dbid, String recordTypeName, String projectAreaId, CQGateway cqGateway, String dbName) throws InteropException {
        ICQInteropEventHandler handler = null;
        try {
            SyncedTable.setSingleton();
            handler = (ICQInteropEventHandler)cqGateway.getConnection(dbName, true);
            boolean bl = singleton.lookupIdInSyncTable(dbid, recordTypeName, projectAreaId, handler, dbName);
            return bl;
        }
        finally {
            if (handler != null) {
                handler.release();
            }
        }
    }

    public static void addParseErrorInfo(String dbid, String recordTypeName, String projectAreaId) throws InteropException {
        SyncedTable.setSingleton();
        singleton.addParseErrorInfo(dbid, recordTypeName, projectAreaId);
    }

    public static void removeParseErrorInfo(String dbid, String recordTypeName, String projectAreaId) throws InteropException {
        SyncedTable.setSingleton();
        singleton.removeParseErrorInfo(dbid, recordTypeName, projectAreaId);
    }

    public static boolean sendFullStateBecauseOfParseError(String dbid, String recordTypeName, String projectAreaId) throws InteropException {
        SyncedTable.setSingleton();
        return singleton.sendFullStateBecauseOfParseError(dbid, recordTypeName, projectAreaId);
    }

    public static String getDbIdFromUniqueId(String uniqueId) throws Exception {
        String decodedUniqueId = URLDecoder.decode(uniqueId, "UTF-8");
        int indexOfAtSign = decodedUniqueId.indexOf(64);
        int indexOfSlash = decodedUniqueId.indexOf(47);
        if (indexOfAtSign == -1 || indexOfSlash == -1) {
            throw new InteropException("Malformed uniqueId: " + decodedUniqueId);
        }
        return decodedUniqueId.substring(indexOfSlash + 1, indexOfAtSign);
    }
}

