/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.common.cqgateway;

import com.ibm.rational.connector.cq.common.cqgateway.CQGateway;
import com.ibm.rational.connector.cq.common.cqgateway.CQInteropEventHandler;
import com.ibm.rational.connector.cq.common.cqgateway.Messages;
import com.ibm.rational.connector.cq.teamapi.common.ICqDbInfo;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.internal.LogFactory;
import com.ibm.team.interop.service.managers.clearquest.common.InteropConnectionInfo;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQRepository {
    private Log m_log;
    private Log m_logDetails;
    private ICqDbInfo m_userDbInfo = null;
    private String m_vendorType;
    private List<CQInteropEventHandler> m_cqConnections = new ArrayList<CQInteropEventHandler>();
    private InteropConnectionInfo m_connectionInfo = null;
    private CQGateway m_cqGateway;
    private int m_connectorTablesStatus = 1;
    private Integer m_numberOfConnectionsOpen = 0;
    private Integer m_numberOfConnectionsClosed = 0;
    private static final int NUMBER_CQ_CONNECTIONS_EXPECTED = 10;
    private static final boolean parallelismEnabled = false;

    public CQRepository(InteropConnectionInfo connectionInfo, CQGateway cqGateway) throws InteropException {
        this.m_connectionInfo = connectionInfo;
        this.m_cqGateway = cqGateway;
        this.m_log = LogFactory.getLog();
        this.m_logDetails = LogFactory.getLog((int)2);
        this.initializeRepoInfo();
    }

    public String getConnectionURI() {
        return this.m_connectionInfo.getConnectionURI();
    }

    public List<CQInteropEventHandler> getCqConnections() {
        return this.m_cqConnections;
    }

    public HashMap<String, ICqRecordType> getRecordTypeInfo() {
        return this.m_userDbInfo.getRecordTypeInfo();
    }

    public InteropConnectionInfo getConnectionInfo() {
        return this.m_connectionInfo;
    }

    public String getVendorType() {
        return this.m_vendorType;
    }

    public ICqRecordType getCqRecordTypeInfo(String typeName) throws InteropException {
        ICqRecordType result = this.m_userDbInfo.getCqRecordTypeInfo(typeName);
        if (result == null) {
            throw new InteropException(MessageFormat.format(Messages.getString("CQRepository.ERROR_NO_RECORD_TYPE_WITH_NAME"), typeName, this.m_connectionInfo.getConnectionURI()));
        }
        return result;
    }

    public boolean doesCqRecordTypeExist(String typeName) throws InteropException {
        ICqRecordType result = this.m_userDbInfo.getCqRecordTypeInfo(typeName);
        return result != null;
    }

    private int checkForCorrectPackageLevel(CQInteropEventHandler newHandler) {
        ICqProvider provider = newHandler.getImplementation();
        if (provider.isJNIProvider()) {
            return provider.checkForCorrectPackageLevel();
        }
        return 1;
    }

    private void initializeRepoInfo() throws InteropException {
        CQInteropEventHandler newHandler = null;
        try {
            try {
                newHandler = this.getHandler(false);
                this.m_connectorTablesStatus = this.checkForCorrectPackageLevel(newHandler);
                if (this.m_connectorTablesStatus > 0) {
                    if (this.m_userDbInfo == null) {
                        this.m_userDbInfo = newHandler.getCqDbInfo();
                        this.m_vendorType = this.m_userDbInfo.getVendorType();
                    }
                    switch (this.m_connectorTablesStatus) {
                        case 1: {
                            this.m_log.info((Object)Messages.getString("CQRepository.WARNING_SCHEMA_OR_PACKAGE_STATUS_UNKNOWN"));
                            break;
                        }
                        case 2: {
                            this.m_log.info((Object)Messages.getString("CQRepository.WARNING_CONNECTOR_TABLES_NOT_PRESENT"));
                        }
                    }
                } else {
                    this.m_log.error((Object)MessageFormat.format(Messages.getString("CQRepository.ERROR_SCHEMA_OR_PACKAGE_PROBLEM"), "1.07"));
                }
            }
            catch (InteropException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InteropException(MessageFormat.format(Messages.getString("CQRepository.ERROR_CANNOT_GET_CQ_DB_INFO"), this.m_connectionInfo.getConnectionURI()), (Throwable)e);
            }
        }
        finally {
            if (newHandler != null) {
                this.releaseHandler(newHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseHandler(CQInteropEventHandler handler) throws InteropException {
        List<CQInteropEventHandler> list = this.m_cqConnections;
        synchronized (list) {
            handler.release();
        }
    }

    public void releaseAllHandlers() throws InteropException {
        for (CQInteropEventHandler handler : this.m_cqConnections) {
            if (handler == null) {
                return;
            }
            if (this.m_logDetails.isDebugEnabled()) {
                this.m_logDetails.debug((Object)("Release " + handler.getThreadInfo() + " handler"));
            }
            handler.release(true);
        }
        this.m_cqConnections.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CQInteropEventHandler getHandler(boolean useFreshHandler) throws InteropException {
        if (useFreshHandler) {
            this.m_numberOfConnectionsOpen = this.m_numberOfConnectionsOpen + 1;
            return new CQInteropEventHandler("JAZZ", this, "new");
        }
        List<CQInteropEventHandler> list = this.m_cqConnections;
        synchronized (list) {
            Thread currentThread = Thread.currentThread();
            String threadName = currentThread.getName();
            for (CQInteropEventHandler handler : this.m_cqConnections) {
                if (!handler.getThreadInfo().equals(threadName)) continue;
                if (handler.available()) {
                    handler.inUse();
                    if (this.m_logDetails.isDebugEnabled()) {
                        this.m_logDetails.debug((Object)("Got handler for " + threadName));
                    }
                    return handler;
                }
                throw new InteropException("Handler for " + threadName + " is in use");
            }
            CQInteropEventHandler newHandler = new CQInteropEventHandler("JAZZ", this, threadName);
            this.m_cqConnections.add(newHandler);
            this.m_numberOfConnectionsOpen = this.m_numberOfConnectionsOpen + 1;
            if (this.m_logDetails.isDebugEnabled()) {
                this.m_logDetails.debug((Object)("Allocating another (" + this.m_cqConnections.size() + ") static CQ Interop handler " + threadName));
            }
            if (this.m_logDetails.isInfoEnabled() && this.m_cqConnections.size() > 10) {
                this.m_logDetails.info((Object)MessageFormat.format(Messages.getString("CQRepository.INFO_NUMBER_OF_CQ_CONNECTIONS_SEEM_EXCESSIVE"), this.m_cqConnections.size()));
            }
            newHandler.inUse();
            return newHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean usable() {
        List<CQInteropEventHandler> list = this.m_cqConnections;
        synchronized (list) {
            CQInteropEventHandler handler;
            Iterator<CQInteropEventHandler> iterator = this.m_cqConnections.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((handler = iterator.next()).usable());
            return false;
        }
    }

    public boolean parallelismSupportedInDb() {
        return false;
    }

    public boolean connectorTablesProblem() {
        return this.m_connectorTablesStatus == 0 || this.m_connectorTablesStatus == 2;
    }

    public boolean isSchemaEnabledForSynchronization() {
        return this.m_connectorTablesStatus > 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfLongLivedConnections() {
        List<CQInteropEventHandler> list = this.m_cqConnections;
        synchronized (list) {
            return this.m_cqConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfActiveConnections() {
        List<CQInteropEventHandler> list = this.m_cqConnections;
        synchronized (list) {
            int num = 0;
            for (CQInteropEventHandler handler : this.m_cqConnections) {
                if (handler.available()) continue;
                ++num;
            }
            return num;
        }
    }

    public int getNumberOfConnectionsOpen() {
        return this.m_numberOfConnectionsOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfConnectionsClosed() {
        Integer n = this.m_numberOfConnectionsClosed;
        synchronized (n) {
            return this.m_numberOfConnectionsClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void anotherConnectionClosed() {
        Integer n = this.m_numberOfConnectionsClosed;
        synchronized (n) {
            this.m_numberOfConnectionsClosed = this.m_numberOfConnectionsClosed + 1;
        }
    }

    public ICqDbInfo getDbInfo() {
        return this.m_userDbInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InteropException {
        List<CQInteropEventHandler> list = this.m_cqConnections;
        synchronized (list) {
            for (CQInteropEventHandler handler : this.m_cqConnections) {
                handler.close();
            }
        }
    }

    public List<String> getDeletedAttachmentIds() {
        return this.m_cqGateway.getDeletedAttachmentIds();
    }

    public void clearCachedInfo() throws InteropException {
        CQInteropEventHandler newHandler = null;
        newHandler = this.getHandler(true);
        this.m_userDbInfo = newHandler.getCqDbInfo();
    }
}

