/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.common.cqgateway;

import com.ibm.rational.connector.cq.common.cqgateway.CQRepository;
import com.ibm.rational.connector.cq.common.cqgateway.ChangeRecord;
import com.ibm.rational.connector.cq.common.cqgateway.Messages;
import com.ibm.rational.connector.cq.teamapi.common.ICQInteropEventHandler;
import com.ibm.rational.connector.cq.teamapi.common.ICqDbInfo;
import com.ibm.rational.connector.cq.teamapi.common.ICqExportData;
import com.ibm.rational.connector.cq.teamapi.common.ICqFieldDefinition;
import com.ibm.rational.connector.cq.teamapi.common.ICqLocation;
import com.ibm.rational.connector.cq.teamapi.common.ICqObject;
import com.ibm.rational.connector.cq.teamapi.common.ICqProvider;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.ICqResultSet;
import com.ibm.rational.connector.cq.teamapi.common.ICqRowData;
import com.ibm.rational.connector.cq.teamapi.common.InteropLocation;
import com.ibm.rational.connector.cq.teamapi.common.InteropWvcmException;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqFilterCriteria;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.rational.connector.cq.teamapi.common.internal.LogFactory;
import com.ibm.rational.connector.cq.teamapi.common.internal.SuppressEventNotification;
import com.ibm.team.interop.service.managers.clearquest.common.CQInteropConstants;
import com.ibm.team.interop.service.managers.clearquest.common.ERException;
import com.ibm.team.interop.service.managers.clearquest.common.InteropConnectionInfo;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.interop.service.managers.clearquest.common.RepositoryPrivateData;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQInteropEventHandler
implements ICQInteropEventHandler {
    private ICqProvider m_provider = null;
    private String m_eventOrigin;
    private List<String> m_privateDataProperties;
    private SuppressEventNotification m_suppressInfo;
    private boolean m_inUse = false;
    private String m_threadInfo;
    private CQRepository m_repo;
    private Log m_log = LogFactory.getLog();
    private Log m_logDetails = LogFactory.getLog((int)2);
    static ICqQuery pollingQuery = null;

    public CQInteropEventHandler(String eventOrigin, CQRepository repo, String threadInfo) throws InteropException {
        this.m_repo = repo;
        this.m_threadInfo = threadInfo;
        this.connect(repo.getConnectionInfo());
        this.m_eventOrigin = eventOrigin;
        this.m_suppressInfo = SuppressEventNotification.getSuppressEventNotification();
        this.m_privateDataProperties = RepositoryPrivateData.getPrivateDataProperties((String)"CQ", (String)this.m_eventOrigin);
    }

    public CQInteropEventHandler(String eventOrigin, CQRepository repo) throws InteropException {
        this(eventOrigin, repo, "unknown");
    }

    public String toString() {
        return "CQInteropEventHandler-" + this.m_repo.getConnectionURI() + '-' + this.m_threadInfo;
    }

    public void connect(InteropConnectionInfo info) throws InteropException {
        this.m_provider = CqGatewayConstants.objectFactory.createCqProvider(info, (ICQInteropEventHandler)this, !this.m_threadInfo.equals("new"));
    }

    public ICqDbInfo getCqDbInfo() throws InteropException {
        return CqGatewayConstants.objectFactory.createCqDbInfo(this.m_provider);
    }

    public String getQueryPrimaryRecordType(String queryPath) throws InteropException {
        ICqQuery query = CqGatewayConstants.objectFactory.lookupCqQuery(queryPath, this.m_repo.getConnectionURI(), this.m_provider);
        return query.getPrimaryResourceTypeName();
    }

    public boolean isQueryPathValid(String queryPath) throws InteropException {
        try {
            CqGatewayConstants.objectFactory.lookupCqQuery(queryPath, this.m_repo.getConnectionURI(), this.m_provider);
            return Boolean.TRUE;
        }
        catch (InteropWvcmException e) {
            if (e.notFoundException()) {
                return Boolean.FALSE;
            }
            throw e;
        }
    }

    private void handleException(InteropException e, ICqObject record) throws InteropException {
        try {
            record.doRevert();
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Reverted  " + record.getUserFriendlyLocation() + " using TeamAPI"));
            }
            throw e;
        }
        catch (InteropWvcmException interopWvcmException) {
            return;
        }
    }

    public Map<String, ?> handleCreateEvent(String typeName, Map<String, Object> properties, List<String> requestedPropertyNames, String source, InteropLocation uniqueId) throws InteropException, ERException {
        return this.handleCreateEvent(typeName, properties, uniqueId, requestedPropertyNames, source);
    }

    public Map<String, ?> handleCreateEvent(String typeName, Map<String, ?> properties, InteropLocation uniqueId, List<String> requestedPropertyNames, String source) throws InteropException, ERException {
        ICqObject record = null;
        try {
            ICqLocation location = (ICqLocation)uniqueId;
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Creating " + typeName + " using TeamAPI (source: " + source + ")"));
            }
            record = CqGatewayConstants.objectFactory.createNewCQObject((InteropLocation)location, typeName, this.m_provider);
            try {
                record.doInitialize(requestedPropertyNames, properties);
                if (source != null) {
                    record.suppressEventNotification(source, this.m_suppressInfo);
                }
                record.setObjectState(properties, false);
                record.doWriteProperties(requestedPropertyNames);
                record.forgetDelete(this.m_repo.getDeletedAttachmentIds(), location.getExternalLocationString());
                Map newState = record.createObjectState(requestedPropertyNames);
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)("Created  " + typeName + " with externalId " + URLDecoder.decode((String)newState.get("@@uniqueId@@"), "UTF-8")));
                }
                return newState;
            }
            catch (InteropWvcmException e) {
                this.handleException((InteropException)((Object)e), record);
                throw new InteropException(MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_CREATING"), e.explicateException()));
            }
        }
        catch (InteropWvcmException e) {
            ERException er = new ERException(e.explicateException());
            if (e.writeFailedException()) {
                er.setDeferred(true);
            }
            throw er;
        }
        catch (InteropException e) {
            this.handleException(e, record);
            throw e;
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_CREATION"), typeName), (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    public Map<String, ?> handleUpdateEvent(String typeName, Map<String, Object> properties, List<String> requestedPropertyNames, String source, InteropLocation uniqueId) throws InteropException, ERException {
        return this.handleUpdateEvent(typeName, properties, requestedPropertyNames, source, uniqueId, true);
    }

    public Map<String, ?> handleUpdateEvent(String typeName, Map<String, Object> properties, List<String> requestedPropertyNames, String source, InteropLocation uniqueId, boolean fullState) throws InteropException, ERException {
        ICqObject res = null;
        try {
            ICqLocation location = (ICqLocation)uniqueId;
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Updating  " + uniqueId + " using TeamAPI"));
            }
            res = CqGatewayConstants.objectFactory.lookup((InteropLocation)location, requestedPropertyNames, typeName, this.m_provider);
            int currentCQVersion = Integer.parseInt(res.getVersionNumber());
            int versionFromProperties = Integer.parseInt((String)properties.get(CqGatewayConstants.VERSION_FIELD_NAME));
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Current CQ version: " + currentCQVersion + " Proposed version:" + versionFromProperties));
            }
            if (currentCQVersion != versionFromProperties) {
                if (currentCQVersion > versionFromProperties) {
                    Map newProperties = res.createObjectState(requestedPropertyNames);
                    ERException er = new ERException(MessageFormat.format(Messages.getString("CQInteropEventHandler.WARNING_STALE_DATA"), uniqueId, currentCQVersion, versionFromProperties));
                    er.setNewExternalObjectState(newProperties);
                    throw er;
                }
                throw new InteropException(MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_JAZZ_DATA_CANNOT_HAVE_A_GREATER_VERSION_NUMBER"), uniqueId, currentCQVersion, versionFromProperties));
            }
            res.doStartAction(requestedPropertyNames, properties);
            boolean newValues = res.setObjectState(properties, true);
            if (newValues) {
                res.doWriteProperties(requestedPropertyNames);
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)("Updated  " + uniqueId + " using TeamAPI"));
                }
            } else {
                res.doRevert();
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)("Reverted  " + uniqueId + " using TeamAPI"));
                }
            }
            return res.createObjectState(requestedPropertyNames);
        }
        catch (InteropWvcmException e) {
            try {
                if (res == null) {
                    if (this.m_log.isDebugEnabled()) {
                        this.m_log.debug((Object)("Unable to Revert  " + uniqueId + " using TeamAPI"));
                    }
                    throw new InteropException(MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_REVERTING_NULL"), e.explicateException()));
                }
                res.doRevert();
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)("Reverted  " + uniqueId + " using TeamAPI"));
                }
            }
            catch (InteropWvcmException e2) {
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)("Unable to Revert  " + uniqueId + " using TeamAPI"));
                }
                throw new InteropException(MessageFormat.format(String.valueOf(Messages.getString("CQInteropEventHandler.ERROR_REVERTING")) + e2.explicateException(), e.explicateException()));
            }
            ERException er = new ERException(e.explicateException());
            if (e.writeFailedException()) {
                er.setDeferred(true);
            }
            throw er;
        }
    }

    public void handleDeleteEvent(String typeName, InteropLocation uniqueId) throws InteropException {
        try {
            ICqLocation locator = (ICqLocation)uniqueId;
            if (this.m_log.isDebugEnabled() && !typeName.equals("JazzConnectorChangeEvents")) {
                this.m_log.debug((Object)("Deleting  " + uniqueId + " using TeamAPI"));
            }
            if (this.m_logDetails.isDebugEnabled()) {
                this.m_logDetails.debug((Object)("Deleting  " + uniqueId + " using TeamAPI"));
            }
            ICqObject currentRecord = CqGatewayConstants.objectFactory.createCQObject((InteropLocation)locator, typeName, this.m_provider);
            currentRecord.doDelete();
            currentRecord.rememberDelete(this.m_repo.getDeletedAttachmentIds(), locator.getExternalLocationString());
            if (this.m_log.isDebugEnabled() && !typeName.equals("JazzConnectorChangeEvents")) {
                this.m_log.debug((Object)("Deleted  " + uniqueId + " using TeamAPI"));
            }
            if (this.m_logDetails.isDebugEnabled()) {
                this.m_logDetails.debug((Object)("Deleted  " + uniqueId + " using TeamAPI"));
            }
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_DELETING"), uniqueId), (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    public void retrieve(String typeName, String fileName, InteropLocation uniqueId) throws ERException, InteropException {
        try {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Retrieving content of " + uniqueId + " using TeamAPI"));
            }
            ICqObject currentRecord = CqGatewayConstants.objectFactory.lookup((InteropLocation)((ICqLocation)uniqueId), new ArrayList(), typeName, this.m_provider);
            currentRecord.doReadContentOnly(fileName);
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Retrieved content of" + uniqueId + " using TeamAPI"));
            }
        }
        catch (InteropWvcmException e) {
            if (e.conflictException()) {
                throw e;
            }
            ERException er = new ERException(e.explicateException());
            if (e.readFailedException()) {
                er.setDeferred(true);
            }
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_RETRIEVING_CONTENT_WITH_UNIQUE_ID"), uniqueId), (Throwable)er);
            }
            throw er;
        }
        catch (InteropException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_RETRIEVING_CONTENT_WITH_UNIQUE_ID"), uniqueId), (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    public Map<String, ?> retrieve(String typeName, Collection<String> propertyNames, InteropLocation uniqueId) throws ERException, InteropException {
        try {
            ICqLocation locator = (ICqLocation)uniqueId;
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Retrieving  " + uniqueId + " using TeamAPI"));
            }
            ICqObject currentRecord = CqGatewayConstants.objectFactory.lookup((InteropLocation)locator, propertyNames, typeName, this.m_provider);
            Map state = currentRecord.createObjectState(propertyNames);
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Retrieved  " + uniqueId + " (" + state.get(CqGatewayConstants.VERSION_FIELD_NAME) + ") using TeamAPI"));
            }
            return state;
        }
        catch (InteropWvcmException e) {
            if (e.notFoundException()) {
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)(uniqueId + " not found using TeamAPI"));
                }
                return null;
            }
            if (e.conflictException()) {
                throw e;
            }
            ERException er = new ERException(e.explicateException());
            if (e.readFailedException()) {
                er.setDeferred(true);
            }
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_RETRIEVING_WITH_UNIQUE_ID"), uniqueId), (Throwable)er);
            }
            throw er;
        }
        catch (InteropException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_RETRIEVING_WITH_UNIQUE_ID"), uniqueId), (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    public Map<String, ?> retrieveUserByLoginId(String loginId) throws ERException, InteropException {
        ArrayList<String> userProperties = new ArrayList<String>();
        userProperties.add("email");
        userProperties.add("fullname");
        userProperties.add("login_name");
        return this.retrieveByUniqueProperty("users", userProperties, "login_name", loginId);
    }

    public Map<String, ?> retrieveByUniqueProperty(String typeName, Collection<String> requestedProperties, String propertyName, String value) throws InteropException, ERException {
        try {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Retrieving  " + typeName + " with " + propertyName + " = " + value + " using TeamAPI"));
            }
            ICqRecordType cqType = this.m_repo.getCqRecordTypeInfo(typeName);
            InteropLocation location = CqGatewayConstants.objectFactory.createNewUserFriendlyLocation(cqType, value);
            ICqObject currentRecord = CqGatewayConstants.objectFactory.createCQObject(location, typeName, this.m_provider);
            currentRecord.doReadProperties(requestedProperties);
            Map state = currentRecord.createObjectState(requestedProperties);
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug((Object)("Retrieved  " + URLDecoder.decode((String)state.get("@@uniqueId@@"), "UTF-8") + " using TeamAPI"));
            }
            return state;
        }
        catch (InteropWvcmException e) {
            if (e.notFoundException()) {
                if (this.m_log.isDebugEnabled()) {
                    this.m_log.debug((Object)"Not found");
                }
                return null;
            }
            ERException er = new ERException(e.explicateException());
            if (e.readFailedException()) {
                er.setDeferred(true);
            }
            throw er;
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_LOOKUP"), typeName, propertyName, value), (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    public ICqQuery createCqQuery(String typeName, String queryPath) throws InteropException {
        if (queryPath == null || queryPath.equals(CQInteropConstants.EMPTY_STRING)) {
            queryPath = "DUMMY";
        }
        return CqGatewayConstants.objectFactory.createCqQuery(typeName, queryPath, this.m_repo.getConnectionURI(), this.m_provider);
    }

    public ICqQuery lookupCqQuery(String queryPath) throws InteropException {
        return CqGatewayConstants.objectFactory.lookupCqQuery(queryPath, this.m_repo.getConnectionURI(), this.m_provider);
    }

    public Iterator executeQuery(String typeName, ICqQuery query) throws InteropException {
        ICqRecordType cqRecordType = this.m_repo.getCqRecordTypeInfo(typeName);
        return cqRecordType.doQuery(query, 1L, Long.MAX_VALUE, false);
    }

    public void releaseIterator(Iterator resultSet) {
        ICqResultSet cqResultSet = this.m_provider.getCqResultSet(resultSet);
        cqResultSet.release();
    }

    public long getRowCount(Iterator resultSet) {
        ICqResultSet cqResultSet = this.m_provider.getCqResultSet(resultSet);
        return cqResultSet.getRowCount();
    }

    public Map<String, ?> createRecordFromResultSet(String typeName, List<String> fieldNames, Iterator resultSet, ICqQuery query) throws InteropException {
        ICqRecordType cqRecordType = this.m_repo.getCqRecordTypeInfo(typeName);
        ICqObject cqObject = cqRecordType.createObjectFromResultSet(resultSet, query);
        if (cqObject != null) {
            cqObject.doReadProperties(fieldNames);
            return cqObject.createObjectState(fieldNames);
        }
        return null;
    }

    public ICqRowData getNextRowData(String typeName, Iterator resultSet) throws InteropException {
        ICqRecordType cqRecordType = this.m_repo.getCqRecordTypeInfo(typeName);
        return cqRecordType.getNextRowData(resultSet);
    }

    public List<ICqExportData> createExportDataFromRowData(String typeName, ICqRowData cqRowData, ICqQuery query) throws InteropException {
        ICqRecordType cqRecordType = this.m_repo.getCqRecordTypeInfo(typeName);
        return cqRecordType.createExportDataFromRowData(cqRowData, query);
    }

    public List<ICqExportData> createExportDataFromResultSet(String typeName, Iterator resultSet, ICqQuery query) throws InteropException {
        ICqRecordType cqRecordType = this.m_repo.getCqRecordTypeInfo(typeName);
        return cqRecordType.createExportDataFromResultSet(resultSet, query);
    }

    public List<Map<String, Object>> retrieveAsMaps(String typeName, List<String> fieldNames, List<String> fieldNamesSortOrder, String queryPath) throws InteropException, ERException {
        try {
            ICqQuery query = CqGatewayConstants.objectFactory.createCqQuery(typeName, "DUMMY", this.m_repo.getConnectionURI(), this.m_provider);
            query.setDisplayFields(fieldNames, fieldNamesSortOrder);
            return this.retrieveAsMaps(typeName, query);
        }
        catch (InteropWvcmException e) {
            ERException er = new ERException(e.explicateException());
            if (e.writeFailedException()) {
                er.setDeferred(true);
            }
            throw er;
        }
        catch (InteropException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_EXECUTING_NAMED_QUERY"), queryPath), (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    public List<Map<String, Object>> retrieveAsMaps(String typeName, ICqQuery query) throws InteropException, ERException {
        try {
            ICqRecordType cqRecordType = this.m_repo.getCqRecordTypeInfo(typeName);
            Iterator resultSet = cqRecordType.doQuery(query, 1L, Long.MAX_VALUE, true);
            return cqRecordType.createMapsFromResultSet(resultSet, query.getFieldNameList());
        }
        catch (InteropWvcmException e) {
            ERException er = new ERException(e.explicateException());
            if (e.writeFailedException()) {
                er.setDeferred(true);
            }
            throw er;
        }
        catch (InteropException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.error((Object)MessageFormat.format(Messages.getString("CQInteropEventHandler.ERROR_EXECUTING_QUERY"), query.getDelegate()), (Throwable)e);
            }
            throw new InteropException((Throwable)e);
        }
    }

    private List<ICqFieldDefinition> buildFieldDefList(String typeName, List<String> fieldNames) throws InteropException {
        ICqRecordType cqRecordType = this.m_repo.getCqRecordTypeInfo(typeName);
        if (fieldNames == null) {
            return null;
        }
        if (cqRecordType.getIsStateless()) {
            if (!fieldNames.contains("dbid")) {
                fieldNames.add("dbid");
            }
        } else if (!fieldNames.contains("id")) {
            fieldNames.add("id");
        }
        return cqRecordType.getFieldDefinitionsForFieldNames(fieldNames);
    }

    private ICqQuery getPollingQuery() throws InteropException {
        if (pollingQuery == null) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            fieldNames.add("entity_dbid");
            fieldNames.add("entity_display_name");
            fieldNames.add("version_number");
            fieldNames.add("entity_record_type");
            fieldNames.add("field_values");
            fieldNames.add("dbid");
            fieldNames.add("modifiedBy");
            fieldNames.add("full_state_included");
            fieldNames.add("jazz_ProjectArea_id");
            ArrayList<String> fieldNamesSortOrder = new ArrayList<String>();
            fieldNamesSortOrder.add("entity_dbid");
            fieldNamesSortOrder.add("version_number");
            pollingQuery = CqGatewayConstants.objectFactory.createCqQuery("JazzConnectorChangeEvents", "DUMMY", this.m_repo.getConnectionURI(), this.m_provider);
            pollingQuery.setDisplayFields(fieldNames, fieldNamesSortOrder);
        }
        return pollingQuery;
    }

    public List<ChangeRecord> retrieveChangeRecords() throws InteropException, ERException {
        List<Map<String, Object>> recordList = this.retrieveAsMaps("JazzConnectorChangeEvents", this.getPollingQuery());
        ArrayList<ChangeRecord> changeRecords = new ArrayList<ChangeRecord>();
        for (Map<String, Object> recordMap : recordList) {
            Iterator<Map.Entry<String, Object>> entryIter = recordMap.entrySet().iterator();
            ChangeRecord changeRecord = new ChangeRecord();
            while (entryIter.hasNext()) {
                try {
                    Map.Entry<String, Object> entry = entryIter.next();
                    String fieldName = entry.getKey();
                    Object fieldValue = entry.getValue();
                    changeRecord.setProperty(fieldName, fieldValue);
                }
                catch (Exception e) {
                    this.m_log.error((Object)Messages.getString("CQInteropEventHandler.ERROR_SKIPPED_RECORD"), (Throwable)e);
                }
            }
            changeRecords.add(changeRecord);
        }
        return changeRecords;
    }

    public List<Map<String, Object>> retrieveJazzConnectorQueryRecords(String recordType, String projectAreaId) throws InteropException, ERException {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("entityRecordType");
        fieldNames.add("jazz_ProjectArea_id");
        fieldNames.add("query_dbid");
        ArrayList<String> fieldNamesSortOrder = new ArrayList<String>();
        fieldNamesSortOrder.add("entityRecordType");
        this.buildFieldDefList("JazzConnectorQueryInfo", fieldNames);
        ArrayList<CqFilterCriteria> filterList = new ArrayList<CqFilterCriteria>();
        CqFilterCriteria filterCriteria1 = new CqFilterCriteria();
        filterCriteria1.setFieldName("entityRecordType");
        filterCriteria1.setOperator("EQUALS");
        filterCriteria1.setFieldValue(recordType);
        filterList.add(filterCriteria1);
        if (projectAreaId != null) {
            CqFilterCriteria filterCriteria2 = new CqFilterCriteria();
            filterCriteria2.setFieldName("jazz_ProjectArea_id");
            filterCriteria2.setOperator("EQUALS");
            filterCriteria2.setFieldValue(projectAreaId);
            filterList.add(filterCriteria2);
        }
        ICqQuery query = CqGatewayConstants.objectFactory.createCqQuery("JazzConnectorQueryInfo", "DUMMY", this.m_repo.getConnectionURI(), this.m_provider);
        query.setDisplayFields(fieldNames, fieldNamesSortOrder);
        query.setFilter(filterList);
        List<Map<String, Object>> recordList = this.retrieveAsMaps("JazzConnectorQueryInfo", query);
        return recordList;
    }

    public List<Map<String, Object>> retrieveJazzSynchedHistory(String recordType, String recordDbid) throws InteropException, ERException {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("recordDbid");
        fieldNames.add("jazz_ProjectArea_id");
        fieldNames.add("entityRecordType");
        ArrayList<String> fieldNamesSortOrder = new ArrayList<String>();
        fieldNamesSortOrder.add("recordDbid");
        fieldNamesSortOrder.add("jazz_ProjectArea_id");
        ArrayList<CqFilterCriteria> filterList = new ArrayList<CqFilterCriteria>();
        CqFilterCriteria filterCriteria1 = new CqFilterCriteria();
        filterCriteria1.setFieldName("entityRecordType");
        filterCriteria1.setOperator("EQUALS");
        filterCriteria1.setFieldValue(recordType);
        filterList.add(filterCriteria1);
        if (recordDbid != null) {
            CqFilterCriteria filterCriteria2 = new CqFilterCriteria();
            filterCriteria2.setFieldName("recordDbid");
            filterCriteria2.setOperator("EQUALS");
            filterCriteria2.setFieldValue(recordDbid);
            filterList.add(filterCriteria2);
        }
        ICqQuery query = CqGatewayConstants.objectFactory.createCqQuery("JazzConnectorSyncHistory", "DUMMY", this.m_repo.getConnectionURI(), this.m_provider);
        query.setDisplayFields(fieldNames, fieldNamesSortOrder);
        query.setFilter(filterList);
        List<Map<String, Object>> recordList = this.retrieveAsMaps("JazzConnectorSyncHistory", query);
        return recordList;
    }

    private ICqFieldDefinition getFieldDef(String name, List<ICqFieldDefinition> fieldDefList) throws InteropException {
        for (ICqFieldDefinition cqFieldDefinition : fieldDefList) {
            if (!name.equals(cqFieldDefinition.getName())) continue;
            return cqFieldDefinition;
        }
        return null;
    }

    public ICqRecordType getRecordTypeInfo(String typeName) throws InteropException {
        return this.m_repo.getCqRecordTypeInfo(typeName);
    }

    public String handlerIdentity() {
        return "CQ@" + this.m_repo.getConnectionURI();
    }

    public ICqProvider getImplementation() {
        return this.m_provider;
    }

    public boolean usable() {
        return this.m_provider.usable();
    }

    public synchronized void inUse() throws InteropException {
        if (this.m_logDetails.isDebugEnabled()) {
            this.m_logDetails.debug((Object)("Using " + this));
        }
        this.m_inUse = true;
    }

    public synchronized boolean available() {
        return !this.m_inUse;
    }

    public synchronized void release() throws InteropException {
        this.release(false);
    }

    public synchronized void release(boolean terminate) throws InteropException {
        if (this.m_logDetails.isDebugEnabled()) {
            this.m_logDetails.debug((Object)("Releasing " + this));
        }
        this.m_inUse = false;
        if (this.m_threadInfo.equals("new") || terminate) {
            if (this.m_logDetails.isDebugEnabled()) {
                this.m_logDetails.debug((Object)("Closing " + this));
            }
            this.m_repo.anotherConnectionClosed();
            this.m_provider.terminate();
        }
    }

    public void clearCache() throws InteropException {
        this.m_provider.clearCache();
    }

    public String getURI() {
        return this.m_repo.getConnectionURI();
    }

    public List<String> getPrivateDataProperties() {
        return this.m_privateDataProperties;
    }

    public String getThreadInfo() {
        return this.m_threadInfo;
    }

    public void close() throws InteropException {
        this.m_provider.terminate();
    }
}

