/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.connector.cq.common.cqgateway;

import com.ibm.rational.connector.cq.common.cqgateway.CQInteropEventHandler;
import com.ibm.rational.connector.cq.common.cqgateway.CQRepository;
import com.ibm.rational.connector.cq.common.cqgateway.ChangeRecord;
import com.ibm.rational.connector.cq.common.cqgateway.CqObjectFactory;
import com.ibm.rational.connector.cq.common.cqgateway.Messages;
import com.ibm.rational.connector.cq.teamapi.common.ICqExportData;
import com.ibm.rational.connector.cq.teamapi.common.ICqQuery;
import com.ibm.rational.connector.cq.teamapi.common.ICqRecordType;
import com.ibm.rational.connector.cq.teamapi.common.ICqRowData;
import com.ibm.rational.connector.cq.teamapi.common.internal.BasicCQConnectionInfo;
import com.ibm.rational.connector.cq.teamapi.common.internal.CqGatewayConstants;
import com.ibm.rational.connector.cq.teamapi.common.internal.InteropProperties;
import com.ibm.rational.connector.cq.teamapi.common.internal.LogFactory;
import com.ibm.team.interop.service.managers.clearquest.common.CQInteropConstants;
import com.ibm.team.interop.service.managers.clearquest.common.ERException;
import com.ibm.team.interop.service.managers.clearquest.common.InteropConnectionInfo;
import com.ibm.team.interop.service.managers.clearquest.common.InteropException;
import com.ibm.team.interop.service.managers.clearquest.common.InteropGateway;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CQGateway
implements InteropGateway {
    private Map<String, CQRepository> repositories = new HashMap<String, CQRepository>();
    private InteropConnectionInfo m_connectionInfo;
    private CQRepository defaultRepository = null;
    private List<String> m_deletedAttachmentIds = new ArrayList<String>();
    private Log m_logDetails = LogFactory.getLog((int)2);
    private static CQGateway singleton = null;

    public CQGateway() {
        CqGatewayConstants.objectFactory = new CqObjectFactory();
    }

    public static CQGateway getCQGateway() {
        if (singleton == null) {
            singleton = new CQGateway();
        }
        return singleton;
    }

    public static CQGateway getNewCQGateway() {
        if (singleton != null) {
            singleton.close();
        }
        singleton = new CQGateway();
        return singleton;
    }

    public void connectToRepository(String userId, String password, String url) throws InteropException {
        if (!this.lookupRepoForURL(url)) {
            BasicCQConnectionInfo newConnection = new BasicCQConnectionInfo();
            newConnection.setConnectionURI(url);
            InteropProperties currentProperties = InteropProperties.getCurrentInteropProperties();
            newConnection.setUserId(userId != null ? userId : (String)currentProperties.getConfigValue("cq.userid"));
            newConnection.setPassword(password != null ? password : (String)currentProperties.getConfigValue("cq.password"));
            this.connectToRepositoryLocal((InteropConnectionInfo)newConnection);
        }
    }

    public void connectToRepositoryLocal(InteropConnectionInfo connectionInfo) throws InteropException {
        this.m_connectionInfo = connectionInfo;
        String url = this.m_connectionInfo.getConnectionURI();
        if (!this.lookupRepoForURL(url)) {
            CQRepository repo = new CQRepository(this.m_connectionInfo, this);
            this.repositories.put(url, repo);
        }
    }

    public Map<String, ?> create(String typeName, Map<String, Object> properties, List<String> requestedPropertyNames, String uniqueId, String source, String url) throws InteropException, ERException {
        CQInteropEventHandler handler = null;
        try {
            Map<String, ?> returnedState;
            handler = this.getHandler(url);
            ICqRecordType cqType = handler.getRecordTypeInfo(typeName);
            Map<String, ?> map = returnedState = handler.handleCreateEvent(typeName, properties, CqGatewayConstants.objectFactory.createNewUserFriendlyLocation(cqType, "new"), requestedPropertyNames, source);
            return map;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public Map<String, ?> update(String typeName, Map<String, Object> properties, List<String> requestedPropertyNames, String source, String uniqueId, String url, Boolean fullState) throws InteropException, ERException {
        CQInteropEventHandler handler = null;
        try {
            Map<String, ?> returnedState;
            handler = this.getHandler(url, true);
            Map<String, ?> map = returnedState = handler.handleUpdateEvent(typeName, properties, requestedPropertyNames, source, CqGatewayConstants.objectFactory.createLocator(uniqueId));
            return map;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public Map<String, ?> update(String typeName, Map<String, Object> properties, List<String> requestedPropertyNames, String source, String uniqueId, String url) throws InteropException, ERException {
        return this.update(typeName, properties, requestedPropertyNames, source, uniqueId, url, true);
    }

    public Object[] getSupportedTypeInfo(String url) throws InteropException {
        return this.getSupportedTypeInfo(url, false);
    }

    public Object[] getSupportedTypeInfo(String url, boolean clearCache) throws InteropException {
        CQRepository repo = this.getRepoForURL(url);
        if (clearCache) {
            repo.clearCachedInfo();
        }
        if (repo == null) {
            throw new InteropException(MessageFormat.format(Messages.getString("CQGateway.ERROR_NO_REPOSITORY_WITH_URI"), url));
        }
        Object[] rawTypes = repo.getRecordTypeInfo().values().toArray();
        ArrayList<ICqRecordType> syncableRecordTypes = new ArrayList<ICqRecordType>();
        int i = 0;
        while (i < rawTypes.length) {
            ICqRecordType rt = (ICqRecordType)rawTypes[i];
            if (rt.determineIfSyncableRecordType() || rt.syncableByDefault()) {
                syncableRecordTypes.add(rt);
            }
            ++i;
        }
        return syncableRecordTypes.toArray();
    }

    public ICqQuery createQuery(String typeName, String queryPath, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            ICqQuery iCqQuery = handler.createCqQuery(typeName, queryPath);
            return iCqQuery;
        }
        catch (InteropException e) {
            throw e;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public ICqQuery lookupQuery(String queryPath, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            ICqQuery iCqQuery = handler.lookupCqQuery(queryPath);
            return iCqQuery;
        }
        catch (InteropException e) {
            throw e;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public Iterator executeQuery(String typeName, ICqQuery query, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            Iterator iterator = handler.executeQuery(typeName, query);
            return iterator;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public void releaseIterator(Iterator resultSet, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            handler.releaseIterator(resultSet);
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public long getRowCount(Iterator resultSet, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            long l = handler.getRowCount(resultSet);
            return l;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public Map<String, ?> createObjectFromResultSet(String typeName, Iterator resultSet, ICqQuery query, List<String> fieldNames, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            Map<String, ?> map = handler.createRecordFromResultSet(typeName, fieldNames, resultSet, query);
            return map;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public ICqRowData getNextRowData(String typeName, Iterator resultSet, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            ICqRowData iCqRowData = handler.getNextRowData(typeName, resultSet);
            return iCqRowData;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public List<ICqExportData> createExportDataFromRowData(String typeName, ICqRowData cqRowData, ICqQuery query, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            List<ICqExportData> list = handler.createExportDataFromRowData(typeName, cqRowData, query);
            return list;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public List<ICqExportData> createExportDataFromResultSet(String typeName, Iterator resultSet, ICqQuery query, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            List<ICqExportData> list = handler.createExportDataFromResultSet(typeName, resultSet, query);
            return list;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public void clearCache(String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            handler.clearCache();
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public Map<String, ?> retrieve(String typeName, Collection<String> propertyNames, String uniqueId, String url) throws ERException, InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url, true);
            Map<String, ?> map = handler.retrieve(typeName, propertyNames, CqGatewayConstants.objectFactory.createLocator(uniqueId));
            return map;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public Map<String, ?> retrieveByUniqueProperty(String typeName, Collection<String> requestedPropertyNames, String propertyName, String value, String url) throws ERException, InteropException {
        CQInteropEventHandler handler = null;
        try {
            Map<String, ?> returnedState;
            handler = this.getHandler(url, true);
            Map<String, ?> map = returnedState = handler.retrieveByUniqueProperty(typeName, requestedPropertyNames, propertyName, value);
            return map;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public Map<String, ?> retrieveUserByLoginId(String loginId, String url) throws ERException, InteropException {
        CQInteropEventHandler handler = null;
        try {
            Map<String, ?> returnedState;
            handler = this.getHandler(url);
            Map<String, ?> map = returnedState = handler.retrieveUserByLoginId(loginId);
            return map;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public List<Map<String, Object>> retrieveJazzConnectorQueryRecords(String recordType, String projectAreaId, String url) throws ERException, InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            List<Map<String, Object>> list = handler.retrieveJazzConnectorQueryRecords(recordType, projectAreaId);
            return list;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public List<Map<String, Object>> retrieveJazzSynchedHistory(String recordType, String recordDbid, String url) throws ERException, InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            List<Map<String, Object>> list = handler.retrieveJazzSynchedHistory(recordType, recordDbid);
            return list;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public boolean isCQRecordType(String typeName, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            try {
                handler.getRecordTypeInfo(typeName);
            }
            catch (InteropException interopException) {
                boolean bl = Boolean.FALSE;
                if (handler != null) {
                    this.releaseHandler(handler);
                }
                return bl;
            }
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
        return Boolean.TRUE;
    }

    public List<ChangeRecord> runPollingQuery(String url) throws ERException, InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            List<ChangeRecord> list = handler.retrieveChangeRecords();
            return list;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public String getQueryPrimaryRecordType(String url, String queryPath) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            String string = handler.getQueryPrimaryRecordType(queryPath);
            return string;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public boolean isQueryPathValid(String url, String queryPath) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            boolean bl = handler.isQueryPathValid(queryPath);
            return bl;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public void delete(String typeName, String uniqueId, String url) throws InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(url);
            handler.handleDeleteEvent(typeName, CqGatewayConstants.objectFactory.createLocator(uniqueId));
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public String storeContent(String uniqueId, String fieldName, Map<String, Object> properties, String repositoryURI, String projectAreaId) throws InteropException, ERException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(repositoryURI);
            Map<String, ?> newState = handler.handleCreateEvent("attachments", properties, CqGatewayConstants.objectFactory.createLocator(uniqueId), null, projectAreaId);
            String string = (String)newState.get("@@uniqueId@@");
            return string;
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public String storeContent(String uniqueId, String fieldName, Map<String, Object> properties, String repositoryURI) throws InteropException, ERException {
        return this.storeContent(uniqueId, fieldName, properties, repositoryURI, null);
    }

    public void getContent(String fileName, String uniqueId, String repositoryURI) throws ERException, InteropException {
        CQInteropEventHandler handler = null;
        try {
            handler = this.getHandler(repositoryURI);
            handler.retrieve("attachments", fileName, CqGatewayConstants.objectFactory.createLocator(uniqueId));
        }
        finally {
            if (handler != null) {
                this.releaseHandler(handler);
            }
        }
    }

    public void releaseHandler(CQInteropEventHandler handler) throws InteropException {
        CQRepository repo = this.getRepoForURL(handler.getURI());
        repo.releaseHandler(handler);
    }

    private CQInteropEventHandler getHandler(String url) throws InteropException {
        CQRepository repo = this.getRepoForURL(url);
        return repo.getHandler(false);
    }

    public CQInteropEventHandler getHandler(String url, boolean useFreshHandler) throws InteropException {
        CQRepository repo = this.getRepoForURL(url);
        return repo.getHandler(useFreshHandler);
    }

    public boolean parallelismSupportedInDb(String uri) throws InteropException {
        CQRepository repo = this.getRepoForURL(uri);
        return repo.parallelismSupportedInDb();
    }

    public Object getConnection(String dbName, boolean fresh) throws InteropException {
        return this.getHandler(dbName, fresh);
    }

    public CQRepository getDefaultRepository() {
        if (this.defaultRepository == null) {
            Collection<CQRepository> repos = this.repositories.values();
            if (repos.size() == 1) {
                this.defaultRepository = repos.iterator().next();
            } else {
                if (repos.size() == 0) {
                    throw new RuntimeException(Messages.getString("CQGateway.ERROR_NO_DEFAULT_CQ_DB"));
                }
                throw new RuntimeException(Messages.getString("CQGateway.ERROR_ONE_CQ_DB_PER_GATEWAY"));
            }
        }
        return this.defaultRepository;
    }

    public String getDefaultRepositoryURL() {
        return this.getDefaultRepository().getConnectionURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CQGateway cQGateway = singleton;
        synchronized (cQGateway) {
            for (CQRepository repo : this.repositories.values()) {
                try {
                    repo.close();
                }
                catch (Exception exception) {
                    if (!this.m_logDetails.isDebugEnabled()) continue;
                    this.m_logDetails.debug((Object)"ignoring close exception");
                }
            }
            this.repositories = new HashMap<String, CQRepository>();
            this.defaultRepository = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CQRepository getRepoForURL(String url) throws InteropException {
        CQGateway cQGateway = singleton;
        synchronized (cQGateway) {
            CQRepository repo = null;
            repo = url == null || url.equals(CQInteropConstants.EMPTY_STRING) ? this.getDefaultRepository() : this.repositories.get(url);
            if (repo == null) {
                throw new InteropException(MessageFormat.format(Messages.getString("CQGateway.ERROR_NO_CQ_DB_WITH_THIS_URL"), url));
            }
            if (!repo.usable()) {
                block12: {
                    if (this.m_logDetails.isDebugEnabled()) {
                        this.m_logDetails.debug((Object)"The CQRepository has become unusable. Allocating a new one");
                    }
                    try {
                        repo.close();
                        this.repositories.remove(url);
                    }
                    catch (Exception exception) {
                        if (!this.m_logDetails.isDebugEnabled()) break block12;
                        this.m_logDetails.debug((Object)"ignoring close exception");
                    }
                }
                if (repo == this.defaultRepository) {
                    this.defaultRepository = null;
                }
                try {
                    if (this.m_logDetails.isInfoEnabled()) {
                        this.m_logDetails.info((Object)Messages.getString("CQGateway.INFO_RESETTING_DB_CONNECTION"));
                    }
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {}
                repo = new CQRepository(this.m_connectionInfo, this);
                this.repositories.put(url, repo);
            }
            return repo;
        }
    }

    private boolean lookupRepoForURL(String url) throws InteropException {
        if (url == null || url.equals(CQInteropConstants.EMPTY_STRING)) {
            return this.getDefaultRepository() != null;
        }
        return this.repositories.get(url) != null;
    }

    public List<String> getDeletedAttachmentIds() {
        return this.m_deletedAttachmentIds;
    }
}

