/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation.
 * All rights reserved. 
 *******************************************************************************/

function resizeAtPageLoad() {

  imgw = new Array();
  imgh = new Array();
  neww = new Array();
  newh = new Array();
  mapn = new Array();

  for (i=0;i<document.images.length;i++) {
      imgw[i]=document.images[i].width;
      imgh[i]=document.images[i].height;
      mapn[i]=document.images[i].useMap;
  }

  areacoords = new Array();
  areaelems = new Array();
  if (document.getElementsByTagName) {
     areaelems = document.getElementsByTagName("area");
  } else if (document.all) {
     areaelems = document.all.tags("area");
  }

  for (i=0;i<areaelems.length;i++) {
       areacoords[i]=areaelems[i].coords;
  }

  for (i=0;i<document.images.length;i++) {
      resize(i);
  }

  for (i=0;i<areaelems.length;i++) {
        rescale(i);
  }
}

function resizeAllImages() {
    for (i=0;i<document.images.length;i++) {
        resize(i);
    }

    for (i=0;i<areaelems.length;i++) {
        rescale(i);
    }
}

function resize(j) {
    var inTable = 0;
    var co=document.images[j];
    while (co.parentNode) {
        if (co.nodeName.toLowerCase() == 'table') {
            inTable=1;
        }
        co = co.parentNode;
    }

    if (inTable == 0) {
        
        var w = imgw[j];
        var h = imgh[j];
        
            if (document.images[j].offsetLeft != null) {
                var ix=0;
                var o=document.images[j];
                while (o != null) {
                    ix += o.offsetLeft;
                    o = o.offsetParent;
                } 
            } else if (document.images[j].x != null) {
                var ix=document.images[j].x;
            }

            if (window.innerWidth == null) {
                var iw = document.body.clientWidth;
                var ih = document.body.clientHeight; 
            } else {
                var iw = window.innerWidth;
                var ih = window.innerHeight;
            }
            
            if (((w+ix) > iw) || (h > ih)) {
                if (ih/h >= iw/w) {
                    var nw = iw-25-ix;
                    var nh=h*(nw/w);
                } else {
                    var nh=ih-25;
                    var nw=w*(nh/h);
                }
            } else {
                var nw=w;
                var nh=h;
            }

            document.images[j].width=nw;
		    neww[j]=nw;
            document.images[j].height=nh;
		    newh[j]=nh;
    }
}

function rescale(j) {

  var currCoords = new Array();
  currCoords = areacoords[j].split(",");
  for (var l=0;l<currCoords.length;l++) {
    currCoords[l] = parseInt(currCoords[l]);
  }
  
  var thisMap = areaelems[j].parentNode.name;

  for (var m=0;m<document.images.length;m++) {
    if (document.images[m].useMap.substring(1) == thisMap) {
       for (var k=0;k<currCoords.length;k++) {
           currCoords[k] = (parseInt(currCoords[k]*(neww[m]/imgw[m]))).toString();
       }
	   areaelems[j].coords = currCoords.join(",");
    }
  }
}