/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.internal.brochures.loader;

import com.ibm.ccl.welcome.internal.brochures.loader.Brochure;
import com.ibm.ccl.welcome.internal.brochures.loader.BrochureBuilder;
import com.ibm.ccl.welcome.internal.brochures.loader.Page;
import java.util.Iterator;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class BrochureManager {
    public static BrochureManager brochureManager = new BrochureManager();
    private Vector brochures = new Vector();
    private Vector incompleteBrochures = new Vector();

    private BrochureManager() {
    }

    public Brochure findBrochure(String brochureId) {
        int i = 0;
        while (i < this.brochures.size()) {
            Brochure broc = (Brochure)this.brochures.get(i);
            if (broc.getId().equalsIgnoreCase(brochureId)) {
                return broc;
            }
            ++i;
        }
        return null;
    }

    protected boolean addBrochure(Document dom, Bundle bundle) {
        BrochureBuilder builder = new BrochureBuilder();
        Brochure brochure = builder.buildBrochure(dom, bundle);
        if (brochure == null) {
            return false;
        }
        if (this.brochures.contains(brochure) || !brochure.isComplete()) {
            this.incompleteBrochures.add(brochure);
            return false;
        }
        this.brochures.add(brochure);
        return true;
    }

    protected int resolveReplacements() {
        if (this.incompleteBrochures.isEmpty()) {
            return 0;
        }
        Vector incompleteBrochures = new Vector();
        int numIncomplete = this.incompleteBrochures.size();
        int updatedNumIncomplete = 0;
        while (updatedNumIncomplete < numIncomplete) {
            numIncomplete = this.incompleteBrochures.size();
            incompleteBrochures.addAll(this.incompleteBrochures);
            Iterator it = incompleteBrochures.iterator();
            Brochure replacement = null;
            while (it.hasNext()) {
                replacement = (Brochure)it.next();
                this.replaceBrochure(replacement);
            }
            updatedNumIncomplete = this.incompleteBrochures.size();
            incompleteBrochures.removeAllElements();
        }
        return this.incompleteBrochures.size();
    }

    private boolean replaceBrochure(Brochure replacement) {
        Brochure existingBrochure = this.findBrochure(replacement.getId());
        Page page = null;
        int i = 0;
        while (i < replacement.numberOfPages()) {
            page = replacement.page(i);
            if (existingBrochure.containsPage(page.getId())) {
                replacement.replacePage(i, existingBrochure.getPage(page.getId()));
            } else if (page.getIcon().length() == 0) {
                return false;
            }
            ++i;
        }
        replacement.setComplete(true);
        this.incompleteBrochures.remove(replacement);
        this.brochures.remove(existingBrochure);
        return this.brochures.add(replacement);
    }

    protected void removeAll() {
        this.brochures = new Vector();
        this.incompleteBrochures = new Vector();
    }
}

