/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.internal.brochures.loader;

import com.ibm.ccl.welcome.internal.brochures.loader.Brochure;
import com.ibm.ccl.welcome.internal.util.BundleUtil;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BrochureBuilder {
    private static final String TAG_PAGE = "page";
    private static final String ATT_ID = "id";
    private static final String ATT_TITLE = "title";
    private static final String ATT_ICON = "icon";
    private Bundle bundle;

    protected Brochure buildBrochure(Document dom, Bundle bundle) {
        this.bundle = bundle;
        String brochureId = this.getBrochureId(dom);
        String brochureTitle = this.getBrochureTitle(dom);
        Element[] pages = this.getPages(dom);
        if (pages.length == 0) {
            return null;
        }
        return this.makeNewBrochure(brochureId, brochureTitle, pages);
    }

    protected Brochure makeNewBrochure(String brochureId, String brochureTitle, Element[] pages) {
        Brochure brochure = new Brochure(brochureId, brochureTitle);
        boolean complete = true;
        int i = 0;
        while (i < pages.length) {
            String pageId = pages[i].getAttribute(ATT_ID);
            String pageIcon = BundleUtil.getResolvedResourceLocation(pages[i].getAttribute(ATT_ICON), this.bundle);
            String pageTitle = pages[i].getAttribute(ATT_TITLE);
            if (pageIcon.length() == 0 || pageTitle.length() == 0) {
                complete = false;
            }
            brochure.addPage(pageId, pageIcon, pageTitle);
            ++i;
        }
        brochure.setComplete(complete);
        return brochure;
    }

    private Element[] getPages(Document dom) {
        return BrochureBuilder.getElementsByTagName(dom, TAG_PAGE);
    }

    private String getBrochureId(Document dom) {
        NodeList brochure = dom.getElementsByTagName("brochure");
        if (brochure.getLength() > 0) {
            Element e = (Element)brochure.item(0);
            return e.getAttribute(ATT_ID);
        }
        return null;
    }

    private String getBrochureTitle(Document dom) {
        NodeList brochure = dom.getElementsByTagName("brochure");
        if (brochure.getLength() > 0) {
            Element e = (Element)brochure.item(0);
            return e.getAttribute(ATT_TITLE);
        }
        return null;
    }

    private static Element[] getElementsByTagName(Document dom, String tagName) {
        NodeList allChildElements = dom.getElementsByTagName(tagName);
        Vector<Element> vector = new Vector<Element>();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Element aElement = (Element)allChildElements.item(i);
            if (aElement.getParentNode().equals(dom.getDocumentElement())) {
                vector.add(aElement);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        return filteredElements;
    }
}

