/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.bits.rss;

import com.ibm.ccl.welcome.bits.BitsPlugin;
import com.ibm.ccl.welcome.bits.rss.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RSSViewer
implements IIntroContentProvider {
    private final int SOCKET_TIMEOUT = 6000;
    private static final String INTRO_SHOW_IN_BROWSER = "http://org.eclipse.ui.intro/openBrowser?url=";
    private static final String HREF_BULLET = "bullet";
    private HashMap params;
    private IIntroContentProviderSite site;
    private boolean disposed;
    private String id;
    private List items;
    private Composite parent;
    private FormToolkit toolkit;
    private FormText formText;
    private Image bulletImage;
    private boolean threadRunning = false;
    private final int CREATE_THREAD_TIMEOUT = 10;

    public void init(IIntroContentProviderSite site) {
        this.site = site;
        this.refresh();
    }

    public void createContent(String id, PrintWriter out) {
        if (this.disposed) {
            return;
        }
        this.id = id;
        this.params = this.setParams(id);
        if (this.items == null) {
            this.createNewsItems();
        }
        if (this.items == null || this.threadRunning) {
            out.print("<p class=\"status-text\">");
            out.print(Properties.getString("loading"));
            out.println("</p>");
            return;
        }
        if (this.items.size() > 0) {
            out.println("<ul id=\"news-feed\">");
            int i = 0;
            while (i < this.items.size()) {
                NewsItem item = (NewsItem)this.items.get(i);
                out.print("<li>");
                out.print("<a class=\"topicList\" href=\"");
                out.print(this.createExternalURL(item.url));
                out.print("\">");
                out.print(item.label);
                out.print("</a>");
                out.print("</li>\n");
                ++i;
            }
            out.println("</ul>");
        } else {
            out.print("<p class=\"status-text\">");
            out.print(Properties.getString("no_news_please_visit"));
            out.print(" <a href=\"");
            out.print(this.createExternalURL(this.getParameter("no_news_url")));
            out.print("\">");
            out.print(this.getParameter("no_news_text"));
            out.print("</a>");
            out.println("</p>");
        }
        URL url = null;
        try {
            url = new URL(this.getParameter("url"));
        }
        catch (MalformedURLException e) {
            BitsPlugin.logError("Bad URL: " + url, e);
        }
        out.println("<p><span class=\"rss-feed-link\">");
        out.println("<a href=\"");
        out.println(this.createExternalURL(url.toString()));
        out.println("\">");
        out.println(Properties.getString("subscribe"));
        out.println("</a>");
        out.println("</span></p>");
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.disposed) {
            return;
        }
        this.id = id;
        this.params = this.setParams(id);
        if (this.formText == null) {
            this.formText = toolkit.createFormText(parent, true);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    RSSViewer.this.doNavigate((String)e.getHref());
                }
            });
            this.bulletImage = this.createImage((IPath)new Path("css/graphics/arrow.gif"));
            if (this.bulletImage != null) {
                this.formText.setImage(HREF_BULLET, this.bulletImage);
            }
            this.parent = parent;
            this.toolkit = toolkit;
            this.id = id;
            this.params = this.setParams(id);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<form>");
        if (this.items == null) {
            this.createNewsItems();
        }
        if (this.items == null || this.threadRunning) {
            buffer.append("<p>");
            buffer.append(Properties.getString("loading"));
            buffer.append("</p>");
        } else if (this.items.size() > 0) {
            int i = 0;
            while (i < this.items.size()) {
                NewsItem item = (NewsItem)this.items.get(i);
                buffer.append("<li style=\"image\" value=\"");
                buffer.append(HREF_BULLET);
                buffer.append("\">");
                buffer.append("<a href=\"");
                buffer.append(this.createExternalURL(item.url));
                buffer.append("\">");
                buffer.append(item.label);
                buffer.append("</a>");
                buffer.append("</li>");
                ++i;
            }
        } else {
            buffer.append("<p>");
            buffer.append(Properties.getString("no_news"));
            buffer.append("</p>");
        }
        buffer.append("</form>");
        this.formText.setText(buffer.toString(), true, false);
    }

    private String createExternalURL(String url) {
        return INTRO_SHOW_IN_BROWSER + URLEncoder.encode(url);
    }

    public void dispose() {
        if (this.bulletImage != null) {
            this.bulletImage.dispose();
            this.bulletImage = null;
        }
        this.disposed = true;
    }

    private void createNewsItems() {
        ContentThread contentThread = new ContentThread();
        contentThread.start();
        TimeoutThread timeThread = new TimeoutThread();
        timeThread.start();
    }

    public void refresh() {
        Thread newsWorker = new Thread(new NewsFeed());
        newsWorker.start();
    }

    private void reflow(Control initiator) {
        Control c = initiator;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        c = initiator;
        while (c != null) {
            if (c instanceof Composite) {
                ((Composite)c).layout(true);
            }
            if (!((c = c.getParent()) instanceof ScrolledForm)) continue;
            ((ScrolledForm)c).reflow(true);
            break;
        }
        c = initiator;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    private Image createImage(IPath path) {
        Bundle bundle = Platform.getBundle((String)"com.ibm.ccl.welcome.bits");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            url = FileLocator.toFileURL((URL)url);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void doNavigate(final String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)url);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
                RSSViewer.this.openBrowser(url);
            }
        });
    }

    private void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private HashMap setParams(String query) {
        HashMap<String, String> _params = new HashMap<String, String>();
        if (query != null && query.length() > 1) {
            String[] kvPairs = query.split("##");
            int i = 0;
            while (i < kvPairs.length) {
                String[] kv = kvPairs[i].split("=", 2);
                if (kv.length > 1) {
                    _params.put(kv[0], kv[1]);
                } else {
                    _params.put(kv[0], "");
                }
                ++i;
            }
        }
        return _params;
    }

    private String getParameter(String name) {
        return (String)this.params.get(name);
    }

    private class ContentThread
    extends Thread {
        private ContentThread() {
        }

        public void run() {
            block14: {
                RSSViewer.this.threadRunning = true;
                RSSViewer.this.items = Collections.synchronizedList(new ArrayList());
                InputStream in = null;
                try {
                    try {
                        BitsPlugin.logDebug("Open Connection: " + RSSViewer.this.getParameter("url"));
                        URL url = new URL(RSSViewer.this.getParameter("url"));
                        URLConnection conn = url.openConnection();
                        conn.setConnectTimeout(6000);
                        conn.connect();
                        in = url.openStream();
                        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                        parser.parse(in, (DefaultHandler)new RSSHandler());
                        RSSViewer.this.refresh();
                    }
                    catch (Exception exception) {
                        BitsPlugin.logError(NLS.bind((String)Properties.getString("malformed_feed"), (Object)RSSViewer.this.getParameter("url")));
                        RSSViewer.this.refresh();
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException iOException) {}
                        RSSViewer.this.threadRunning = false;
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    RSSViewer.this.threadRunning = false;
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
                RSSViewer.this.threadRunning = false;
            }
        }
    }

    class NewsFeed
    implements Runnable {
        NewsFeed() {
        }

        public void run() {
            if (RSSViewer.this.disposed) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (RSSViewer.this.parent != null) {
                        RSSViewer.this.createContent(RSSViewer.this.id, RSSViewer.this.parent, RSSViewer.this.toolkit);
                    }
                    RSSViewer.this.site.reflow((IIntroContentProvider)RSSViewer.this, true);
                }
            });
        }
    }

    static class NewsItem {
        String label;
        String url;

        NewsItem() {
        }

        void setLabel(String label) {
            this.label = label;
        }

        void setUrl(String url) {
            this.url = url;
        }
    }

    private class RSSHandler
    extends DefaultHandler {
        private static final String ELEMENT_RSS = "rss";
        private static final String ELEMENT_CHANNEL = "channel";
        private static final String ELEMENT_ITEM = "item";
        private static final String ELEMENT_TITLE = "title";
        private static final String ELEMENT_LINK = "link";
        private Stack stack = new Stack();
        private StringBuffer buf;
        private NewsItem item;

        private RSSHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.stack.push(qName);
            if ((ELEMENT_TITLE.equals(qName) || ELEMENT_LINK.equals(qName)) && this.item != null) {
                this.buf = new StringBuffer();
            } else if (ELEMENT_ITEM.equals(qName) && ELEMENT_CHANNEL.equals(this.stack.get(1)) && ELEMENT_RSS.equals(this.stack.get(0)) && this.stack.size() == 3 && RSSViewer.this.items.size() < Integer.parseInt(RSSViewer.this.getParameter("welcome_items"))) {
                this.item = new NewsItem();
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.stack.pop();
            if (this.item != null) {
                if (this.buf != null) {
                    if (ELEMENT_TITLE.equals(qName)) {
                        this.item.setLabel(this.buf.toString().trim());
                        this.buf = null;
                    } else if (ELEMENT_LINK.equals(qName)) {
                        this.item.setUrl(this.buf.toString().trim());
                        this.buf = null;
                    }
                } else if (ELEMENT_ITEM.equals(qName)) {
                    if (this.item.label != null && this.item.label.length() > 0 && this.item.url != null && this.item.url.length() > 0) {
                        RSSViewer.this.items.add(this.item);
                    }
                    this.item = null;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(new String(ch, start, length));
            }
        }
    }

    private class TimeoutThread
    extends Thread {
        private TimeoutThread() {
        }

        public void run() {
            try {
                Thread.sleep(6000L);
            }
            catch (Exception ex) {
                BitsPlugin.logError("Timeout failed.", ex);
            }
            if (RSSViewer.this.threadRunning) {
                RSSViewer.this.threadRunning = false;
                RSSViewer.this.refresh();
            }
        }
    }
}

