/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.welcome.bits.contentproviders;

import com.ibm.ccl.welcome.bits.contentproviders.BrochureNav;
import com.ibm.ccl.welcome.bits.contentproviders.BrochureNavIdException;
import com.ibm.ccl.welcome.internal.brochures.loader.Page;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.internal.intro.impl.swt.PageStyleManager;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IIntroXHTMLContentProvider;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TopBrochureNav
extends BrochureNav
implements IIntroXHTMLContentProvider {
    private ImageHyperlink imageLinks = null;
    private boolean disposed;
    private Composite client;
    private Image pageImageSmall = null;
    private Image pageImageLarge = null;
    private String id;
    private FormToolkit toolkit;
    private Composite parent;

    public void createContent(String id, Element parent) {
        try {
            this.setUp(id, parent);
        }
        catch (BrochureNavIdException e) {
            if (Platform.inDebugMode()) {
                parent.appendChild(this.dom.createTextNode(e.getMessage()));
            }
            return;
        }
        Element brochureNavDiv = this.dom.createElement("div");
        brochureNavDiv.setAttribute("class", "toolbar");
        Element brochureGradient = this.dom.createElement("div");
        brochureGradient.setAttribute("class", "toolbar-gradient");
        brochureGradient.appendChild(this.dom.createComment("Div needs contents to space correctly"));
        Element brochureTitle = this.dom.createElement("div");
        brochureTitle.setAttribute("class", "toolbar-title");
        brochureTitle.appendChild(this.dom.createTextNode(this.currentBrochure.getTitle()));
        brochureTitle.appendChild(this.dom.createComment("Adding this comment causes images to float right"));
        Element brochureGrey = this.dom.createElement("div");
        brochureGrey.setAttribute("class", "toolbar-background");
        brochureGrey.appendChild(this.dom.createComment("Div needs contents to space correctly"));
        Element navImagesDiv = this.dom.createElement("div");
        navImagesDiv.setAttribute("class", "images");
        this.addImages(navImagesDiv);
        brochureNavDiv.appendChild(brochureGradient);
        brochureNavDiv.appendChild(brochureTitle);
        brochureNavDiv.appendChild(brochureGrey);
        brochureNavDiv.appendChild(navImagesDiv);
        parent.appendChild(brochureNavDiv);
    }

    private void addImages(Element navImagesDiv) {
        Page pageToAdd = this.currentBrochure.page(0);
        do {
            Element image = this.dom.createElement("img");
            image.setAttribute("class", "brochure-page");
            if (pageToAdd.equals(this.currentPage)) {
                image.setAttribute("src", this.sizeImage(pageToAdd.getIcon(), 38));
                navImagesDiv.appendChild(image);
                continue;
            }
            image.setAttribute("src", this.sizeImage(pageToAdd.getIcon(), 16));
            Element pageLink = this.dom.createElement("a");
            pageLink.setAttribute("href", "http://org.eclipse.ui.intro/showPage?id=" + pageToAdd.getId());
            pageLink.setAttribute("alt", pageToAdd.getTitle());
            pageLink.appendChild(image);
            navImagesDiv.appendChild(pageLink);
        } while ((pageToAdd = pageToAdd.getNext()) != null);
    }

    private String sizeImage(String icon, int size) {
        int extension = icon.length() - 4;
        String s = String.valueOf(icon.substring(0, extension - 2)) + size + icon.substring(extension);
        return s;
    }

    public void init(IIntroContentProviderSite site) {
    }

    public void createContent(String id, PrintWriter out) {
        try {
            DocumentBuilder loader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = loader.newDocument();
            Element parent = document.createElement("div");
            parent.setAttribute("ID", "brochure");
            this.createContent(id, parent);
            System.out.println(this.getStringRepresentation(parent));
            out.write(this.getStringRepresentation(parent));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        try {
            this.setUp(id);
        }
        catch (BrochureNavIdException e) {
            if (Platform.inDebugMode()) {
                System.out.println(e.getMessage());
            }
            return;
        }
        Page pageToAdd = this.currentBrochure.page(0);
        this.client = toolkit.createComposite(parent);
        TableWrapData td = new TableWrapData(128, 128);
        td.grabHorizontal = true;
        this.client.setLayoutData((Object)td);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 1;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.client.setLayout((Layout)gridLayout);
        Label label = toolkit.createLabel(this.client, this.currentBrochure.getTitle());
        label.setFont(PageStyleManager.getBannerFont());
        label.setLayoutData((Object)gridData);
        Composite pages = toolkit.createComposite(this.client);
        RowLayout rowLayout = new RowLayout();
        rowLayout.fill = true;
        rowLayout.wrap = false;
        rowLayout.spacing = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.type = 256;
        rowLayout.justify = false;
        rowLayout.pack = true;
        pages.setLayout((Layout)rowLayout);
        if (this.pageImageSmall == null) {
            this.pageImageSmall = new Image((Device)parent.getDisplay(), this.sizeImage(pageToAdd.getIcon(), 16).substring(5));
            this.pageImageLarge = new Image((Device)parent.getDisplay(), this.sizeImage(pageToAdd.getIcon(), 38).substring(5));
        }
        do {
            this.imageLinks = toolkit.createImageHyperlink(pages, 0);
            this.imageLinks.setHref((Object)("http://org.eclipse.ui.intro/showPage?id=" + pageToAdd.getId()));
            if (pageToAdd.equals(this.currentPage)) {
                this.imageLinks.setImage(this.pageImageLarge);
            } else {
                this.imageLinks.setImage(this.pageImageSmall);
            }
            this.imageLinks.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    TopBrochureNav.this.doNavigate((String)e.getHref());
                }
            });
        } while ((pageToAdd = pageToAdd.getNext()) != null);
    }

    private void doNavigate(final String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)url);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
                TopBrochureNav.this.openBrowser(url);
            }
        });
    }

    private void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void dispose() {
        if (this.pageImageLarge != null) {
            this.pageImageLarge.dispose();
        }
        if (this.pageImageSmall != null) {
            this.pageImageSmall.dispose();
        }
        if (this.client != null) {
            this.client.dispose();
        }
        this.disposed = true;
    }
}

